/*
 * Decompiled with CFR 0.152.
 */
package com.shengmu.camera;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.shengmu.camera.Gb28181SipService;
import com.shengmu.mapper.CameraMapper;
import com.shengmu.mapper.TrafficEventMapper;
import com.shengmu.modal.entity.Camera;
import com.shengmu.modal.entity.TrafficEvent;
import com.shengmu.utils.ResponseResult;
import java.io.File;
import java.time.LocalDateTime;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"gb28181"})
public class Gb28181Controller {
    @Autowired
    private Gb28181SipService sipService;
    @Resource
    private CameraMapper cameraMapper;
    @Resource
    private TrafficEventMapper trafficEventMapper;

    @GetMapping(value={"/start/{deviceId}"})
    public ResponseResult startStream(@PathVariable String deviceId) {
        boolean success = this.sipService.startStream(deviceId, deviceId, false);
        return success ? ResponseResult.success() : ResponseResult.error();
    }

    @GetMapping(value={"/stop/{deviceId}"})
    public ResponseResult stopStream(@PathVariable String deviceId) {
        boolean success = this.sipService.stopStream(deviceId);
        return success ? ResponseResult.success() : ResponseResult.error();
    }

    @GetMapping(value={"/camera/list"})
    public ResponseResult cameraList() {
        List cameraList = this.cameraMapper.selectList((Wrapper)Wrappers.lambdaQuery().orderByAsc(Camera::getName));
        return ResponseResult.success((Object)cameraList);
    }

    @GetMapping(value={"/video"})
    public ResponseEntity<?> serveSimpleVideo(@RequestParam String videoPath) {
        File videoFile = new File(videoPath);
        if (!videoFile.exists()) {
            return ResponseEntity.notFound().build();
        }
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("Content-Type", new String[]{"video/mp4"})).body((Object)new FileSystemResource(videoFile));
    }

    @GetMapping(value={"/trafficEventList"})
    public ResponseResult getTrafficEventList(@RequestParam int pageNo, @RequestParam int pageSize) {
        Page page = new Page((long)pageNo, (long)pageSize);
        IPage trafficEventIPage = this.trafficEventMapper.selectPage((IPage)page, (Wrapper)Wrappers.lambdaQuery().orderByDesc(TrafficEvent::getCreateTime));
        return ResponseResult.success((Object)trafficEventIPage);
    }

    @GetMapping(value={"/sendCatalogQuery"})
    public ResponseResult sendCatalogQuery() throws Exception {
        this.sipService.sendCatalogQuery();
        return ResponseResult.success();
    }

    @PostMapping(value={"/addTraffic"})
    public ResponseResult addTraffic(@RequestBody TrafficEvent trafficEvent) {
        trafficEvent.setCreateTime(LocalDateTime.now());
        this.trafficEventMapper.insert((Object)trafficEvent);
        return ResponseResult.success();
    }
}

