/*
 * Decompiled with CFR 0.152.
 */
package com.shengmu.camera;

import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.shengmu.camera.SessionInfo;
import com.shengmu.mapper.CameraMapper;
import com.shengmu.mapper.ExpWarningMapper;
import com.shengmu.modal.entity.Camera;
import com.shengmu.modal.entity.ExpWarning;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Scanner;
import java.util.UUID;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

@Component
public class Gb28181SipService {
    private final int SIP_PORT = 7100;
    private final String PLATFORM_ID = "33021300002000234234";
    private final String LOCAL_IP = "33.65.60.98";
    private static final String DEVICE_IP = "33.65.60.99";
    private static final int DEVICE_SIP_PORT = 6061;
    private final String TO_TAG = this.generateTag();
    private final String DEVICE_ID = "33021301072008990009";
    private final String DEVICE_PASSWORD = "123456";
    String zlmediakitUrl = "http://192.168.1.20:99";
    String zlmediakitSecret = "FpvUDVyWlqohv98EEE5Of3UcFhc18Ipt";
    String videoDir = "G:\\zlmediakit\\www\\record\\rtp";
    private DatagramSocket sipSocket;
    private final Map<String, SessionInfo> activeSessions = new ConcurrentHashMap();
    private final AtomicInteger CSEQ_COUNTER = new AtomicInteger(1);
    private final ScheduledExecutorService scheduler;
    private final Map<String, ScheduledFuture<?>> activeRecordings = new ConcurrentHashMap();
    public static final BlockingQueue<Map<String, String>> moveFileQueue = new LinkedBlockingQueue();
    @Autowired
    private CameraMapper cameraMapper;
    @Autowired
    private ExpWarningMapper expWarningMapper;
    private final OkHttpClient httpClient = new OkHttpClient.Builder().connectTimeout(10L, TimeUnit.SECONDS).writeTimeout(10L, TimeUnit.SECONDS).readTimeout(10L, TimeUnit.SECONDS).build();
    private final ObjectMapper objectMapper = new ObjectMapper();
    private volatile boolean running = true;
    @Value(value="${custom-config.app-type}")
    private int appType;

    public Gb28181SipService() {
        this.scheduler = Executors.newScheduledThreadPool(4, r -> {
            Thread t = new Thread(r, "RecordingScheduler");
            t.setDaemon(true);
            return t;
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int openRtpServer(String streamId, boolean recording) {
        JSONObject json = new JSONObject();
        json.put("secret", (Object)this.zlmediakitSecret);
        json.put("port", (Object)0);
        json.put("enable_tcp", (Object)false);
        json.put("stream_id", (Object)streamId);
        json.put("timeout", (Object)60);
        RequestBody body = RequestBody.create((String)json.toString(), (MediaType)MediaType.get((String)"application/json; charset=utf-8"));
        Request request = new Request.Builder().url(this.zlmediakitUrl + "/index/api/openRtpServer").post(body).build();
        try (Response response = this.httpClient.newCall(request).execute();){
            if (!response.isSuccessful() || response.body() == null) {
                System.err.println("ZLMediaKit openRtpServer \u8bf7\u6c42\u5931\u8d25: " + response.code());
                int n = -1;
                return n;
            }
            String responseBody = response.body().string();
            JsonNode root = this.objectMapper.readTree(responseBody);
            int code = root.get("code").asInt();
            if (code == 0) {
                int port = root.get("port").asInt();
                if (recording) {
                    this.scheduler.schedule(() -> this.startRecord(streamId), 4L, TimeUnit.SECONDS);
                }
                System.out.println("ZLMediaKit \u4e3a stream_id=" + streamId + " \u5206\u914d\u7aef\u53e3: " + port);
                int n = port;
                return n;
            }
            System.err.println("ZLMediaKit API \u9519\u8bef: " + responseBody);
            if (root.get("msg").asText().equals("This stream already exists") && recording) {
                System.out.println("\u6d41\u5df2\u5b58\u5728");
                this.scheduler.schedule(() -> this.startRecord(streamId), 4L, TimeUnit.SECONDS);
            }
            int n = -1;
            return n;
        }
        catch (IOException e) {
            e.printStackTrace();
            return -1;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean closeRtpServer(String streamId, int port) {
        JSONObject json = new JSONObject();
        json.put("secret", (Object)this.zlmediakitSecret);
        json.put("stream_id", (Object)streamId);
        RequestBody body = RequestBody.create((String)json.toString(), (MediaType)MediaType.get((String)"application/json; charset=utf-8"));
        Request request = new Request.Builder().url(this.zlmediakitUrl + "/index/api/closeRtpServer").post(body).build();
        try (Response response = this.httpClient.newCall(request).execute();){
            if (!response.isSuccessful() || response.body() == null) {
                System.err.println("ZLMediaKit closeRtpServer \u8bf7\u6c42\u5931\u8d25: " + response.code());
                boolean bl = false;
                return bl;
            }
            String responseBody = response.body().string();
            JsonNode root = this.objectMapper.readTree(responseBody);
            int code = root.get("code").asInt();
            if (code == 0) {
                System.out.println("ZLMediaKit \u6210\u529f\u5173\u95ed RTP \u670d\u52a1\uff0cstream_id=" + streamId);
                boolean bl = true;
                return bl;
            }
            System.err.println("ZLMediaKit closeRtpServer API \u9519\u8bef: " + responseBody);
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public void startRecord(String streamId) {
        Request request = new Request.Builder().url(this.zlmediakitUrl + "/index/api/startRecord?secret=" + this.zlmediakitSecret + "&type=1&vhost=__defaultVhost__&app=rtp&stream=" + streamId).get().build();
        try (Response response = this.httpClient.newCall(request).execute();){
            String responseBody;
            JsonNode root;
            int code;
            if (!response.isSuccessful() || response.body() == null) {
                System.err.println("ZLMediaKit openRtpServer \u8bf7\u6c42\u5931\u8d25: " + response.code());
            }
            if ((code = (root = this.objectMapper.readTree(responseBody = response.body().string())).get("code").asInt()) == 0) {
                System.err.println("\u5f00\u59cb\u5f55\u5236: " + streamId);
                ScheduledFuture<?> future = this.scheduler.schedule(() -> this.stopRecord(streamId), 21L, TimeUnit.SECONDS);
                this.activeRecordings.put(streamId, future);
            } else {
                System.err.println("\u5f00\u542f\u5f55\u5236\u5931\u8d25-" + streamId + "-ZLMediaKit API \u9519\u8bef: " + responseBody);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void stopRecord(String streamId) {
        Request request = new Request.Builder().url(this.zlmediakitUrl + "/index/api/stopRecord?secret=" + this.zlmediakitSecret + "&type=1&vhost=__defaultVhost__&app=rtp&stream=" + streamId).get().build();
        try (Response response = this.httpClient.newCall(request).execute();){
            String responseBody;
            JsonNode root;
            int code;
            if (!response.isSuccessful() || response.body() == null) {
                System.err.println("ZLMediaKit openRtpServer \u8bf7\u6c42\u5931\u8d25: " + response.code());
            }
            if ((code = (root = this.objectMapper.readTree(responseBody = response.body().string())).get("code").asInt()) == 0) {
                System.err.println("\u7ed3\u675f\u5f55\u5236: " + streamId);
                String today = LocalDate.now().format(DateTimeFormatter.ISO_LOCAL_DATE);
                String sourceDir = this.videoDir + File.separator + streamId;
                String targetDir = this.videoDir + File.separator + today + File.separator + streamId.split("_")[0] + File.separator + streamId;
                String dirPath = this.videoDir + File.separator + today + File.separator + streamId.split("_")[0] + File.separator + streamId + File.separator + today;
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("sourceDir", sourceDir);
                map.put("targetDir", targetDir);
                map.put("dirPath", dirPath);
                map.put("id", streamId.split("_")[0]);
                moveFileQueue.add(map);
            } else {
                System.err.println("\u5173\u95ed\u5f55\u5236\u5931\u8d25-" + streamId + "-ZLMediaKit API \u9519\u8bef: " + responseBody);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @PostConstruct
    public void startSipListener() throws SocketException {
        if (this.appType != 2) {
            return;
        }
        this.sipSocket = new DatagramSocket(7100);
        System.out.println("\ud83d\udce1 GB28181 SIP \u670d\u52a1\u542f\u52a8\uff0c\u76d1\u542c UDP \u7aef\u53e3: 7100");
        new Thread(() -> {
            byte[] buffer = new byte[2048];
            while (this.running) {
                DatagramPacket packet = new DatagramPacket(buffer, buffer.length);
                try {
                    this.sipSocket.receive(packet);
                }
                catch (IOException e) {
                    if (!this.running) break;
                    System.err.println("\u63a5\u6536\u6570\u636e\u5305\u5931\u8d25: " + e.getMessage());
                }
                String request = null;
                try {
                    request = new String(packet.getData(), 0, packet.getLength(), "GB2312");
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
                System.out.println("\n\ud83d\udce5 \u6536\u5230\u6765\u81ea " + packet.getAddress() + ":" + packet.getPort() + " \u7684\u8bf7\u6c42:");
                if (request.startsWith("REGISTER")) {
                    this.handleRegister(this.sipSocket, packet, request);
                    continue;
                }
                if (request.startsWith("MESSAGE")) {
                    this.handleMessage(this.sipSocket, packet, request);
                    continue;
                }
                if (!request.startsWith("SIP/2.0")) continue;
                this.handleSipResponse(this.sipSocket, packet, request);
            }
        }, "SIP-Listener").start();
    }

    @PreDestroy
    public void stop() {
        this.running = false;
        if (this.sipSocket != null && !this.sipSocket.isClosed()) {
            this.sipSocket.close();
        }
        this.activeSessions.keySet().forEach(arg_0 -> this.stopStream(arg_0));
        for (Map.Entry entry : this.activeRecordings.entrySet()) {
            ((ScheduledFuture)entry.getValue()).cancel(false);
            this.stopRecord((String)entry.getKey());
        }
        this.scheduler.shutdown();
    }

    public boolean startStream(String deviceId, String streamId, boolean recording) {
        try {
            this.sendInvite(this.sipSocket, deviceId, streamId, recording);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean stopStream(String deviceId) {
        SessionInfo info = (SessionInfo)this.activeSessions.remove(deviceId);
        if (info == null) {
            return false;
        }
        try {
            this.sendBye(this.sipSocket, info);
            this.closeRtpServer(deviceId, info.getLocalRtpPort());
            System.out.println("\u23f9\ufe0f \u5df2\u505c\u6b62\u8bbe\u5907 " + deviceId + " \u7684\u62c9\u6d41");
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private void sendInvite(DatagramSocket socket, String deviceId, String streamId, boolean recording) throws Exception {
        int mediaPort = this.openRtpServer(streamId, recording);
        if (mediaPort == -1) {
            System.out.println("zlmediakit \u6253\u5f00rtp\u5931\u8d25");
            return;
        }
        int cseq = this.CSEQ_COUNTER.getAndIncrement();
        String callId = UUID.randomUUID().toString();
        String fromTag = UUID.randomUUID().toString().replace("-", "").substring(0, 12);
        String branch = "z9hG4bK" + UUID.randomUUID().toString().replace("-", "").substring(0, 16);
        int ssrc = 305419896;
        String sdp = this.buildSdp(mediaPort, ssrc, deviceId);
        byte[] sdpBytes = sdp.getBytes("GB2312");
        StringBuilder sb = new StringBuilder();
        sb.append("INVITE sip:").append(deviceId).append("@").append(DEVICE_IP).append(":").append(6061).append(" SIP/2.0\r\n");
        sb.append("Via: SIP/2.0/UDP ").append("33.65.60.98").append(":").append(7100).append(";branch=").append(branch).append("\r\n");
        sb.append("From: <sip:").append("33021300002000234234").append("@").append("33.65.60.98").append(">;tag=").append(fromTag).append("\r\n");
        sb.append("To: <sip:").append(deviceId).append("@").append(DEVICE_IP).append(">\r\n");
        sb.append("Call-ID: ").append(callId).append("\r\n");
        sb.append("CSeq: ").append(cseq).append(" INVITE\r\n");
        sb.append("Contact: <sip:").append("33021300002000234234").append("@").append("33.65.60.98").append(":").append(7100).append(">\r\n");
        sb.append("Content-Type: application/sdp\r\n");
        sb.append("Max-Forwards: 70\r\n");
        sb.append("Subject: ").append("33021300002000234234").append(":").append(deviceId).append("\r\n");
        sb.append("Content-Length: ").append(sdpBytes.length).append("\r\n");
        sb.append("\r\n");
        sb.append(sdp);
        byte[] inviteBytes = sb.toString().getBytes("GB2312");
        DatagramPacket packet = new DatagramPacket(inviteBytes, inviteBytes.length, InetAddress.getByName(DEVICE_IP), 6061);
        System.out.println("\ud83d\udce1 \u53d1\u9001\u7684 INVITE \u6d88\u606f:\n" + new String(inviteBytes, "GB2312") + "\n--- END INVITE ---");
        socket.send(packet);
        SessionInfo session = new SessionInfo(deviceId, DEVICE_IP, 6061, mediaPort);
        session.setCallId(callId);
        session.setInviteCSeq((long)cseq);
        this.activeSessions.put(deviceId, session);
    }

    public void sendCatalogQuery() throws Exception {
        int cseq = this.CSEQ_COUNTER.getAndIncrement();
        String callId = UUID.randomUUID().toString();
        String fromTag = UUID.randomUUID().toString().replace("-", "").substring(0, 12);
        String branch = "z9hG4bK" + UUID.randomUUID().toString().replace("-", "").substring(0, 16);
        String xmlBody = String.format("<?xml version=\"1.0\"?>\r\n<Query>\r\n  <CmdType>Catalog</CmdType>\r\n  <SN>%d</SN>\r\n  <DeviceID>%s</DeviceID>\r\n</Query>", cseq, "33021301072008990009");
        byte[] xmlBytes = xmlBody.getBytes("GB2312");
        StringBuilder sb = new StringBuilder();
        sb.append("MESSAGE sip:").append("33021301072008990009").append("@").append(DEVICE_IP).append(":").append(6061).append(" SIP/2.0\r\n");
        sb.append("Via: SIP/2.0/UDP ").append("33.65.60.98").append(":").append(7100).append(";branch=").append(branch).append("\r\n");
        sb.append("From: <sip:").append("33021300002000234234").append("@").append("33.65.60.98").append(">;tag=").append(fromTag).append("\r\n");
        sb.append("To: <sip:").append("33021301072008990009").append("@").append(DEVICE_IP).append(">\r\n");
        sb.append("Call-ID: ").append(callId).append("\r\n");
        sb.append("CSeq: ").append(cseq).append(" MESSAGE\r\n");
        sb.append("Contact: <sip:").append("33021300002000234234").append("@").append("33.65.60.98").append(":").append(7100).append(">\r\n");
        sb.append("Content-Type: Application/MANSCDP+xml\r\n");
        sb.append("Max-Forwards: 70\r\n");
        sb.append("Content-Length: ").append(xmlBytes.length).append("\r\n");
        sb.append("\r\n");
        sb.append(xmlBody);
        byte[] messageBytes = sb.toString().getBytes("GB2312");
        DatagramPacket packet = new DatagramPacket(messageBytes, messageBytes.length, InetAddress.getByName(DEVICE_IP), 6061);
        System.out.println(" \u53d1\u9001 Catalog \u67e5\u8be2:\n" + new String(messageBytes, "GB2312") + "\n--- END CATALOG QUERY ---");
        this.sipSocket.send(packet);
    }

    private String buildSdp(int mediaPort, int ssrc, String deviceId) {
        return "v=0\r\no=" + deviceId + " 0 0 IN IP4 " + "33.65.60.98" + "\r\ns=Play\r\nc=IN IP4 " + "33.65.60.98" + "\r\nt=0 0\r\nm=video " + mediaPort + " RTP/AVP 96 97 98 99\r\na=recvonly\r\na=ssrc:" + ssrc + "\r\na=rtpmap:96 PS/90000\r\na=rtpmap:97 H264/90000\r\na=rtpmap:98 H264/90000\r\na=rtpmap:99 MPEG4/90000\r\n";
    }

    private void handleSipResponse(DatagramSocket socket, DatagramPacket packet, String response) {
        if (response.contains("CSeq:") && response.contains("INVITE") && response.startsWith("SIP/2.0 200 OK")) {
            String deviceId;
            SessionInfo session;
            String callId = this.extractHeader(response, "Call-ID:\\s*(.+?)\\s*(?:\r\n|$)");
            String from = this.extractHeader(response, "(From:\\s*.+?)\r\n");
            String to = this.extractHeader(response, "(To:\\s*.+?)\r\n");
            String cseq = this.extractHeader(response, "CSeq:\\s*(\\d+)\\s+INVITE");
            String via = this.extractHeader(response, "(Via:\\s*.+?)\r\n");
            String sdpBody = this.extractXmlBodyFromSip(response);
            if (sdpBody == null) {
                return;
            }
            String deviceRtpIp = null;
            int deviceRtpPort = -1;
            try (Scanner sc = new Scanner(sdpBody);){
                while (sc.hasNextLine()) {
                    String line = sc.nextLine().trim();
                    if (line.startsWith("c=IN IP4 ")) {
                        deviceRtpIp = line.substring(9);
                        continue;
                    }
                    if (!line.startsWith("m=video ")) continue;
                    deviceRtpPort = Integer.parseInt(line.split("\\s+")[1]);
                    break;
                }
            }
            if ((session = (SessionInfo)this.activeSessions.get(deviceId = this.extractDeviceIdFromTo(to))) != null && deviceRtpIp != null && deviceRtpPort > 0) {
                session.setDeviceRtpIp(deviceRtpIp);
                session.setDeviceRtpPort(deviceRtpPort);
                session.setSsrc(session.getSsrc());
                Pattern pattern = Pattern.compile("(From|To):.*?;tag=([^;\\r\\n]+)", 2);
                Matcher matcher = pattern.matcher(response);
                Object fromTag = null;
                String toTag = null;
                while (matcher.find()) {
                    String header = matcher.group(1);
                    String tag = matcher.group(2);
                    if (!"To".equalsIgnoreCase(header)) continue;
                    toTag = tag;
                }
                if (toTag != null) {
                    session.setRemoteTag(toTag);
                }
            }
            this.sendAck(socket, packet, callId, from, to, cseq, via);
        }
    }

    private String extractDeviceIdFromTo(String toHeader) {
        Pattern p = Pattern.compile("sip:([0-9]{20})@");
        Matcher m = p.matcher(toHeader);
        return m.find() ? m.group(1) : null;
    }

    private void sendAck(DatagramSocket socket, DatagramPacket responsePacket, String callId, String from, String to, String cseq, String via) {
        try {
            int sipIndex;
            int start;
            int end;
            String toUri = null;
            if (to.contains("<") && to.contains(">") && (end = to.indexOf(62, start = to.indexOf(60) + 1)) > start) {
                toUri = to.substring(start, end);
            }
            if (toUri == null && (sipIndex = to.indexOf("sip:")) != -1) {
                end = to.indexOf(59, sipIndex);
                if (end == -1) {
                    end = to.indexOf(13, sipIndex);
                }
                if (end == -1) {
                    end = to.length();
                }
                toUri = to.substring(sipIndex, end).trim();
            }
            if (toUri == null) {
                System.err.println("\u274c \u65e0\u6cd5\u4ece To \u5934\u63d0\u53d6 URI: " + to);
                return;
            }
            StringBuilder ack = new StringBuilder();
            ack.append("ACK ").append(toUri).append(" SIP/2.0\r\n");
            String viaLine = via.trim();
            if (!viaLine.contains("rport=")) {
                viaLine = viaLine + ";rport=" + responsePacket.getPort();
            }
            ack.append(viaLine).append("\r\n");
            ack.append(from).append("\r\n");
            ack.append(to).append("\r\n");
            ack.append("Call-ID: ").append(callId).append("\r\n");
            ack.append("CSeq: ").append(cseq).append(" ACK\r\n");
            ack.append("Max-Forwards: 70\r\n");
            ack.append("Content-Length: 0\r\n");
            ack.append("\r\n");
            byte[] ackBytes = ack.toString().getBytes("GB2312");
            DatagramPacket ackPacket = new DatagramPacket(ackBytes, ackBytes.length, responsePacket.getAddress(), responsePacket.getPort());
            socket.send(ackPacket);
            System.out.println("\ud83d\udce4 \u5df2\u53d1\u9001 ACK \u5230 " + responsePacket.getAddress() + ":" + responsePacket.getPort());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void sendBye(DatagramSocket socket, SessionInfo session) throws Exception {
        if (session.getRemoteTag() == null || session.getRemoteTag().isEmpty()) {
            throw new IllegalStateException("Remote tag is not available. Cannot send BYE.");
        }
        String branch = "z9hG4bK" + UUID.randomUUID().toString().replace("-", "").substring(0, 16);
        String fromTag = UUID.randomUUID().toString().substring(0, 12);
        String toTag = session.getRemoteTag();
        StringBuilder sb = new StringBuilder();
        sb.append("BYE sip:").append(session.getDeviceId()).append("@").append(session.getDeviceIp()).append(":").append(session.getDeviceSipPort()).append(" SIP/2.0\r\n");
        sb.append("Via: SIP/2.0/UDP ").append("33.65.60.98").append(":").append(7100).append(";branch=").append(branch).append("\r\n");
        sb.append("From: <sip:").append("33021300002000234234").append("@").append("33.65.60.98").append(">;tag=").append(fromTag).append("\r\n");
        sb.append("To: <sip:").append(session.getDeviceId()).append("@").append(session.getDeviceIp()).append(">;tag=").append(toTag).append("\r\n");
        sb.append("Call-ID: ").append(session.getCallId()).append("\r\n");
        sb.append("CSeq: ").append(session.getInviteCSeq() + 1L).append(" BYE\r\n");
        sb.append("Max-Forwards: 70\r\n");
        sb.append("Content-Length: 0\r\n\r\n");
        byte[] data = sb.toString().getBytes("GB2312");
        socket.send(new DatagramPacket(data, data.length, InetAddress.getByName(session.getDeviceIp()), session.getDeviceSipPort()));
        System.out.println(sb.toString());
    }

    private String extractHeader(String message, String regex) {
        Pattern p = Pattern.compile(regex, 34);
        Matcher m = p.matcher(message);
        if (m.find()) {
            if (m.groupCount() >= 1) {
                return m.group(1).trim();
            }
            return m.group(0).trim();
        }
        return null;
    }

    private String extractXmlBodyFromSip(String sipMessage) {
        int bodyStart = sipMessage.indexOf("\r\n\r\n");
        if (bodyStart == -1) {
            bodyStart = sipMessage.indexOf("\n\n");
            if (bodyStart == -1) {
                return null;
            }
            bodyStart += 2;
        } else {
            bodyStart += 4;
        }
        String body = sipMessage.substring(bodyStart);
        int firstTag = body.indexOf(60);
        return firstTag >= 0 ? body.substring(firstTag) : body.trim();
    }

    private void handleMessage(DatagramSocket socket, DatagramPacket packet, String request) {
        if (request.contains("<CmdType>Keepalive</CmdType>")) {
            System.out.println("\ud83d\udc93 \u6536\u5230\u8bbe\u5907\u4fdd\u6d3b\u6d88\u606f");
            this.sendSipResponse(socket, packet, request, 200, "OK");
        } else if (request.contains("<CmdType>Catalog</CmdType>")) {
            System.out.println("\ud83d\udccb \u6536\u5230\u8bbe\u5907\u76ee\u5f55\u4e0a\u62a5\uff01");
            String xmlBody = this.extractXmlBodyFromSip(request);
            if (xmlBody == null) {
                System.err.println("\u274c \u65e0\u6cd5\u63d0\u53d6 XML body");
                return;
            }
            System.out.println("\ud83d\udcc4 Catalog XML:\n" + xmlBody);
            this.parseAndPrint(xmlBody);
            this.sendSipResponse(socket, packet, request, 200, "OK");
        }
    }

    private void handleRegister(DatagramSocket socket, DatagramPacket packet, String request) {
        try {
            String fromUri = this.extractHeader(request, "From:.*<sip:([0-9]{20})@");
            if (fromUri == null || !fromUri.equals("33021301072008990009")) {
                System.err.println("\u26a0\ufe0f \u6536\u5230\u6765\u81ea\u672a\u77e5\u8bbe\u5907\u7684\u6ce8\u518c: " + fromUri);
                this.sendResponse(socket, packet, request, 403, "Forbidden", null, null);
                return;
            }
            if (request.contains("Authorization:")) {
                String nonce = this.extractHeader(request, "nonce=\"([^\"]+)\"");
                String response = this.extractHeader(request, "response=\"([^\"]+)\"");
                String uri = this.extractHeader(request, "uri=\"([^\"]+)\"");
                if (nonce == null || response == null || uri == null) {
                    this.sendResponse(socket, packet, request, 400, "Bad Request", null, null);
                    return;
                }
                String ha1 = this.md5("33021301072008990009:33021300002000234234:123456");
                String ha2 = this.md5("REGISTER:" + uri);
                String expectedResponse = this.md5(ha1 + ":" + nonce + ":" + ha2);
                if (expectedResponse.equals(response)) {
                    System.out.println("\u2705 \u8bbe\u5907 33021301072008990009 \u6ce8\u518c\u6210\u529f\uff01");
                    this.sendResponse(socket, packet, request, 200, "OK", "Contact: <sip:33021300002000234234@33.65.60.98:7100>", "Expires: 3600");
                } else {
                    System.out.println("\u274c Digest \u8ba4\u8bc1\u5931\u8d25");
                    this.sendResponse(socket, packet, request, 401, "Unauthorized", null, null);
                }
            } else {
                String nonce = this.generateNonce();
                String wwwAuth = "Digest realm=\"33021300002000234234\", nonce=\"" + nonce + "\", algorithm=MD5";
                this.sendResponse(socket, packet, request, 401, "Unauthorized", "WWW-Authenticate: " + wwwAuth, null);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.sendResponse(socket, packet, request, 500, "Internal Error", null, null);
        }
    }

    private void sendResponse(DatagramSocket socket, DatagramPacket requestPacket, String request, int code, String reason, String extraHeader1, String extraHeader2) {
        try {
            String callId = this.extractHeader(request, "Call-ID:\\s*(.+?)\\s*\r\n");
            String from = this.extractHeader(request, "(From:\\s*.+?)\r\n");
            String to = this.extractHeader(request, "(To:\\s*.+?)\r\n");
            String cseq = this.extractHeader(request, "(CSeq:\\s*.+?)\r\n");
            String via = this.extractHeader(request, "(Via:\\s*.+?)\r\n");
            if (callId == null || from == null || to == null || cseq == null || via == null) {
                System.err.println("\u274c SIP \u5934\u7f3a\u5931\uff0c\u65e0\u6cd5\u6784\u5efa\u54cd\u5e94");
                return;
            }
            StringBuilder response = new StringBuilder();
            response.append("SIP/2.0 ").append(code).append(" ").append(reason).append("\r\n");
            String fixedVia = via;
            fixedVia = !via.contains("rport=") ? via + ";rport=" + requestPacket.getPort() : via.replaceAll("rport(?=\\s|;|$)", "rport=" + requestPacket.getPort());
            response.append(fixedVia).append("\r\n");
            if (!to.contains("tag=")) {
                to = to + ";tag=" + this.TO_TAG;
            }
            response.append(to).append("\r\n");
            response.append(from).append("\r\n");
            response.append(cseq).append("\r\n");
            response.append("Call-ID: ").append(callId).append("\r\n");
            response.append("Server: Java-GB28181/1.0\r\n");
            response.append("Content-Length: 0\r\n");
            if (extraHeader1 != null) {
                response.append(extraHeader1).append("\r\n");
            }
            if (extraHeader2 != null) {
                response.append(extraHeader2).append("\r\n");
            }
            response.append("\r\n");
            byte[] responseData = response.toString().getBytes("UTF-8");
            DatagramPacket responsePacket = new DatagramPacket(responseData, responseData.length, requestPacket.getAddress(), requestPacket.getPort());
            socket.send(responsePacket);
            System.out.println("\ud83d\udce4 \u5df2\u53d1\u9001\u54cd\u5e94: " + code + " " + reason);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void sendSipResponse(DatagramSocket socket, DatagramPacket requestPacket, String request, int statusCode, String reason) {
        try {
            String callId = this.extractHeader(request, "Call-ID:\\s*(.+?)\\s*(?:\r\n|$)");
            String from = this.extractHeader(request, "(From:\\s*.+?)\r\n");
            String to = this.extractHeader(request, "(To:\\s*.+?)\r\n");
            String cseq = this.extractHeader(request, "(CSeq:\\s*.+?)\r\n");
            String via = this.extractHeader(request, "(Via:\\s*.+?)\r\n");
            if (callId == null || from == null || to == null || cseq == null || via == null) {
                System.err.println("\u274c SIP \u8bf7\u6c42\u5934\u7f3a\u5931\uff0c\u65e0\u6cd5\u6784\u5efa\u54cd\u5e94");
                return;
            }
            StringBuilder sb = new StringBuilder();
            sb.append("SIP/2.0 ").append(statusCode).append(" ").append(reason).append("\r\n");
            String fixedVia = via;
            if (via.contains("rport") && !via.contains("rport=")) {
                fixedVia = via.replaceFirst("rport(?=\\s|;|$)", "rport=" + requestPacket.getPort());
            } else if (!via.contains("rport")) {
                fixedVia = via + ";rport=" + requestPacket.getPort();
            }
            sb.append(fixedVia).append("\r\n");
            if (!to.contains("tag=")) {
                to = to + ";tag=" + this.generateTag();
            }
            sb.append(to).append("\r\n");
            sb.append(from).append("\r\n");
            sb.append(cseq).append("\r\n");
            sb.append("Call-ID: ").append(callId).append("\r\n");
            sb.append("Server: Java-GB28181/1.0\r\n");
            sb.append("Content-Length: 0\r\n");
            sb.append("\r\n");
            byte[] responseBytes = sb.toString().getBytes("UTF-8");
            DatagramPacket responsePacket = new DatagramPacket(responseBytes, responseBytes.length, requestPacket.getAddress(), requestPacket.getPort());
            socket.send(responsePacket);
            System.out.println("\ud83d\udce4 \u5df2\u53d1\u9001 SIP \u54cd\u5e94: " + statusCode + " " + reason);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void parseAndPrint(String xmlStr) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(new InputSource(new StringReader(xmlStr)));
            NodeList items = doc.getElementsByTagName("Item");
            for (int i = 0; i < items.getLength(); ++i) {
                Element item = (Element)items.item(i);
                String deviceId = this.getElementText(item, "DeviceID");
                String name = this.getElementText(item, "Name");
                System.out.println("DeviceID: " + deviceId + " | Name: " + name);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String getElementText(Element parent, String tagName) {
        Node node = parent.getElementsByTagName(tagName).item(0);
        return node != null && node.getTextContent() != null ? node.getTextContent().trim() : "";
    }

    private String generateNonce() {
        return Long.toHexString(System.currentTimeMillis() + new SecureRandom().nextLong());
    }

    private String generateTag() {
        return Long.toHexString(System.currentTimeMillis() + new SecureRandom().nextLong()).substring(0, 10);
    }

    private String md5(String data) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] digest = md.digest(data.getBytes("UTF-8"));
            StringBuilder sb = new StringBuilder();
            for (byte b : digest) {
                sb.append(String.format("%02x", b));
            }
            return sb.toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public List<String> recording(ExpWarning expWarning) {
        ArrayList<String> videoList = new ArrayList<String>();
        if (this.appType != 2) {
            return videoList;
        }
        String today = LocalDate.now().format(DateTimeFormatter.ISO_LOCAL_DATE);
        Path targetDir = Paths.get(this.videoDir, today, expWarning.getId().toString().trim());
        if (!Files.exists(targetDir, new LinkOption[0])) {
            try {
                Files.createDirectories(targetDir, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new RuntimeException("\u521b\u5efa\u5f53\u65e5\u5f55\u5236\u76ee\u5f55\u5931\u8d25: " + targetDir, e);
            }
        }
        List cameraList = this.cameraMapper.selectList((Wrapper)Wrappers.lambdaQuery());
        List sorted = cameraList.stream().sorted(Comparator.comparingDouble(Camera::getDistance)).collect(Collectors.toList());
        ArrayList<Camera> lessOrEqual = new ArrayList<Camera>();
        ArrayList<Camera> greaterOrEqual = new ArrayList<Camera>();
        for (Camera cam2 : sorted) {
            if (cam2.getDistance() <= expWarning.getDistance()) {
                lessOrEqual.add(cam2);
                continue;
            }
            greaterOrEqual.add(cam2);
        }
        ArrayList before = new ArrayList();
        int lessSize = lessOrEqual.size();
        if (lessSize > 0) {
            int start = Math.max(0, lessSize - 2);
            before = new ArrayList(lessOrEqual.subList(start, lessSize));
        }
        ArrayList after = new ArrayList();
        if (!greaterOrEqual.isEmpty()) {
            int end = Math.min(2, greaterOrEqual.size());
            after = new ArrayList(greaterOrEqual.subList(0, end));
        }
        ArrayList result = new ArrayList(before);
        result.addAll(after);
        double targetDist = expWarning.getDistance().intValue();
        Optional<Camera> mainCameraOpt = result.stream().min(Comparator.comparingDouble(cam -> Math.abs((double)cam.getDistance().intValue() - targetDist)));
        if (mainCameraOpt.isPresent()) {
            Camera mainCamera = mainCameraOpt.get();
            if (mainCamera.getDistance() >= expWarning.getDistance() - 500 && mainCamera.getDistance() <= expWarning.getDistance() + 500) {
                String streamId = expWarning.getId().toString() + "_" + mainCamera.getName().substring(2, mainCamera.getName().length()).replace("+", "_");
                videoList.add("http://192.168.1.20:99/rtp/" + streamId + ".live.mp4");
                this.startStream(mainCamera.getDeviceId(), streamId, true);
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException("Thread.sleep(500)\u62a5\u9519,\u5f55\u5236\u4e2d\u65ad", e);
            }
            for (Camera camera : result) {
                if (camera.getDeviceId().equals(mainCamera.getDeviceId()) || camera.getDistance() < expWarning.getDistance() - 500 || camera.getDistance() > expWarning.getDistance() + 500) continue;
                String streamId = expWarning.getId().toString() + "_" + camera.getName().substring(2, camera.getName().length()).replace("+", "_");
                videoList.add("http://192.168.1.20:99/rtp/" + streamId + ".live.mp4");
                this.startStream(camera.getDeviceId(), streamId, true);
            }
        }
        return videoList;
    }

    @Scheduled(cron="0 */1 * * * ?")
    public void checkStream() {
        if (this.appType != 2) {
            return;
        }
        Request request = new Request.Builder().url(this.zlmediakitUrl + "/index/api/getMediaList?secret=" + this.zlmediakitSecret).get().build();
        try (Response response = this.httpClient.newCall(request).execute();){
            if (!response.isSuccessful()) {
                throw new IOException("\u8bf7\u6c42\u5931\u8d25: " + response);
            }
            String responseBody = response.body().string();
            JSONObject root = new JSONObject((Object)responseBody);
            if (root.getInt((Object)"code") != 0) {
                System.err.println("API \u8fd4\u56de\u9519\u8bef: " + root.getStr((Object)"msg", "\u672a\u77e5\u9519\u8bef"));
                return;
            }
            JSONArray data = root.getJSONArray((Object)"data");
            if (data == null) {
                return;
            }
            boolean longVideoExit = false;
            for (int i = 0; i < data.size(); ++i) {
                JSONObject stream = data.getJSONObject((Object)i);
                String streamId = stream.getStr((Object)"stream");
                int readerCount = stream.getInt((Object)"readerCount");
                long aliveSecond = stream.getLong((Object)"aliveSecond");
                System.out.println("\u6d41ID: " + streamId);
                System.out.println("  \u89c2\u770b\u4eba\u6570: " + readerCount);
                System.out.println("  \u5b58\u6d3b\u65f6\u95f4(\u79d2): " + aliveSecond);
                if (streamId.equals("33021301071318990004")) {
                    longVideoExit = true;
                }
                if (readerCount == 0 && aliveSecond > 60L && !streamId.equals("33021301071318990004")) {
                    this.closeStream(streamId);
                }
                if (aliveSecond <= 600L || streamId.equals("33021301071318990004")) continue;
                this.closeStream(streamId);
            }
            if (!longVideoExit) {
                System.out.println("33021301071318990004longVideoExit\u4e0d\u5b58\u5728\u91cd\u65b0\u521b\u5efa");
                this.startStream("33021301071318990004", "33021301071318990004", false);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Scheduled(fixedRate=5000L)
    public void moveFile() {
        Map map;
        if (!moveFileQueue.isEmpty() && (map = (Map)moveFileQueue.poll()) != null) {
            try {
                if (new File((String)map.get("sourceDir")).exists()) {
                    Files.move(Paths.get((String)map.get("sourceDir"), new String[0]), Paths.get((String)map.get("targetDir"), new String[0]), new CopyOption[0]);
                    String dirPath = (String)map.get("dirPath");
                    String id = (String)map.get("id");
                    List fileNames = Files.list(Paths.get(dirPath, new String[0])).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).map(Path::getFileName).map(Path::toString).collect(Collectors.toList());
                    if (!fileNames.isEmpty()) {
                        String fileName = dirPath + File.separator + (String)fileNames.get(0);
                        ExpWarning expWarning = (ExpWarning)this.expWarningMapper.selectById((Serializable)((Object)id));
                        if (StrUtil.isEmpty((CharSequence)expWarning.getVideoPath())) {
                            expWarning.setVideoPath(fileName);
                        } else {
                            expWarning.setVideoPath(expWarning.getVideoPath().concat(",").concat(fileName));
                        }
                        this.expWarningMapper.updateById((Object)expWarning);
                        System.out.println("\u9884\u8b66id == " + id + "   \u6587\u4ef6\u8def\u5f84 == " + fileName);
                    }
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void closeStream(String streamId) {
        Request request = new Request.Builder().url(this.zlmediakitUrl + "/index/api/close_stream?secret=" + this.zlmediakitSecret + "&schema=fmp4&vhost=__defaultVhost__&app=rtp&stream=" + streamId).get().build();
        try (Response response = this.httpClient.newCall(request).execute();){
            if (!response.isSuccessful()) {
                throw new IOException("\u8bf7\u6c42\u5931\u8d25: " + response);
            }
            String responseBody = response.body().string();
            JSONObject root = new JSONObject((Object)responseBody);
            if (root.getInt((Object)"code") == 0) {
                System.err.println("\u5220\u9664\u6210\u529f : " + streamId);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

