/*
 * Decompiled with CFR 0.152.
 */
package com.shengmu.camera;

import com.shengmu.camera.RtcpKeepaliveService;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.time.Instant;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledFuture;
import javax.annotation.PreDestroy;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.stereotype.Service;

@Service
public class RtcpKeepaliveService {
    private final TaskScheduler taskScheduler;
    private final Map<String, KeepaliveTask> activeStreams = new ConcurrentHashMap();
    private static final long MAX_KEEPALIVE_DURATION_MS = 600000L;

    public RtcpKeepaliveService(TaskScheduler taskScheduler) {
        this.taskScheduler = taskScheduler;
    }

    public void startKeepalive(String streamKey, String remoteIp, int rtcpPort, int ssrc) {
        if (this.activeStreams.containsKey(streamKey)) {
            return;
        }
        Instant createTime = Instant.now();
        Runnable task = () -> {
            if (Instant.now().toEpochMilli() - createTime.toEpochMilli() > 600000L) {
                System.out.println("\u23f0 RTCP keepalive expired for " + streamKey + ", stopping...");
                this.stopKeepalive(streamKey);
                return;
            }
            try (DatagramSocket socket = new DatagramSocket();){
                byte[] packet = this.buildRtcpSr(ssrc);
                DatagramPacket datagram = new DatagramPacket(packet, packet.length, InetAddress.getByName(remoteIp), rtcpPort);
                socket.send(datagram);
                System.out.println("\u2705 RTCP SR sent to " + remoteIp + ":" + rtcpPort + " for " + streamKey);
            }
            catch (Exception e) {
                System.err.println("\u274c RTCP send failed for " + streamKey + ": " + e.getMessage());
            }
        };
        ScheduledFuture future = this.taskScheduler.scheduleAtFixedRate(task, 5000L);
        this.activeStreams.put(streamKey, new KeepaliveTask(future, createTime));
        System.out.println("\u25b6\ufe0f Started RTCP keepalive for " + streamKey + " (TTL: 10 min)");
    }

    public void stopKeepalive(String streamKey) {
        KeepaliveTask task = (KeepaliveTask)this.activeStreams.remove(streamKey);
        if (task != null) {
            task.future.cancel(true);
            System.out.println("\u23f9\ufe0f Stopped RTCP keepalive for " + streamKey);
        }
    }

    @PreDestroy
    public void shutdown() {
        this.activeStreams.keySet().forEach(arg_0 -> this.stopKeepalive(arg_0));
    }

    private byte[] buildRtcpSr(int ssrc) {
        byte[] packet = new byte[28];
        packet[0] = -127;
        packet[1] = -56;
        packet[2] = 0;
        packet[3] = (byte)(packet.length / 4 - 1);
        packet[4] = (byte)(ssrc >> 24);
        packet[5] = (byte)(ssrc >> 16);
        packet[6] = (byte)(ssrc >> 8);
        packet[7] = (byte)ssrc;
        long now = System.currentTimeMillis();
        packet[8] = (byte)(now >> 24);
        packet[9] = (byte)(now >> 16);
        packet[10] = (byte)(now >> 8);
        packet[11] = (byte)now;
        return packet;
    }
}

