/*
 * Decompiled with CFR 0.152.
 */
package com.shengmu.config;

import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONReader;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.shengmu.mapper.CarKRoadMapper;
import com.shengmu.mapper.CarTrackMapper;
import com.shengmu.mapper.DataLogMapper;
import com.shengmu.mapper.DataLogTempMapper;
import com.shengmu.mapper.DotDataMapper;
import com.shengmu.mapper.ExpWarningMapper;
import com.shengmu.mapper.ExpWarningTempMapper;
import com.shengmu.mapper.RoadInfoMapper;
import com.shengmu.mapper.StrainTemperatureMapper;
import com.shengmu.mapper.SystemConfigMapper;
import com.shengmu.modal.dto.CarTrackDTO;
import com.shengmu.modal.dto.CarTrackData;
import com.shengmu.modal.entity.CarKRoad;
import com.shengmu.modal.entity.CarTrack;
import com.shengmu.modal.entity.DataLog;
import com.shengmu.modal.entity.DataLogTemp;
import com.shengmu.modal.entity.DotData;
import com.shengmu.modal.entity.ExpWarning;
import com.shengmu.modal.entity.ExpWarningTemp;
import com.shengmu.modal.entity.RoadInfo;
import com.shengmu.modal.entity.StrainTemperature;
import com.shengmu.modal.entity.SystemConfig;
import com.shengmu.modal.vo.HomeData;
import com.shengmu.service.CarTrackV2Service;
import com.shengmu.service.CarTrackV3Service;
import com.shengmu.service.CarTrackV4Service;
import com.shengmu.utils.GeoUtil;
import com.shengmu.websocket.WarningSocketHandler;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;

@Configuration
@EnableScheduling
public class ScheduleTask {
    @Resource
    private CarTrackV4Service carTrackV4Service;
    @Resource
    private CarTrackV3Service carTrackV3Service;
    @Resource
    private CarTrackV2Service carTrackV2Service;
    @Resource
    private DataLogMapper dataLogMapper;
    @Resource
    private ExpWarningTempMapper expWarningTempMapper;
    @Resource
    private DataLogTempMapper dataLogTempMapper;
    @Resource
    private DotDataMapper dotDataMapper;
    @Resource
    private StrainTemperatureMapper strainTemperatureMapper;
    @Resource
    private WarningSocketHandler warningSocketHandler;
    @Resource
    private RedisTemplate redisTemplate;
    @Resource
    private CarTrackMapper carTrackMapper;
    @Resource
    private CarKRoadMapper carKRoadMapper;
    @Resource
    private RoadInfoMapper roadInfoMapper;
    @Resource
    private SystemConfigMapper systemConfigMapper;
    @Value(value="${custom-config.app-type}")
    private int appType;
    public static final BlockingQueue<String> upCarTackQueue = new LinkedBlockingQueue();
    public static final BlockingQueue<String> downCarTackQueue = new LinkedBlockingQueue();
    @Autowired
    private ExpWarningMapper expWarningMapper;
    private final OkHttpClient client = new OkHttpClient.Builder().connectTimeout(3L, TimeUnit.SECONDS).readTimeout(3L, TimeUnit.SECONDS).writeTimeout(3L, TimeUnit.SECONDS).build();

    @Scheduled(fixedRate=3000L)
    public void sendRealData() {
        if (this.appType != 1) {
            return;
        }
        Object roadInfoListObject = this.redisTemplate.opsForValue().get((Object)"carTrackDTO");
        if (roadInfoListObject != null) {
            CarTrackData carTrackData;
            int upDownValue;
            CarTrackDTO carTrackDTO = (CarTrackDTO)JSON.parseObject((String)roadInfoListObject.toString(), CarTrackDTO.class);
            DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
            if (carTrackDTO.getList().isEmpty()) {
                return;
            }
            List orientationConfigList = this.systemConfigMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SystemConfig::getConfigType, (Object)"orientation")).orderByAsc(SystemConfig::getConfigSort));
            List carWidthConfigList = this.systemConfigMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SystemConfig::getConfigType, (Object)"carWidth")).orderByAsc(SystemConfig::getConfigSort));
            float carWidth = Float.parseFloat(((SystemConfig)carWidthConfigList.get(0)).getConfigValue());
            SystemConfig hotCongestionParam = (SystemConfig)this.systemConfigMapper.selectOne((Wrapper)Wrappers.lambdaQuery().eq(SystemConfig::getConfigType, (Object)"hotCongestionParam"));
            SystemConfig hotSlowParam = (SystemConfig)this.systemConfigMapper.selectOne((Wrapper)Wrappers.lambdaQuery().eq(SystemConfig::getConfigType, (Object)"hotSlowParam"));
            SystemConfig statisticsAreaParam = (SystemConfig)this.systemConfigMapper.selectOne((Wrapper)Wrappers.lambdaQuery().eq(SystemConfig::getConfigType, (Object)"statisticsArea"));
            int roadStartDistance = Integer.parseInt(statisticsAreaParam.getConfigValue());
            int roadEndDistance = Integer.parseInt(statisticsAreaParam.getConfigValueExt());
            int hotCongestionCarCount = Integer.parseInt(hotCongestionParam.getConfigValue());
            int hotCongestionAveSpeed = Integer.parseInt(hotCongestionParam.getConfigValueExt());
            int hotSlowCarCount = Integer.parseInt(hotSlowParam.getConfigValue());
            int hotSlowSpeed = Integer.parseInt(hotSlowParam.getConfigValueExt());
            List statisticsList = carTrackDTO.getList().stream().filter(data -> data.getTime().isEqual(carTrackDTO.getEndTime())).collect(Collectors.toList());
            String dayKey = carTrackDTO.getStartTime().format(dateFormatter);
            List carKRoadList = this.carKRoadMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(CarKRoad::getType, (Object)1)).orderByAsc(CarKRoad::getId));
            ArrayList<String> kTagList = new ArrayList<String>();
            for (CarKRoad carKRoad : carKRoadList) {
                if (kTagList.contains(carKRoad.getKTag())) continue;
                kTagList.add(carKRoad.getKTag());
            }
            List hotRoadInfoList = this.roadInfoMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(RoadInfo::getType, (Object)2)).orderByAsc(RoadInfo::getRoadSort));
            List positiveRoadInfoList = this.allRoadStatistics(dayKey, 1);
            List negativeRoadInfoList = this.allRoadStatistics(dayKey, -1);
            List positiveCustomRoadInfoList = this.customRoadStatistics(dayKey, 1);
            List negativeCustomRoadInfoList = this.customRoadStatistics(dayKey, -1);
            List roadInfoList = new ArrayList();
            List customRoadInfoList = new ArrayList();
            int orientationValue = Integer.parseInt(((SystemConfig)orientationConfigList.get(0)).getConfigValue());
            boolean switchValue = orientationValue == (upDownValue = Integer.parseInt(((SystemConfig)orientationConfigList.get(0)).getConfigValueExt()));
            Iterator iterator = statisticsList.iterator();
            while (iterator.hasNext() && !(carTrackData = (CarTrackData)iterator.next()).getCarTempIdList().isEmpty()) {
                LocalDateTime dateTime;
                ArrayList<HomeData.DataItem> dataItemList = new ArrayList<HomeData.DataItem>();
                for (String kName : kTagList) {
                    HomeData.DataItem dataItem = new HomeData.DataItem();
                    dataItem.setValueX(kName);
                    dataItemList.add(dataItem);
                }
                int orientation = (Integer)carTrackData.getOrientationList().get(0);
                if (orientation == 1) {
                    roadInfoList = positiveRoadInfoList;
                } else if (orientation == -1) {
                    roadInfoList = negativeRoadInfoList;
                }
                if (orientation == 1) {
                    customRoadInfoList = positiveCustomRoadInfoList;
                } else if (orientation == -1) {
                    customRoadInfoList = negativeCustomRoadInfoList;
                }
                for (int i = 0; i < carTrackData.getCarTempIdList().size(); ++i) {
                    RoadInfo.CarItem carItem2;
                    RoadInfo.CarItem found;
                    Optional<RoadInfo.CarItem> optional;
                    int hour;
                    LocalDateTime dateTime2;
                    int distance = (Integer)carTrackData.getDistanceList().get(i);
                    String tempId = (String)carTrackData.getCarTempIdList().get(i);
                    float width = ((Float)carTrackData.getWidthList().get(i)).floatValue();
                    double speed = (int)Math.abs((double)((Float)carTrackData.getSpeedList().get(i)).floatValue() * 3.6);
                    CarKRoad tempCarKRoad = GeoUtil.getCarKRoadByDistance((int)((Integer)carTrackData.getDistanceList().get(i)), (List)carKRoadList);
                    for (HomeData.DataItem dataItem : dataItemList) {
                        if (!dataItem.getValueX().equals(tempCarKRoad.getKTag())) continue;
                        dataItem.setValueY(dataItem.getValueY() + 1);
                    }
                    for (CarKRoad carKRoad : carKRoadList) {
                        if (!carKRoad.getKName().equals(tempCarKRoad.getKName())) continue;
                        carKRoad.setCarCount(carKRoad.getCarCount() + 1);
                        carKRoad.setSumSpeed((int)((double)carKRoad.getSumSpeed() + speed));
                    }
                    for (RoadInfo roadInfo : hotRoadInfoList) {
                        if (distance < roadInfo.getStartDistance() || distance >= roadInfo.getEndDistance()) continue;
                        roadInfo.getSpeedList().add((int)speed);
                    }
                    int extendedTag = (Integer)carTrackData.getExtendedTagList().get(i);
                    if (extendedTag == 1) continue;
                    for (RoadInfo roadInfo : roadInfoList) {
                        if (distance < roadInfo.getStartDistance() || distance >= roadInfo.getEndDistance()) continue;
                        roadInfo.getRealTimeTempIdSet().add(tempId);
                        roadInfo.setDaySumSpeed(roadInfo.getDaySumSpeed() + Math.abs(speed));
                        roadInfo.setDaySumCarCount(roadInfo.getDaySumCarCount() + 1);
                        roadInfo.setDayAveSpeed((int)(roadInfo.getDaySumSpeed() / (double)roadInfo.getDaySumCarCount()));
                        roadInfo.setRealTimeSumSpeed(roadInfo.getRealTimeSumSpeed() + Math.abs(speed));
                        roadInfo.setRealTimeSumCarCount(roadInfo.getRealTimeSumCarCount() + 1);
                        roadInfo.setRealTimeAveSpeed((int)(roadInfo.getRealTimeSumSpeed() / (double)roadInfo.getRealTimeSumCarCount()));
                        dateTime2 = carTrackData.getTime();
                        hour = dateTime2.getHour();
                        if (distance > roadStartDistance && distance < roadEndDistance) {
                            roadInfo.getDayCarTempIdSet().add((String)carTrackData.getCarTempIdList().get(i));
                            for (RoadInfo.HourItem hourItem : roadInfo.getHourItemList()) {
                                if (hourItem.getHour() != hour && hourItem.getHour() != hour - 1) continue;
                                if (hourItem.getTempIdSet().contains(tempId)) {
                                    optional = hourItem.getCarItemList().stream().filter(tempItem -> tempItem.getTempId().equals(tempId)).findFirst();
                                    if (!optional.isPresent()) continue;
                                    found = optional.get();
                                    if (width >= carWidth) {
                                        found.setBigWidthCount(found.getBigWidthCount() + 1);
                                        continue;
                                    }
                                    if (!(width < carWidth)) continue;
                                    found.setSmallWidthCount(found.getSmallWidthCount() + 1);
                                    continue;
                                }
                                carItem2 = new RoadInfo.CarItem();
                                carItem2.setTempId(tempId);
                                if (width >= carWidth) {
                                    carItem2.setBigWidthCount(1);
                                } else if (width < carWidth) {
                                    carItem2.setSmallWidthCount(1);
                                }
                                hourItem.getTempIdSet().add(tempId);
                                hourItem.setCarCount(hourItem.getTempIdSet().size());
                                hourItem.getCarItemList().add(carItem2);
                            }
                        }
                        roadInfo.setDaySumCarCountUnique(roadInfo.getDayCarTempIdSet().size());
                    }
                    for (RoadInfo roadInfo : customRoadInfoList) {
                        if (distance < roadInfo.getStartDistance() || distance >= roadInfo.getEndDistance()) continue;
                        roadInfo.setDaySumSpeed(roadInfo.getDaySumSpeed() + Math.abs(speed));
                        roadInfo.setDaySumCarCount(roadInfo.getDaySumCarCount() + 1);
                        roadInfo.setDayAveSpeed((int)(roadInfo.getDaySumSpeed() / (double)roadInfo.getDaySumCarCount()));
                        roadInfo.getDayCarTempIdSet().add(tempId);
                        roadInfo.setDaySumCarCountUnique(roadInfo.getDayCarTempIdSet().size());
                        dateTime2 = carTrackData.getTime();
                        hour = dateTime2.getHour();
                        for (RoadInfo.HourItem hourItem : roadInfo.getHourItemList()) {
                            if (hourItem.getHour() != hour) continue;
                            if (hourItem.getTempIdSet().contains(tempId)) {
                                optional = hourItem.getCarItemList().stream().filter(tempItem -> tempItem.getTempId().equals(tempId)).findFirst();
                                if (!optional.isPresent()) continue;
                                found = optional.get();
                                if (width >= carWidth) {
                                    found.setBigWidthCount(found.getBigWidthCount() + 1);
                                    continue;
                                }
                                if (!(width < carWidth)) continue;
                                found.setSmallWidthCount(found.getSmallWidthCount() + 1);
                                continue;
                            }
                            carItem2 = new RoadInfo.CarItem();
                            carItem2.setTempId(tempId);
                            if (width >= carWidth) {
                                carItem2.setBigWidthCount(1);
                            } else if (width < carWidth) {
                                carItem2.setSmallWidthCount(1);
                            }
                            hourItem.getTempIdSet().add(tempId);
                            hourItem.setCarCount(hourItem.getTempIdSet().size());
                            hourItem.getCarItemList().add(carItem2);
                        }
                    }
                }
                for (RoadInfo roadInfo : customRoadInfoList) {
                    roadInfo.setRealTimeSumSpeed(0.0);
                    roadInfo.setRealTimeSumCarCount(0);
                    roadInfo.setRealTimeCarCount(roadInfo.getRealTimeTempIdSet().size());
                    roadInfo.getRealTimeTempIdSet().clear();
                    dateTime = carTrackData.getTime();
                    int hour = dateTime.getHour();
                    for (RoadInfo.HourItem hourItem : roadInfo.getHourItemList()) {
                        if (hourItem.getHour() != hour) continue;
                        hourItem.setSmallCarCount(0);
                        hourItem.setBigCarCount(0);
                        hourItem.getCarItemList().forEach(carItem -> {
                            if (carItem.getSmallWidthCount() >= carItem.getBigWidthCount()) {
                                hourItem.setSmallCarCount(hourItem.getSmallCarCount() + 1);
                            } else {
                                hourItem.setBigCarCount(hourItem.getBigCarCount() + 1);
                            }
                        });
                    }
                }
                for (RoadInfo roadInfo : roadInfoList) {
                    roadInfo.setRealTimeSumSpeed(0.0);
                    roadInfo.setRealTimeSumCarCount(0);
                    roadInfo.setRealTimeCarCount(roadInfo.getRealTimeTempIdSet().size());
                    roadInfo.getRealTimeTempIdSet().clear();
                    dateTime = carTrackData.getTime();
                    int hour = dateTime.getHour();
                    for (RoadInfo.HourItem hourItem : roadInfo.getHourItemList()) {
                        if (hourItem.getHour() != hour) continue;
                        hourItem.setSmallCarCount(0);
                        hourItem.setBigCarCount(0);
                        hourItem.getCarItemList().forEach(carItem -> {
                            if (carItem.getSmallWidthCount() >= carItem.getBigWidthCount()) {
                                hourItem.setSmallCarCount(hourItem.getSmallCarCount() + 1);
                            } else {
                                hourItem.setBigCarCount(hourItem.getBigCarCount() + 1);
                            }
                        });
                    }
                }
                for (CarKRoad carKRoad : carKRoadList) {
                    if (carKRoad.getCarCount() == 0) continue;
                    carKRoad.setAveSpeed(carKRoad.getSumSpeed() / carKRoad.getCarCount());
                    if (carKRoad.getCarCount() > hotSlowCarCount) {
                        if (carKRoad.getAveSpeed() <= hotCongestionAveSpeed) {
                            carKRoad.setCongestionLevel(1);
                            continue;
                        }
                        if (carKRoad.getAveSpeed() > hotCongestionAveSpeed && carKRoad.getAveSpeed() <= hotSlowSpeed) {
                            carKRoad.setCongestionLevel(2);
                            continue;
                        }
                        carKRoad.setCongestionLevel(3);
                        continue;
                    }
                    carKRoad.setCongestionLevel(3);
                }
                this.redisTemplate.opsForValue().set((Object)(orientation + "-realTimeCarCountHotLine"), JSON.toJSON((Object)carKRoadList));
                this.redisTemplate.opsForValue().set((Object)(orientation + "-hotRoadInfoList"), JSON.toJSON((Object)hotRoadInfoList));
                this.redisTemplate.opsForValue().set((Object)(orientation + "-realTimeCarCountChart"), JSON.toJSON(dataItemList));
                try {
                    int realOrientation;
                    int n = realOrientation = switchValue ? orientation : -orientation;
                    if (realOrientation == 1) {
                        this.warningSocketHandler.sendUpCarCountChart(JSON.toJSONString(dataItemList));
                    } else {
                        this.warningSocketHandler.sendDownCarCountChart(JSON.toJSONString(dataItemList));
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                for (RoadInfo roadInfo : roadInfoList) {
                    roadInfo.setRealTimeCarCount(roadInfo.getRealTimeTempIdSet().size());
                    roadInfo.getRealTimeTempIdSet().clear();
                }
                this.redisTemplate.opsForValue().set((Object)(orientation + "-roadInfoList-" + dayKey), JSON.toJSON(roadInfoList));
                this.redisTemplate.opsForValue().set((Object)(orientation + "-customRoadInfoList-" + dayKey), JSON.toJSON(customRoadInfoList));
            }
        }
    }

    private List<RoadInfo> allRoadStatistics(String dayKey, int orientation) {
        List roadInfoList;
        Object roadInfoListObject = this.redisTemplate.opsForValue().get((Object)(orientation + "-roadInfoList-" + dayKey));
        if (roadInfoListObject == null) {
            roadInfoList = this.roadInfoMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(RoadInfo::getType, (Object)1)).orderByAsc(RoadInfo::getRoadSort));
            for (RoadInfo roadInfo : roadInfoList) {
                for (int i = 0; i < 24; ++i) {
                    RoadInfo.HourItem hourItem = new RoadInfo.HourItem();
                    hourItem.setHour(i);
                    roadInfo.getHourItemList().add(hourItem);
                }
            }
        } else {
            roadInfoList = JSONUtil.toList((String)roadInfoListObject.toString(), RoadInfo.class);
        }
        for (RoadInfo roadInfo : roadInfoList) {
            roadInfo.setRealTimeSumSpeed(0.0);
            roadInfo.setRealTimeSumCarCount(0);
            roadInfo.setRealTimeAveSpeed(0);
            roadInfo.getRealTimeTempIdSet().clear();
        }
        return roadInfoList;
    }

    private List<RoadInfo> customRoadStatistics(String dayKey, int orientation) {
        List customRoadInfoList;
        Object customRoadInfoListObject = this.redisTemplate.opsForValue().get((Object)(orientation + "-customRoadInfoList-" + dayKey));
        if (customRoadInfoListObject == null) {
            customRoadInfoList = this.roadInfoMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(RoadInfo::getType, (Object)3)).orderByAsc(RoadInfo::getRoadSort));
            for (RoadInfo roadInfo : customRoadInfoList) {
                for (int i = 0; i < 24; ++i) {
                    RoadInfo.HourItem hourItem = new RoadInfo.HourItem();
                    hourItem.setHour(i);
                    roadInfo.getHourItemList().add(hourItem);
                }
            }
        } else {
            customRoadInfoList = JSON.parseArray((String)customRoadInfoListObject.toString(), RoadInfo.class, (JSONReader.Feature[])new JSONReader.Feature[0]);
        }
        return customRoadInfoList;
    }

    @Scheduled(fixedRate=1000L)
    public void processQueue() throws Exception {
        String msg;
        if (upCarTackQueue.size() > 20) {
            upCarTackQueue.clear();
        }
        if (downCarTackQueue.size() > 20) {
            downCarTackQueue.clear();
        }
        if (!upCarTackQueue.isEmpty() && (msg = (String)upCarTackQueue.poll()) != null) {
            this.warningSocketHandler.sendUpCarTrack(msg);
        }
        if (!downCarTackQueue.isEmpty() && (msg = (String)downCarTackQueue.poll()) != null) {
            this.warningSocketHandler.sendDownCarTrack(msg);
        }
    }

    @Scheduled(cron="0 0 1 * * ?")
    private void addExpWarning() {
        LocalDateTime now = LocalDateTime.now();
        LocalDateTime yesterdayStart = now.minusDays(1L).with(LocalTime.MIN);
        LocalDateTime yesterdayEnd = now.minusDays(1L).with(LocalTime.MAX);
        List expWarningList = this.expWarningMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().ge(ExpWarning::getCreateTime, (Object)yesterdayStart)).le(ExpWarning::getCreateTime, (Object)yesterdayEnd));
        ArrayList<Long> ids = new ArrayList<Long>();
        for (ExpWarning expWarning : expWarningList) {
            ExpWarningTemp expWarningTemp = new ExpWarningTemp();
            BeanUtils.copyProperties((Object)expWarning, (Object)expWarningTemp);
            this.expWarningTempMapper.insert((Object)expWarningTemp);
            ids.add(expWarning.getId());
        }
        this.expWarningMapper.deleteBatchIds(ids);
    }

    @Scheduled(cron="0 0 0/1 * * ?")
    private void deleteDataTask() {
        List roadInfoList;
        Object roadInfoListObject;
        if (this.appType == 99) {
            return;
        }
        LocalDateTime now = LocalDateTime.now();
        this.dataLogMapper.delete((Wrapper)Wrappers.lambdaQuery().le(DataLog::getLogTime, (Object)now.minusDays(2L)));
        this.carTrackMapper.delete((Wrapper)Wrappers.lambdaQuery().le(CarTrack::getCurrentTime, (Object)now.minusDays(3L)));
        this.dotDataMapper.delete((Wrapper)Wrappers.lambdaQuery().le(DotData::getCreateTime, (Object)now.minusDays(3L)));
        this.strainTemperatureMapper.delete((Wrapper)Wrappers.lambdaQuery().le(StrainTemperature::getCreateTime, (Object)now.minusHours(12L)));
        DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        int[] orientationArray = new int[]{-1, 1};
        LocalDateTime yesterday = LocalDateTime.now().minusDays(1L);
        for (int orientation : orientationArray) {
            roadInfoListObject = this.redisTemplate.opsForValue().get((Object)(orientation + "-roadInfoList-" + yesterday.format(dateFormatter)));
            if (roadInfoListObject == null) continue;
            roadInfoList = JSONUtil.toList((String)roadInfoListObject.toString(), RoadInfo.class);
            for (RoadInfo roadInfo2 : roadInfoList) {
                for (RoadInfo.HourItem hourItem : roadInfo2.getHourItemList()) {
                    hourItem.getTempIdSet().clear();
                    hourItem.getCarItemList().clear();
                }
                roadInfo2.getDayCarTempIdSet().clear();
            }
            this.redisTemplate.opsForValue().set((Object)(orientation + "-roadInfoList-" + yesterday.format(dateFormatter)), (Object)JSONUtil.toJsonStr((Object)roadInfoList));
        }
        for (int orientation : orientationArray) {
            roadInfoListObject = this.redisTemplate.opsForValue().get((Object)(orientation + "-customRoadInfoList-" + yesterday.format(dateFormatter)));
            if (roadInfoListObject == null) continue;
            roadInfoList = JSONUtil.toList((String)roadInfoListObject.toString(), RoadInfo.class);
            for (RoadInfo roadInfo2 : roadInfoList) {
                for (RoadInfo.HourItem hourItem : roadInfo2.getHourItemList()) {
                    hourItem.getTempIdSet().clear();
                    hourItem.getCarItemList().clear();
                }
                roadInfo2.getDayCarTempIdSet().clear();
            }
            this.redisTemplate.opsForValue().set((Object)(orientation + "-customRoadInfoList-" + yesterday.format(dateFormatter)), (Object)JSONUtil.toJsonStr((Object)roadInfoList));
        }
        List roadInfoList2 = this.roadInfoMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().in(RoadInfo::getType, Arrays.asList(2, 3))).orderByAsc(RoadInfo::getRoadSort));
        String dayKey = LocalDateTime.now().minusDays(2L).format(dateFormatter);
        for (RoadInfo roadInfo3 : roadInfoList2) {
            this.redisTemplate.delete((Object)(roadInfo3.getId() + "tempId" + dayKey));
            this.redisTemplate.delete((Object)(roadInfo3.getId() + "speed" + dayKey));
            this.redisTemplate.delete((Object)(roadInfo3.getId() + "count" + dayKey));
        }
        Object newRoadInfoListObject = this.redisTemplate.opsForValue().get((Object)(yesterday.format(dateFormatter) + "-roadInfoList"));
        if (newRoadInfoListObject != null) {
            List newRoadInfoList = JSON.parseArray((String)newRoadInfoListObject.toString(), RoadInfo.class, (JSONReader.Feature[])new JSONReader.Feature[0]);
            newRoadInfoList.forEach(roadInfo -> {
                roadInfo.getDayCarTempIdSet().clear();
                for (RoadInfo.HourItem hourItem : roadInfo.getHourItemList()) {
                    hourItem.getTempIdSet().clear();
                    hourItem.getCarItemList().clear();
                }
            });
            this.redisTemplate.opsForValue().set((Object)(yesterday.format(dateFormatter) + "-roadInfoList"), (Object)JSONUtil.toJsonStr((Object)newRoadInfoList));
        }
    }

    @Scheduled(cron="0 1/10 * * * ?")
    private void deleteTempDataTask() {
        LocalDateTime now = LocalDateTime.now();
        this.dataLogTempMapper.delete((Wrapper)Wrappers.lambdaQuery().le(DataLogTemp::getLogTime, (Object)now.minusMinutes(30L)));
    }

    @Scheduled(fixedRate=1000L)
    public void testData() {
        if (this.appType != 99) {
            return;
        }
        LocalDateTime currentDateTime = LocalDateTime.now();
        LocalDateTime start = currentDateTime.withDayOfMonth(15).withMonth(11).withYear(2025).withHour(10);
        LocalDateTime end = start.plusSeconds(1L);
        List dataLogList = this.dataLogMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().ge(DataLog::getLogTime, (Object)start)).le(DataLog::getLogTime, (Object)end));
        if (dataLogList != null && !dataLogList.isEmpty()) {
            CarTrackDTO csvBeanNew = (CarTrackDTO)JSONUtil.toBean((String)((DataLog)dataLogList.get(0)).getValueStr(), CarTrackDTO.class);
            int hour = LocalDateTime.now().getHour();
            int dayOfMonth = LocalDateTime.now().getDayOfMonth();
            int month = LocalDateTime.now().getMonth().getValue();
            int year = LocalDateTime.now().getYear();
            LocalDateTime startTime = csvBeanNew.getStartTime().withHour(hour).withDayOfMonth(dayOfMonth).withMonth(month).withYear(year);
            LocalDateTime endTime = csvBeanNew.getEndTime().withHour(hour).withDayOfMonth(dayOfMonth).withMonth(month).withYear(year);
            csvBeanNew.setStartTime(startTime);
            csvBeanNew.setEndTime(endTime);
            for (CarTrackData csvBean : csvBeanNew.getList()) {
                LocalDateTime time = csvBean.getTime().withHour(hour).withDayOfMonth(dayOfMonth).withMonth(month).withYear(year);
                csvBean.setTime(time);
            }
            DataLogTemp dataLogTemp = new DataLogTemp();
            dataLogTemp.setLogTime(csvBeanNew.getEndTime());
            dataLogTemp.setCreateTime(LocalDateTime.now());
            String dataStr = JSON.toJSONString((Object)csvBeanNew);
            dataLogTemp.setValueStr(dataStr);
            this.dataLogTempMapper.insert((Object)dataLogTemp);
            this.carTrackV4Service.processData(csvBeanNew);
        }
    }

    public void checkService() {
        if (this.appType == 1 || this.appType == 2) {
            Object aliveObject = this.redisTemplate.opsForValue().get((Object)"alive");
            if (aliveObject == null) {
                return;
            }
            int alive = Integer.valueOf(aliveObject.toString());
            if (alive == 1) {
                JSONObject jsonObject = new JSONObject();
                jsonObject.set("appType", (Object)this.appType);
                RequestBody body = RequestBody.create((String)jsonObject.toString(), (MediaType)MediaType.get((String)"application/json;charset=utf-8"));
                Request request = new Request.Builder().url("http://118.89.120.138:8010/message/send").post(body).build();
                try (Response response = this.client.newCall(request).execute();){
                    if (!response.isSuccessful()) {
                        System.out.println("\u53d1\u9001\u5fc3\u8df3\u5931\u8d251");
                    }
                    this.redisTemplate.opsForValue().set((Object)"alive", (Object)0);
                }
                catch (Exception ignored) {
                    System.out.println("\u53d1\u9001\u5fc3\u8df3\u5931\u8d252");
                    this.redisTemplate.opsForValue().set((Object)"alive", (Object)0);
                }
            }
        }
    }
}

