/*
 * Decompiled with CFR 0.152.
 */
package com.shengmu.config;

import com.shengmu.modal.entity.CarTrack;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class TrackManager {
    private final List<CarTrack> carTrackList = Collections.synchronizedList(new ArrayList());
    private LocalDateTime now;

    public void addTrack(List<CarTrack> carTrackList, LocalDateTime now) {
        this.now = now;
        this.carTrackList.addAll(carTrackList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Scheduled(fixedRate=5000L)
    public void removeExpiredTracks() {
        List list = this.carTrackList;
        synchronized (list) {
            if (this.now != null) {
                Iterator iterator = this.carTrackList.iterator();
                while (iterator.hasNext()) {
                    CarTrack carTrack = (CarTrack)iterator.next();
                    if (!carTrack.getCurrentTime().isBefore(this.now.minusSeconds(45L))) continue;
                    iterator.remove();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CarTrack> getRecentTracks() {
        List list = this.carTrackList;
        synchronized (list) {
            return new ArrayList<CarTrack>(this.carTrackList);
        }
    }
}

