/*
 * Decompiled with CFR 0.152.
 */
package com.shengmu.controller;

import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONObject;
import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.TypeReference;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.shengmu.mapper.CameraInfoMapper;
import com.shengmu.mapper.CarKRoadMapper;
import com.shengmu.mapper.CarTrackMapper;
import com.shengmu.mapper.DataLogMapper;
import com.shengmu.mapper.DataLogTempMapper;
import com.shengmu.mapper.DotDataMapper;
import com.shengmu.mapper.ExpTypeMapper;
import com.shengmu.mapper.ExpWarningMapper;
import com.shengmu.mapper.ExpWarningTempMapper;
import com.shengmu.mapper.RoadInfoMapper;
import com.shengmu.mapper.StrainTemperatureMapper;
import com.shengmu.mapper.SystemConfigMapper;
import com.shengmu.modal.dto.BigWarningParam;
import com.shengmu.modal.dto.BigWarningV2;
import com.shengmu.modal.dto.CarTrackDTO;
import com.shengmu.modal.dto.CarTrackListParam;
import com.shengmu.modal.dto.HomeDataParam;
import com.shengmu.modal.dto.PageEntity;
import com.shengmu.modal.entity.CameraInfo;
import com.shengmu.modal.entity.CarKRoad;
import com.shengmu.modal.entity.CarTrack;
import com.shengmu.modal.entity.DataLog;
import com.shengmu.modal.entity.DataLogTemp;
import com.shengmu.modal.entity.DotData;
import com.shengmu.modal.entity.ExpType;
import com.shengmu.modal.entity.ExpWarning;
import com.shengmu.modal.entity.ExpWarningTemp;
import com.shengmu.modal.entity.RoadInfo;
import com.shengmu.modal.entity.SystemConfig;
import com.shengmu.modal.vo.HomeData;
import com.shengmu.service.CarTrackV2Service;
import com.shengmu.service.CarTrackV3Service;
import com.shengmu.service.CarTrackV4Service;
import com.shengmu.utils.GeoUtil;
import com.shengmu.utils.ResponseResult;
import com.shengmu.websocket.WarningSocketHandler;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URI;
import java.nio.file.Paths;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.springframework.beans.BeanUtils;
import org.springframework.core.io.InputStreamResource;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.StreamUtils;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.RequestCallback;
import org.springframework.web.client.ResponseExtractor;
import org.springframework.web.client.RestTemplate;

@RestController
@CrossOrigin
@RequestMapping(value={"carStream"})
public class CarTrackController {
    @Resource
    private CarTrackV2Service carTrackV2Service;
    @Resource
    private CarTrackV3Service carTrackV3Service;
    @Resource
    private CarTrackV4Service carTrackV4Service;
    @Resource
    private ExpWarningMapper expWarningMapper;
    @Resource
    private ExpWarningTempMapper expWarningTempMapper;
    @Resource
    private DotDataMapper dotDataMapper;
    @Resource
    private DataLogMapper dataLogMapper;
    @Resource
    private DataLogTempMapper dataLogTempMapper;
    @Resource
    private ExpTypeMapper expTypeMapper;
    @Resource
    private CameraInfoMapper cameraInfoMapper;
    @Resource
    private SystemConfigMapper systemConfigMapper;
    @Resource
    private MongoTemplate mongoTemplate;
    @Resource
    private RedisTemplate redisTemplate;
    @Resource
    private CarKRoadMapper carKRoadMapper;
    @Resource
    private StrainTemperatureMapper strainTemperatureMapper;
    @Resource
    private RoadInfoMapper roadInfoMapper;
    @Resource
    private CarTrackMapper carTrackMapper;
    @Resource
    private WarningSocketHandler warningSocketHandler;
    private final OkHttpClient client = new OkHttpClient.Builder().connectTimeout(3L, TimeUnit.SECONDS).readTimeout(3L, TimeUnit.SECONDS).writeTimeout(3L, TimeUnit.SECONDS).build();
    private final RestTemplate restTemplate = new RestTemplate();

    @PostMapping(value={"/getData/v2"})
    public ResponseResult getDataV2(@RequestBody CarTrackDTO carTrackDTO) {
        List filteredList = carTrackDTO.getList().stream().filter(data -> data.getTime().isAfter(carTrackDTO.getEndTime().minusSeconds(3L))).collect(Collectors.toList());
        carTrackDTO.setList(filteredList);
        DataLog dataLog = new DataLog();
        dataLog.setLogTime(carTrackDTO.getEndTime());
        dataLog.setCreateTime(LocalDateTime.now());
        String dataStr = JSON.toJSONString((Object)carTrackDTO);
        dataLog.setValueStr(dataStr);
        this.dataLogMapper.insert((Object)dataLog);
        this.carTrackV2Service.processData(carTrackDTO);
        this.redisTemplate.opsForValue().set((Object)"alive", (Object)1);
        return ResponseResult.success();
    }

    @PostMapping(value={"/getData/v3"})
    public ResponseResult getDataV3(@RequestBody CarTrackDTO carTrackDTO) {
        List filteredList = carTrackDTO.getList().stream().filter(data -> data.getTime().isEqual(carTrackDTO.getEndTime())).collect(Collectors.toList());
        carTrackDTO.setList(filteredList);
        DataLog dataLog = new DataLog();
        dataLog.setLogTime(carTrackDTO.getEndTime());
        dataLog.setCreateTime(LocalDateTime.now());
        String dataStr = JSON.toJSONString((Object)carTrackDTO);
        dataLog.setValueStr(dataStr);
        this.dataLogMapper.insert((Object)dataLog);
        this.carTrackV3Service.processData(carTrackDTO);
        this.redisTemplate.opsForValue().set((Object)"alive", (Object)1);
        return ResponseResult.success();
    }

    @PostMapping(value={"/getData/v4"})
    public ResponseResult getDataV4(@RequestBody CarTrackDTO carTrackDTO) {
        List filteredList = carTrackDTO.getList().stream().filter(data -> data.getTime().isEqual(carTrackDTO.getEndTime())).collect(Collectors.toList());
        carTrackDTO.setList(filteredList);
        DataLog dataLog = new DataLog();
        dataLog.setLogTime(carTrackDTO.getEndTime());
        dataLog.setCreateTime(LocalDateTime.now());
        String dataStr = JSON.toJSONString((Object)carTrackDTO);
        dataLog.setValueStr(dataStr);
        this.dataLogMapper.insert((Object)dataLog);
        DataLogTemp dataLogTemp = new DataLogTemp();
        dataLogTemp.setLogTime(carTrackDTO.getEndTime());
        dataLogTemp.setCreateTime(LocalDateTime.now());
        dataLogTemp.setValueStr(JSON.toJSONString((Object)carTrackDTO));
        this.dataLogTempMapper.insert((Object)dataLogTemp);
        this.carTrackV4Service.processData(carTrackDTO);
        this.redisTemplate.opsForValue().set((Object)"alive", (Object)1);
        return ResponseResult.success();
    }

    /*
     * WARNING - void declaration
     */
    @PostMapping(value={"/getHomeData"})
    public ResponseResult getHomeData(@RequestBody HomeDataParam homeDataParam) {
        Object stressListObject;
        void var21_31;
        Object negRealTimeCarCountHotLineObject;
        List<HomeData.DataItem> dataItemList;
        Object realTimeCarCountChartObject;
        Object customRoadInfoListObject;
        HomeData homeData = new HomeData();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        String dayKey = homeDataParam.getStartDate().format(formatter);
        List allCarKRoadList = this.carKRoadMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(CarKRoad::getType, (Object)1)).orderByAsc(CarKRoad::getId));
        List orientationConfigList = this.systemConfigMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SystemConfig::getConfigType, (Object)"orientation")).orderByAsc(SystemConfig::getConfigSort));
        int orientationValue = Integer.parseInt(((SystemConfig)orientationConfigList.get(0)).getConfigValue());
        int upDownValue = Integer.parseInt(((SystemConfig)orientationConfigList.get(0)).getConfigValueExt());
        int direction = homeDataParam.getDirection();
        if (orientationValue != upDownValue) {
            direction = -direction;
        }
        ArrayList<String> kTagList = new ArrayList<String>();
        for (CarKRoad carKRoad : allCarKRoadList) {
            if (kTagList.contains(carKRoad.getKTag())) continue;
            kTagList.add(carKRoad.getKTag());
        }
        Object roadInfoListObject = this.redisTemplate.opsForValue().get((Object)(direction + "-roadInfoList-" + dayKey));
        if (roadInfoListObject != null) {
            List roadInfoList = JSON.parseArray((String)roadInfoListObject.toString(), RoadInfo.class, (JSONReader.Feature[])new JSONReader.Feature[0]);
            for (Object roadInfo : roadInfoList) {
                for (Object hourItem : roadInfo.getHourItemList()) {
                    hourItem.getCarItemList().clear();
                    hourItem.getTempIdSet().clear();
                }
            }
            homeData.setDayCarCount(((RoadInfo)roadInfoList.get(0)).getDaySumCarCountUnique());
            ((RoadInfo)roadInfoList.get(0)).getDayCarTempIdSet().clear();
            homeData.setRoadInfoList(roadInfoList);
        }
        if ((customRoadInfoListObject = this.redisTemplate.opsForValue().get((Object)(direction + "-customRoadInfoList-" + dayKey))) != null) {
            List customRoadInfoList = JSON.parseArray((String)customRoadInfoListObject.toString(), RoadInfo.class, (JSONReader.Feature[])new JSONReader.Feature[0]);
            for (Object roadInfo : customRoadInfoList) {
                roadInfo.getDayCarTempIdSet().clear();
                for (RoadInfo.HourItem hourItem : roadInfo.getHourItemList()) {
                    hourItem.getTempIdSet().clear();
                    hourItem.getCarItemList().clear();
                }
            }
            homeData.setCustomeRoadInfoList(customRoadInfoList);
        }
        if ((realTimeCarCountChartObject = this.redisTemplate.opsForValue().get((Object)(direction + "-realTimeCarCountChart"))) != null) {
            dataItemList = JSON.parseArray((String)realTimeCarCountChartObject.toString(), HomeData.DataItem.class, (JSONReader.Feature[])new JSONReader.Feature[0]);
        } else {
            dataItemList = new ArrayList();
            for (String kName : kTagList) {
                HomeData.DataItem dataItem = new HomeData.DataItem();
                dataItem.setValueX(kName);
                dataItemList.add(dataItem);
            }
        }
        homeData.setRealTimeCarCountList(dataItemList);
        List<Object> expWarningList = new ArrayList();
        LocalDate today = LocalDate.now();
        if (homeDataParam.getStartDate().isEqual(today)) {
            expWarningList = this.expWarningMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(ExpWarning::getFix, (Object)0)).eq(ExpWarning::getUpgrade, (Object)0)).ge(ExpWarning::getDataTime, (Object)homeDataParam.getStartDate().atStartOfDay())).le(ExpWarning::getDataTime, (Object)homeDataParam.getEndDate().atTime(LocalTime.MAX))).orderByDesc(ExpWarning::getDataTime));
        } else {
            List expWarningTempList = this.expWarningTempMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(ExpWarningTemp::getFix, (Object)0)).eq(ExpWarningTemp::getUpgrade, (Object)0)).ge(ExpWarningTemp::getDataTime, (Object)homeDataParam.getStartDate().atStartOfDay())).le(ExpWarningTemp::getDataTime, (Object)homeDataParam.getEndDate().atTime(LocalTime.MAX))).orderByDesc(ExpWarningTemp::getDataTime));
            Iterator iterator = expWarningTempList.iterator();
            while (iterator.hasNext()) {
                ExpWarningTemp expWarningTemp = (ExpWarningTemp)iterator.next();
                ExpWarning expWarning2 = new ExpWarning();
                BeanUtils.copyProperties((Object)expWarningTemp, (Object)expWarning2);
                expWarningList.add(expWarning2);
            }
        }
        for (String kName : kTagList) {
            HomeData.DataItem dataItem = new HomeData.DataItem();
            for (ExpWarning expWarning2 : expWarningList) {
                if (!expWarning2.getWarningArea().contains(kName)) continue;
                dataItem.setValueY(dataItem.getValueY() + 1);
            }
            dataItem.setValueX(kName);
            homeData.getRoadExpList().add(dataItem);
        }
        for (int i = 0; i < 24; i += 2) {
            HomeData.DataItem dataItem = new HomeData.DataItem();
            dataItem.setValueX(i + "");
            for (Object expWarning3 : expWarningList) {
                int n = expWarning3.getDataTime().getHour();
                if (n != i && n + 1 != i) continue;
                dataItem.setValueY(dataItem.getValueY() + 1);
            }
            homeData.getTimeExpList().add(dataItem);
        }
        List expTypeList = this.expTypeMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(ExpType::getEnable, (Object)1)).orderByAsc(ExpType::getTypeSort));
        for (ExpType expType2 : expTypeList) {
            for (ExpWarning expWarning4 : expWarningList) {
                if (expType2.getTypeValue().intValue() != expWarning4.getType().intValue()) continue;
                expType2.setValue(expType2.getValue() + 1);
            }
            if (expType2.getValue() == 0) {
                expType2.setPercent(0);
                continue;
            }
            expType2.setPercent(expType2.getValue() * 100 / expWarningList.size());
        }
        List filteredList = expTypeList.stream().filter(expType -> expType.getPercent() > 0).collect(Collectors.toList());
        int finalPercent = 100;
        for (int i = 0; i < filteredList.size(); ++i) {
            if (i < filteredList.size() - 1) {
                finalPercent -= ((ExpType)filteredList.get(i)).getPercent();
                continue;
            }
            ((ExpType)filteredList.get(i)).setPercent(finalPercent);
        }
        homeData.getExpTypeList().addAll(expTypeList);
        List unProcessList = expWarningList.stream().filter(expWarning -> expWarning.getState() == 0).collect(Collectors.toList());
        homeData.setExpWarningList(unProcessList);
        if (orientationValue == upDownValue) {
            Object object = this.redisTemplate.opsForValue().get((Object)"1-realTimeCarCountHotLine");
            negRealTimeCarCountHotLineObject = this.redisTemplate.opsForValue().get((Object)"-1-realTimeCarCountHotLine");
        } else {
            Object object = this.redisTemplate.opsForValue().get((Object)"-1-realTimeCarCountHotLine");
            negRealTimeCarCountHotLineObject = this.redisTemplate.opsForValue().get((Object)"1-realTimeCarCountHotLine");
        }
        List carKRoadList = var21_31 != null ? JSON.parseArray((String)var21_31.toString(), CarKRoad.class, (JSONReader.Feature[])new JSONReader.Feature[0]) : this.carKRoadMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(CarKRoad::getType, (Object)1)).orderByAsc(CarKRoad::getId));
        List negCarKRoadList = negRealTimeCarCountHotLineObject != null ? JSON.parseArray((String)negRealTimeCarCountHotLineObject.toString(), CarKRoad.class, (JSONReader.Feature[])new JSONReader.Feature[0]) : this.carKRoadMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(CarKRoad::getType, (Object)1)).orderByAsc(CarKRoad::getId));
        homeData.setCarKRoadList(carKRoadList);
        homeData.setNegCarKRoadList(negCarKRoadList);
        Object hotRoadInfoListObject = this.redisTemplate.opsForValue().get((Object)(direction + "-hotRoadInfoList"));
        List hotRoadInfoList = hotRoadInfoListObject != null ? JSON.parseArray((String)hotRoadInfoListObject.toString(), RoadInfo.class, (JSONReader.Feature[])new JSONReader.Feature[0]) : this.roadInfoMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(RoadInfo::getType, (Object)2)).orderByAsc(RoadInfo::getRoadSort));
        homeData.setHotRoadInfoList(hotRoadInfoList);
        String todayKey = LocalDateTime.now().format(formatter);
        Object maxTemperatureObject = this.redisTemplate.opsForValue().get((Object)("maxTemperature-" + todayKey));
        Object minTemperatureObject = this.redisTemplate.opsForValue().get((Object)("minTemperature-" + todayKey));
        Object aveTemperatureObject = this.redisTemplate.opsForValue().get((Object)("aveTemperature-" + todayKey));
        Object displacementIndexObject = this.redisTemplate.opsForValue().get((Object)("displacementIndex-" + dayKey));
        Object stressIndexObject = this.redisTemplate.opsForValue().get((Object)("stressIndex-" + dayKey));
        Object roadStressAveValueObject = this.redisTemplate.opsForValue().get((Object)("roadStressAveValue-" + dayKey));
        Object slopeStressAveValueObject = this.redisTemplate.opsForValue().get((Object)("slopeStressAveValue-" + dayKey));
        if (maxTemperatureObject != null) {
            homeData.setMaxTemperature((String)maxTemperatureObject);
        }
        if (minTemperatureObject != null) {
            homeData.setMinTemperature((String)minTemperatureObject);
        }
        if (aveTemperatureObject != null) {
            homeData.setRealTimeTemperature((String)aveTemperatureObject);
        }
        if (displacementIndexObject != null) {
            homeData.setDisplacementIndex((String)displacementIndexObject);
        }
        if (stressIndexObject != null) {
            homeData.setStressIndex((String)stressIndexObject);
        }
        if (roadStressAveValueObject != null) {
            homeData.setRoadStressAveValue((String)roadStressAveValueObject);
        }
        if (slopeStressAveValueObject != null) {
            homeData.setSlopeStressAveValue((String)slopeStressAveValueObject);
        }
        if ((stressListObject = this.redisTemplate.opsForValue().get((Object)"stressList")) != null) {
            homeData.setStressList(JSON.parseArray((String)stressListObject.toString(), HomeData.StressItem.class, (JSONReader.Feature[])new JSONReader.Feature[0]));
        }
        homeData.getWarningHotData().getKNameList().addAll(kTagList);
        for (int i = 0; i < 24; i += 2) {
            homeData.getWarningHotData().getHourList().add(i);
        }
        for (String kName : homeData.getWarningHotData().getKNameList()) {
            for (Integer hour : homeData.getWarningHotData().getHourList()) {
                HomeData.WarningHotItem warningHotItem = new HomeData.WarningHotItem();
                warningHotItem.setXIndex(Integer.valueOf(homeData.getWarningHotData().getKNameList().indexOf(kName)));
                warningHotItem.setYIndex(Integer.valueOf(homeData.getWarningHotData().getHourList().indexOf(hour)));
                HomeData.WarningHotItem downWarningHotItem = new HomeData.WarningHotItem();
                downWarningHotItem.setXIndex(Integer.valueOf(homeData.getWarningHotData().getKNameList().indexOf(kName)));
                downWarningHotItem.setYIndex(Integer.valueOf(homeData.getWarningHotData().getHourList().indexOf(hour)));
                for (ExpWarning expWarning5 : expWarningList) {
                    int warningHour = expWarning5.getDataTime().getHour();
                    if (!expWarning5.getWarningArea().contains(kName) || warningHour != hour && warningHour + 1 != hour) continue;
                    if (orientationValue == upDownValue) {
                        if (expWarning5.getOrientation() == 1) {
                            warningHotItem.setWarningCount(Integer.valueOf(warningHotItem.getWarningCount() + 1));
                            continue;
                        }
                        downWarningHotItem.setWarningCount(Integer.valueOf(downWarningHotItem.getWarningCount() + 1));
                        continue;
                    }
                    if (expWarning5.getOrientation() == -1) {
                        warningHotItem.setWarningCount(Integer.valueOf(warningHotItem.getWarningCount() + 1));
                        continue;
                    }
                    downWarningHotItem.setWarningCount(Integer.valueOf(downWarningHotItem.getWarningCount() + 1));
                }
                if (warningHotItem.getWarningCount() > 0) {
                    homeData.getWarningHotData().getWarningHotItemList().add(warningHotItem);
                }
                if (downWarningHotItem.getWarningCount() <= 0) continue;
                homeData.getWarningHotData().getDownWarningHotItemList().add(downWarningHotItem);
            }
        }
        if (homeDataParam.getDirection() == -1) {
            for (RoadInfo roadInfo : homeData.getCustomeRoadInfoList()) {
                roadInfo.setRoadName(roadInfo.getRoadName().split("\u81f3")[1] + "\u81f3" + roadInfo.getRoadName().split("\u81f3")[0]);
            }
            for (RoadInfo roadInfo : homeData.getHotRoadInfoList()) {
                roadInfo.setRoadName(roadInfo.getRoadName().split("\u81f3")[1] + "\u81f3" + roadInfo.getRoadName().split("\u81f3")[0]);
            }
        }
        return ResponseResult.success((Object)homeData);
    }

    @PostMapping(value={"/carTrackList"})
    public ResponseResult getCarTrackList(@RequestBody CarTrackListParam param) {
        Query query = new Query();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        Duration duration = Duration.between(param.getStartDateTime(), param.getEndDateTime());
        long seconds = duration.getSeconds();
        if (seconds > 30L) {
            return ResponseResult.error((String)"\u6700\u591a\u652f\u630130\u533a\u95f4\u79d2\u67e5\u8be2");
        }
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"currentTimeStr").gte((Object)param.getStartDateTime().format(formatter)).lte((Object)param.getEndDateTime().format(formatter)));
        List carTrackList = this.mongoTemplate.find(query, CarTrack.class);
        return ResponseResult.success((Object)carTrackList);
    }

    @PostMapping(value={"/expWarning/list"})
    public ResponseResult getExpWarningList(@RequestBody PageEntity pageEntity) {
        LocalDate endLocalDate;
        if (pageEntity.getStartDate() == null || pageEntity.getEndDate() == null) {
            return ResponseResult.error((String)"\u5f00\u59cb\u65f6\u95f4\u6216\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ZoneId beijing = ZoneId.of("Asia/Shanghai");
        LocalDate startLocalDate = pageEntity.getStartDate().toInstant().atZone(beijing).toLocalDate();
        if (!startLocalDate.equals(endLocalDate = pageEntity.getEndDate().toInstant().atZone(beijing).toLocalDate())) {
            return ResponseResult.error((String)"\u6682\u4e0d\u652f\u6301\u8de8\u5929\u67e5\u8be2");
        }
        if (pageEntity.getExpState() == null) {
            pageEntity.setExpState(Integer.valueOf(99));
        }
        if (pageEntity.getUpgrade() == null) {
            pageEntity.setUpgrade(Integer.valueOf(-1));
        }
        ArrayList<Integer> stateList = new ArrayList<Integer>();
        if (pageEntity.getExpState() == 99) {
            stateList.add(0);
            stateList.add(1);
        } else {
            stateList.add(pageEntity.getExpState());
        }
        Integer startDistance = null;
        Integer endDistance = null;
        if (StrUtil.isNotBlank((CharSequence)pageEntity.getStartDistance())) {
            startDistance = Integer.valueOf(pageEntity.getStartDistance());
        }
        if (StrUtil.isNotBlank((CharSequence)pageEntity.getEndDistance())) {
            endDistance = Integer.valueOf(pageEntity.getEndDistance());
        }
        if (startDistance != null && endDistance == null || startDistance == null && endDistance != null) {
            return ResponseResult.error((String)"\u5f00\u59cbK\u6807\u548c\u7ed3\u675fK\u6807\u5fc5\u987b\u540c\u65f6\u9009\u6216\u8005\u540c\u65f6\u4e0d\u9009");
        }
        if (startDistance != null && startDistance > endDistance) {
            Integer temp = startDistance;
            startDistance = endDistance;
            endDistance = temp;
        }
        LocalDate today = LocalDate.now();
        LocalDateTime start = today.atStartOfDay();
        LocalDateTime end = today.atTime(LocalTime.MAX);
        ZoneId beijingZone = ZoneId.of("Asia/Shanghai");
        LocalDateTime inputTime = pageEntity.getStartDate().toInstant().atZone(beijingZone).toLocalDateTime().plusSeconds(1L);
        if (inputTime.isAfter(start) && inputTime.isBefore(end)) {
            Page page = new Page((long)pageEntity.getPage().intValue(), (long)pageEntity.getSize().intValue());
            IPage expInfoPage = this.expWarningMapper.selectPage((IPage)page, (Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().ge(startDistance != null, ExpWarning::getDistance, (Object)startDistance)).le(endDistance != null, ExpWarning::getDistance, (Object)endDistance)).ge(ExpWarning::getDataTime, (Object)pageEntity.getStartDate())).eq(pageEntity.getUpgrade() != -1, ExpWarning::getUpgrade, (Object)pageEntity.getUpgrade())).lt(ExpWarning::getDataTime, (Object)pageEntity.getEndDate())).eq(StrUtil.isNotBlank((CharSequence)pageEntity.getTempId()), ExpWarning::getTempId, (Object)pageEntity.getTempId())).eq(pageEntity.getExpType() != null && pageEntity.getExpType() != 0, ExpWarning::getType, (Object)pageEntity.getExpType())).in(ExpWarning::getState, stateList)).orderByDesc(ExpWarning::getDataTime));
            return ResponseResult.success((Object)expInfoPage);
        }
        Page page = new Page((long)pageEntity.getPage().intValue(), (long)pageEntity.getSize().intValue());
        IPage expInfoPage = this.expWarningTempMapper.selectPage((IPage)page, (Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().ge(startDistance != null, ExpWarningTemp::getDistance, (Object)startDistance)).le(endDistance != null, ExpWarningTemp::getDistance, (Object)endDistance)).ge(ExpWarningTemp::getDataTime, (Object)pageEntity.getStartDate())).lt(ExpWarningTemp::getDataTime, (Object)pageEntity.getEndDate())).eq(pageEntity.getUpgrade() != -1, ExpWarningTemp::getUpgrade, (Object)pageEntity.getUpgrade())).eq(StrUtil.isNotBlank((CharSequence)pageEntity.getTempId()), ExpWarningTemp::getTempId, (Object)pageEntity.getTempId())).eq(pageEntity.getExpType() != null && pageEntity.getExpType() != 0, ExpWarningTemp::getType, (Object)pageEntity.getExpType())).in(ExpWarningTemp::getState, stateList)).orderByDesc(ExpWarningTemp::getDataTime));
        return ResponseResult.success((Object)expInfoPage);
    }

    @GetMapping(value={"/expType/list"})
    public ResponseResult getExpTypeList() {
        List expTypeList = this.expTypeMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(ExpType::getEnable, (Object)1)).orderByAsc(ExpType::getTypeSort));
        ExpType expType = new ExpType();
        expType.setTypeValue(Integer.valueOf(0));
        expType.setName("\u5168\u90e8\u7c7b\u578b");
        expTypeList.add(0, expType);
        return ResponseResult.success((Object)expTypeList);
    }

    @GetMapping(value={"/camera/list"})
    public ResponseResult getCameraList() {
        List cameraInfoList = this.cameraInfoMapper.selectList((Wrapper)Wrappers.lambdaQuery().orderByAsc(CameraInfo::getCode));
        return ResponseResult.success((Object)cameraInfoList);
    }

    @GetMapping(value={"/configList"})
    public ResponseResult getConfigList(@RequestParam(defaultValue="", required=false) String configType) {
        List systemConfigList = this.systemConfigMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(!StrUtil.isEmpty((CharSequence)configType), SystemConfig::getConfigType, (Object)configType)).orderByAsc(SystemConfig::getConfigSort));
        return ResponseResult.success((Object)systemConfigList);
    }

    @GetMapping(value={"/orientationConfigList"})
    public ResponseResult getOrientationConfigList() {
        List systemConfigList = this.systemConfigMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SystemConfig::getConfigType, (Object)"orientation")).orderByAsc(SystemConfig::getConfigSort));
        List allCarKRoadList = this.carKRoadMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(CarKRoad::getType, (Object)1)).orderByAsc(CarKRoad::getId));
        if (((CarKRoad)allCarKRoadList.get(0)).getDistance() > ((CarKRoad)allCarKRoadList.get(1)).getDistance()) {
            for (SystemConfig systemConfig : systemConfigList) {
                systemConfig.setConfigValue(-Integer.parseInt(systemConfig.getConfigValue()) + "");
            }
        }
        return ResponseResult.success((Object)systemConfigList);
    }

    @PostMapping(value={"/updateConfigList"})
    public ResponseResult updateConfigList(@RequestBody List<SystemConfig> systemConfigList) {
        for (SystemConfig systemConfig : systemConfigList) {
            this.systemConfigMapper.updateById((Object)systemConfig);
        }
        return ResponseResult.success();
    }

    @GetMapping(value={"/updateDistance"})
    public ResponseResult updateDistance(@RequestParam float distance, @RequestParam(required=false, defaultValue="1") int type) {
        if (type == 1) {
            this.redisTemplate.opsForValue().set((Object)"distance1", (Object)Float.valueOf(distance));
        }
        if (type == 2) {
            this.redisTemplate.opsForValue().set((Object)"distance2", (Object)Float.valueOf(distance));
        }
        return ResponseResult.success();
    }

    @GetMapping(value={"/getDistance"})
    public ResponseResult getDistance() {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        Object distanceObject1 = this.redisTemplate.opsForValue().get((Object)"distance1");
        Object distanceObject2 = this.redisTemplate.opsForValue().get((Object)"distance2");
        if (distanceObject1 == null) {
            map.put("distance1", 0);
        } else {
            Float distance1 = Float.valueOf(distanceObject1.toString());
            map.put("distance1", distance1.intValue());
        }
        if (distanceObject2 == null) {
            map.put("distance2", 0);
        } else {
            Float distance2 = Float.valueOf(distanceObject2.toString());
            map.put("distance2", distance2.intValue());
        }
        return ResponseResult.success(map);
    }

    @GetMapping(value={"tile/local"})
    public ResponseEntity<InputStreamResource> tileLocal(@RequestParam(required=false) Integer z, @RequestParam(required=false) Integer x, @RequestParam(required=false) Integer y) {
        FileInputStream inputStream;
        Object mapLocationObject = this.redisTemplate.opsForValue().get((Object)"mapLocation");
        String mapLocation = "";
        if (mapLocationObject == null) {
            SystemConfig mapConfig = (SystemConfig)this.systemConfigMapper.selectOne((Wrapper)Wrappers.lambdaQuery().eq(SystemConfig::getConfigType, (Object)"mapLocation"));
            if (mapConfig != null) {
                mapLocation = mapConfig.getConfigValue();
                this.redisTemplate.opsForValue().set((Object)"mapLocation", (Object)mapLocation);
            }
        } else {
            mapLocation = mapLocationObject.toString();
        }
        File file = Paths.get(mapLocation, String.valueOf(z), String.valueOf(x), String.valueOf(y), "tile.png").toFile();
        if (!file.exists()) {
            return ResponseEntity.notFound().build();
        }
        try {
            inputStream = new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        InputStreamResource resource = new InputStreamResource((InputStream)inputStream);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("Content-Disposition", new String[]{"attachment;filename=tile.png"})).contentType(MediaType.IMAGE_PNG).body((Object)resource);
    }

    @PostMapping(value={"/editWarningState"})
    public ResponseResult editWarningState(String id, Integer state) {
        ExpWarningTemp expWarningTemp;
        ExpWarning expWarning = (ExpWarning)this.expWarningMapper.selectById((Serializable)((Object)id));
        if (expWarning != null) {
            expWarning.setState(state);
            this.expWarningMapper.updateById((Object)expWarning);
        }
        if ((expWarningTemp = (ExpWarningTemp)this.expWarningTempMapper.selectById((Serializable)((Object)id))) != null) {
            expWarningTemp.setState(state);
            this.expWarningTempMapper.updateById((Object)expWarningTemp);
        }
        return ResponseResult.success();
    }

    @PostMapping(value={"/editWarningPositive"})
    public ResponseResult editWarningPositive(String id, Integer positive) {
        ExpWarningTemp expWarningTemp;
        ExpWarning expWarning = (ExpWarning)this.expWarningMapper.selectById((Serializable)((Object)id));
        if (expWarning != null) {
            expWarning.setPositive(positive);
            this.expWarningMapper.updateById((Object)expWarning);
        }
        if ((expWarningTemp = (ExpWarningTemp)this.expWarningTempMapper.selectById((Serializable)((Object)id))) != null) {
            expWarningTemp.setPositive(positive);
            this.expWarningTempMapper.updateById((Object)expWarningTemp);
        }
        return ResponseResult.success();
    }

    @PostMapping(value={"/addBigWarning"})
    public ResponseResult addBigWarning(@RequestBody BigWarningParam bigWarningParam) throws Exception {
        ExpWarning expWarning = new ExpWarning();
        expWarning.setType(Integer.valueOf(7));
        int orientation = bigWarningParam.getOrientation();
        List carKRoadList = this.carKRoadMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(CarKRoad::getType, (Object)1)).orderByAsc(CarKRoad::getId));
        CarKRoad brokeCarKRoad = GeoUtil.getCarKRoadByDistance((int)bigWarningParam.getDistance(), (List)carKRoadList);
        List orientationConfigList = this.systemConfigMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SystemConfig::getConfigType, (Object)"orientation")).orderByAsc(SystemConfig::getConfigSort));
        for (SystemConfig systemConfig : orientationConfigList) {
            if (Integer.parseInt(systemConfig.getConfigValue()) != orientation) continue;
            expWarning.setMessage("[\u5730\u707e\u5f15\u8d77\u91cd\u5927\u4e8b\u4ef6]" + systemConfig.getConfigName() + brokeCarKRoad.getRealKName() + ",\u65ad\u88c2\u540e\u5269\u4f59\u957f\u5ea6" + bigWarningParam.getDistance() + "\u7c73");
        }
        expWarning.setDistance(Integer.valueOf(bigWarningParam.getDistance()));
        expWarning.setOrientation(Integer.valueOf(orientation));
        expWarning.setLongitude(brokeCarKRoad.getLng());
        expWarning.setLatitude(brokeCarKRoad.getLat());
        expWarning.setWarningArea(brokeCarKRoad.getKName());
        expWarning.setDataTime(bigWarningParam.getStartTime());
        expWarning.setEndTime(bigWarningParam.getStartTime());
        expWarning.setState(Integer.valueOf(0));
        expWarning.setCreateTime(LocalDateTime.now());
        this.expWarningMapper.insert((Object)expWarning);
        this.warningSocketHandler.sendExpWarning(JSON.toJSONString((Object)expWarning));
        return ResponseResult.success();
    }

    @PostMapping(value={"/addBigWarning/v2"})
    public ResponseResult addBigWarningV2(@RequestBody BigWarningV2 param) throws Exception {
        List channelParamList = this.systemConfigMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SystemConfig::getConfigType, (Object)"channelParam")).orderByAsc(SystemConfig::getConfigSort));
        ExpWarning expWarning = new ExpWarning();
        expWarning.setType(Integer.valueOf(7));
        SystemConfig found = channelParamList.stream().filter(config -> param.getChannel().equals(config.getConfigValue())).findFirst().get();
        List carKRoadList = this.carKRoadMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(CarKRoad::getType, (Object)1)).orderByAsc(CarKRoad::getId));
        CarKRoad brokeCarKRoad = GeoUtil.getCarKRoadByDistance((int)param.getChainage().intValue(), (List)carKRoadList);
        expWarning.setMessage("[\u5730\u707e\u5f15\u8d77\u91cd\u5927\u4e8b\u4ef6]" + found.getConfigValueExt2() + brokeCarKRoad.getRealKName());
        expWarning.setDistance(Integer.valueOf(param.getChainage().intValue()));
        expWarning.setOrientation(new Integer(found.getConfigValueExt()));
        expWarning.setLongitude(brokeCarKRoad.getLng());
        expWarning.setLatitude(brokeCarKRoad.getLat());
        expWarning.setWarningArea(brokeCarKRoad.getKName());
        expWarning.setDataTime(LocalDateTime.now());
        expWarning.setEndTime(LocalDateTime.now());
        expWarning.setState(Integer.valueOf(0));
        expWarning.setCreateTime(LocalDateTime.now());
        this.expWarningMapper.insert((Object)expWarning);
        this.warningSocketHandler.sendExpWarning(JSON.toJSONString((Object)expWarning));
        return ResponseResult.success();
    }

    @PostMapping(value={"/addVibrationWarning"})
    public ResponseResult addVibrationWarning(@RequestBody BigWarningParam bigWarningParam) throws Exception {
        ExpWarning expWarning = new ExpWarning();
        expWarning.setType(Integer.valueOf(8));
        int orientation = bigWarningParam.getOrientation();
        List carKRoadList = this.carKRoadMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(CarKRoad::getType, (Object)1)).orderByAsc(CarKRoad::getId));
        CarKRoad brokeCarKRoad = GeoUtil.getCarKRoadByDistance((int)bigWarningParam.getDistance(), (List)carKRoadList);
        List orientationConfigList = this.systemConfigMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SystemConfig::getConfigType, (Object)"orientation")).orderByAsc(SystemConfig::getConfigSort));
        for (SystemConfig systemConfig : orientationConfigList) {
            if (Integer.parseInt(systemConfig.getConfigValue()) != orientation) continue;
            expWarning.setMessage("[" + bigWarningParam.getMessage() + "]" + systemConfig.getConfigName() + brokeCarKRoad.getRealKName());
        }
        expWarning.setOrientation(Integer.valueOf(orientation));
        expWarning.setDistance(Integer.valueOf(bigWarningParam.getDistance()));
        expWarning.setLongitude(brokeCarKRoad.getLng());
        expWarning.setLatitude(brokeCarKRoad.getLat());
        expWarning.setWarningArea(brokeCarKRoad.getKName());
        expWarning.setDataTime(bigWarningParam.getStartTime());
        expWarning.setEndTime(bigWarningParam.getStartTime());
        expWarning.setState(Integer.valueOf(0));
        expWarning.setCreateTime(LocalDateTime.now());
        this.expWarningMapper.insert((Object)expWarning);
        this.warningSocketHandler.sendExpWarning(JSON.toJSONString((Object)expWarning));
        return ResponseResult.success();
    }

    @GetMapping(value={"/trackByWarningId"})
    public ResponseResult getCarTrackByWarnIngId(@RequestParam Long warningId, @RequestParam int pageNo, @RequestParam int pageSize) {
        Page page = new Page((long)pageNo, (long)pageSize);
        IPage carTrackIPage = this.carTrackMapper.selectPage((IPage)page, (Wrapper)Wrappers.lambdaQuery().eq(CarTrack::getExpWarningId, (Object)warningId));
        return ResponseResult.success((Object)carTrackIPage);
    }

    @GetMapping(value={"/todayStopSlowWarning"})
    public ResponseResult getTodayStopSlowWarning() {
        List warningList = this.expWarningMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().ge(ExpWarning::getCreateTime, (Object)LocalDate.now().atStartOfDay())).in(ExpWarning::getType, Arrays.asList(1, 2, 3, 4, 5, 6))).le(ExpWarning::getCreateTime, (Object)LocalDateTime.now().minusMinutes(1L)));
        ArrayList<JSONObject> list = new ArrayList<JSONObject>();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd_HH-mm-ss");
        for (ExpWarning expWarning : warningList) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.set("id", (Object)expWarning.getId());
            jsonObject.set("dataTime", (Object)expWarning.getDataTime().format(formatter));
            jsonObject.set("tempId", (Object)expWarning.getTempId());
            jsonObject.set("orientation", (Object)expWarning.getOrientation());
            jsonObject.set("distance", (Object)expWarning.getDistance());
            jsonObject.set("kName", (Object)expWarning.getWarningArea());
            jsonObject.set("type", (Object)expWarning.getType());
            list.add(jsonObject);
        }
        return ResponseResult.success(list);
    }

    @GetMapping(value={"/platformWarning"})
    public ResponseResult getPlatformWarning() {
        List dotDataList = this.dotDataMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().ge(DotData::getCreateTime, (Object)LocalDate.now().atStartOfDay())).in(DotData::getResult, Arrays.asList(0, 3))).le(DotData::getCreateTime, (Object)LocalDateTime.now().minusMinutes(5L)));
        SimpleDateFormat inputFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        SimpleDateFormat outputFormat = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss");
        ArrayList<JSONObject> list = new ArrayList<JSONObject>();
        for (DotData data : dotDataList) {
            JSONObject jsonObject = new JSONObject();
            List segments = (List)JSON.parseObject((String)data.getValueStr(), (TypeReference)new /* Unavailable Anonymous Inner Class!! */, (JSONReader.Feature[])new JSONReader.Feature[0]);
            jsonObject.set("id", (Object)data.getId());
            String time = (String)((Map)segments.get(segments.size() - 1)).get("time");
            Date date = null;
            try {
                date = inputFormat.parse(time);
            }
            catch (ParseException e) {
                throw new RuntimeException(e);
            }
            String outputDate = outputFormat.format(date);
            jsonObject.set("dataTime", (Object)outputDate);
            jsonObject.set("tempId", ((Map)segments.get(segments.size() - 1)).get("tempId"));
            jsonObject.set("orientation", ((Map)segments.get(segments.size() - 1)).get("orientation"));
            jsonObject.set("distance", ((Map)segments.get(segments.size() - 1)).get("distance"));
            jsonObject.set("kName", ((Map)segments.get(segments.size() - 1)).get("kName"));
            jsonObject.set("type", (Object)1);
            jsonObject.set("result", (Object)data.getResult());
            list.add(jsonObject);
        }
        return ResponseResult.success(list);
    }

    @PostMapping(value={"/exportExpWarning"})
    public ResponseResult exportExpWarning(@RequestBody PageEntity pageEntity) {
        LocalDate endLocalDate;
        if (pageEntity.getStartDate() == null || pageEntity.getEndDate() == null) {
            return ResponseResult.error((String)"\u5f00\u59cb\u65f6\u95f4\u6216\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ZoneId beijing = ZoneId.of("Asia/Shanghai");
        LocalDate startLocalDate = pageEntity.getStartDate().toInstant().atZone(beijing).toLocalDate();
        if (!startLocalDate.equals(endLocalDate = pageEntity.getEndDate().toInstant().atZone(beijing).toLocalDate())) {
            return ResponseResult.error((String)"\u6682\u4e0d\u652f\u6301\u8de8\u5929\u67e5\u8be2");
        }
        if (pageEntity.getExpState() == null) {
            pageEntity.setExpState(Integer.valueOf(99));
        }
        if (pageEntity.getUpgrade() == null) {
            pageEntity.setUpgrade(Integer.valueOf(-1));
        }
        ArrayList<Integer> stateList = new ArrayList<Integer>();
        if (pageEntity.getExpState() == 99) {
            stateList.add(0);
            stateList.add(1);
        } else {
            stateList.add(pageEntity.getExpState());
        }
        Integer startDistance = null;
        Integer endDistance = null;
        if (StrUtil.isNotBlank((CharSequence)pageEntity.getStartDistance())) {
            startDistance = Integer.valueOf(pageEntity.getStartDistance());
        }
        if (StrUtil.isNotBlank((CharSequence)pageEntity.getEndDistance())) {
            endDistance = Integer.valueOf(pageEntity.getEndDistance());
        }
        if (startDistance != null && endDistance == null || startDistance == null && endDistance != null) {
            return ResponseResult.error((String)"\u5f00\u59cbK\u6807\u548c\u7ed3\u675fK\u6807\u5fc5\u987b\u540c\u65f6\u9009\u6216\u8005\u540c\u65f6\u4e0d\u9009");
        }
        if (startDistance != null && startDistance > endDistance) {
            Integer temp = startDistance;
            startDistance = endDistance;
            endDistance = temp;
        }
        LocalDate today = LocalDate.now();
        LocalDateTime start = today.atStartOfDay();
        LocalDateTime end = today.atTime(LocalTime.MAX);
        ZoneId beijingZone = ZoneId.of("Asia/Shanghai");
        LocalDateTime inputTime = pageEntity.getStartDate().toInstant().atZone(beijingZone).toLocalDateTime().plusSeconds(1L);
        if (inputTime.isAfter(start) && inputTime.isBefore(end)) {
            List list = this.expWarningMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().ge(startDistance != null, ExpWarning::getDistance, (Object)startDistance)).le(endDistance != null, ExpWarning::getDistance, (Object)endDistance)).ge(ExpWarning::getDataTime, (Object)pageEntity.getStartDate())).lt(ExpWarning::getDataTime, (Object)pageEntity.getEndDate())).eq(pageEntity.getUpgrade() != -1, ExpWarning::getUpgrade, (Object)pageEntity.getUpgrade())).eq(StrUtil.isNotBlank((CharSequence)pageEntity.getTempId()), ExpWarning::getTempId, (Object)pageEntity.getTempId())).eq(pageEntity.getExpType() != null && pageEntity.getExpType() != 0, ExpWarning::getType, (Object)pageEntity.getExpType())).in(ExpWarning::getState, stateList)).orderByDesc(ExpWarning::getDataTime));
            return ResponseResult.success((Object)list);
        }
        List list = this.expWarningTempMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().ge(startDistance != null, ExpWarningTemp::getDistance, (Object)startDistance)).le(endDistance != null, ExpWarningTemp::getDistance, (Object)endDistance)).ge(ExpWarningTemp::getDataTime, (Object)pageEntity.getStartDate())).lt(ExpWarningTemp::getDataTime, (Object)pageEntity.getEndDate())).eq(pageEntity.getUpgrade() != -1, ExpWarningTemp::getUpgrade, (Object)pageEntity.getUpgrade())).eq(StrUtil.isNotBlank((CharSequence)pageEntity.getTempId()), ExpWarningTemp::getTempId, (Object)pageEntity.getTempId())).eq(pageEntity.getExpType() != null && pageEntity.getExpType() != 0, ExpWarningTemp::getType, (Object)pageEntity.getExpType())).in(ExpWarningTemp::getState, stateList)).orderByDesc(ExpWarningTemp::getDataTime));
        return ResponseResult.success((Object)list);
    }

    @PostMapping(value={"/addWarning"})
    public ResponseResult addWarning(@RequestBody ExpWarning warning) {
        List carKRoadList = this.carKRoadMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(CarKRoad::getType, (Object)1)).orderByAsc(CarKRoad::getId));
        List roadInfoList = this.roadInfoMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(RoadInfo::getType, (Object)2)).orderByAsc(RoadInfo::getRoadSort));
        List orientationConfigList = this.systemConfigMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SystemConfig::getConfigType, (Object)"orientation")).orderByAsc(SystemConfig::getConfigSort));
        String[] kTagArray = warning.getWarningArea().split("\\+");
        String kTag = kTagArray[0].toUpperCase();
        int bigDistance = Integer.parseInt(kTag.replace("K", "")) * 1000;
        int distance = Integer.parseInt(kTagArray[1]) + bigDistance;
        CarKRoad tempCarKRoad = null;
        for (CarKRoad carKRoad : carKRoadList) {
            int start = carKRoad.getDistance() > carKRoad.getDistanceEnd() ? carKRoad.getDistanceEnd() : carKRoad.getDistance();
            int end = carKRoad.getDistance() > carKRoad.getDistanceEnd() ? carKRoad.getDistance() : carKRoad.getDistanceEnd();
            if (distance < start || distance > end) continue;
            tempCarKRoad = carKRoad;
        }
        if (tempCarKRoad == null) {
            return ResponseResult.error((String)"\u672a\u627e\u5230k\u6807");
        }
        int randomNumber = ThreadLocalRandom.current().nextInt(10000, 100000);
        String randomString = String.valueOf(randomNumber);
        warning.setTempId(randomString);
        Object currentRoad = null;
        for (Object roadInfo : roadInfoList) {
            if (tempCarKRoad.getDistance() <= roadInfo.getStartDistance() || tempCarKRoad.getDistance() > roadInfo.getEndDistance()) continue;
            currentRoad = roadInfo;
        }
        warning.setRoadId(currentRoad.getId());
        warning.setLongitude(tempCarKRoad.getLng());
        warning.setLatitude(tempCarKRoad.getLat());
        String orientationName = "";
        for (SystemConfig systemConfig : orientationConfigList) {
            if (Integer.parseInt(systemConfig.getConfigValue()) != warning.getOrientation()) continue;
            orientationName = systemConfig.getConfigName();
        }
        String warningTypeName = "";
        if (warning.getType() == 1) {
            warningTypeName = "[\u5355\u8f66\u505c\u8f66\u9884\u8b66]";
        } else if (warning.getType() == 2) {
            warningTypeName = "[\u591a\u8f66\u505c\u8f66\u9884\u8b66]";
        } else if (warning.getType() == 3) {
            warningTypeName = "[\u591a\u8f66\u7f13\u884c\u9884\u8b66]";
        } else if (warning.getType() == 4) {
            warningTypeName = "[\u591a\u8f66\u62e5\u5835\u9884\u8b66]";
        } else if (warning.getType() == 5) {
            warningTypeName = "[\u5355\u8f66\u6162\u901f\u9884\u8b66]";
        } else if (warning.getType() == 6) {
            warningTypeName = "[\u77ed\u65f6\u591a\u8f66\u7f13\u6162\u9884\u8b66]";
        } else if (warning.getType() == 7) {
            warningTypeName = "[\u5730\u707e\u5f15\u8d77\u91cd\u5927\u4e8b\u4ef6]";
        }
        warning.setMessage(warningTypeName + orientationName + warning.getWarningArea() + "\u5e73\u5747\u901f\u5ea6" + warning.getSpeed().intValue() + "km/h");
        warning.setDistance(tempCarKRoad.getDistance());
        warning.setEndTime(warning.getDataTime());
        warning.setCreateTime(warning.getDataTime());
        boolean sendFlag = false;
        if (warning.getId() == 1L) {
            sendFlag = true;
        }
        warning.setId(null);
        this.expWarningMapper.insert((Object)warning);
        int randomSpeed = (int)(Math.random() * 21.0) + 80;
        int endSpeed = warning.getSpeed().intValue();
        double step = (double)(randomSpeed - endSpeed) / 19.0;
        ArrayList<Integer> speedList = new ArrayList<Integer>();
        for (int i = 0; i < 20; ++i) {
            int speed = (int)Math.round((double)randomSpeed - (double)i * step);
            speedList.add(speed);
        }
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        for (int i = 0; i < 20; ++i) {
            CarTrack track = new CarTrack();
            track.setId("8766");
            track.setSpeed(Float.valueOf(((Integer)speedList.get(i)).intValue()));
            track.setExpWarningId(warning.getId());
            track.setDistance(Integer.valueOf(warning.getDistance() - 7 * i));
            track.setCurrentTimeStr(warning.getDataTime().minusSeconds(20 - i).format(formatter));
            for (SystemConfig systemConfig : orientationConfigList) {
                if (Integer.parseInt(systemConfig.getConfigValue()) != warning.getOrientation()) continue;
                track.setOrientationName(systemConfig.getConfigName());
            }
            track.setRealKName(warning.getWarningArea());
            track.setTempId(randomString);
            track.setExtendedTag(Integer.valueOf(0));
            track.setWidth(Float.valueOf(10.0f));
            track.setStartx(warning.getDistance());
            track.setEndx(warning.getDistance());
            track.setConf(Double.valueOf(0.89));
            this.carTrackMapper.insert((Object)track);
        }
        if (sendFlag) {
            try {
                this.warningSocketHandler.sendExpWarning(JSON.toJSONString((Object)warning));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return ResponseResult.success();
    }

    @GetMapping(value={"/kList"})
    public ResponseResult getKList() {
        List carKRoadList = this.carKRoadMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(CarKRoad::getType, (Object)1)).orderByAsc(CarKRoad::getId));
        return ResponseResult.success((Object)carKRoadList);
    }

    @GetMapping(value={"/camera/k323"})
    public void proxyVideoStream323(@RequestHeader HttpHeaders headers, HttpServletRequest request, HttpServletResponse response) throws IOException {
        String videoUrl = "http://106.119.203.252:8090/live/k323.live.mp4";
        this.restTemplate.execute(URI.create(videoUrl), HttpMethod.GET, this.requestCallback(headers), this.responseExtractor(response));
    }

    @GetMapping(value={"/camera/k328"})
    public void proxyVideoStream328(@RequestHeader HttpHeaders headers, HttpServletRequest request, HttpServletResponse response) throws IOException {
        String videoUrl = "http://106.119.203.252:8090/live/k328.live.mp4";
        this.restTemplate.execute(URI.create(videoUrl), HttpMethod.GET, this.requestCallback(headers), this.responseExtractor(response));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @GetMapping(value={"/test1"})
    public ResponseResult test1(@RequestParam String url) {
        OkHttpClient client = new OkHttpClient.Builder().connectTimeout(3L, TimeUnit.SECONDS).readTimeout(3L, TimeUnit.SECONDS).writeTimeout(3L, TimeUnit.SECONDS).build();
        JSONObject jsonObject = new JSONObject();
        jsonObject.set("type", (Object)7);
        jsonObject.set("createTime", (Object)"2025-10-10 12:00:00");
        jsonObject.set("distance", (Object)200);
        okhttp3.RequestBody body = okhttp3.RequestBody.create((String)jsonObject.toString(), (okhttp3.MediaType)okhttp3.MediaType.get((String)"application/json;charset=utf-8"));
        Request request = new Request.Builder().url(url).post(body).build();
        try (Response response = client.newCall(request).execute();){
            if (response.isSuccessful()) {
                ResponseResult responseResult2 = ResponseResult.success();
                return responseResult2;
            }
            ResponseResult responseResult = ResponseResult.error((String)("\u8c03\u7528\u5931\u8d25:" + response.code()));
            return responseResult;
        }
        catch (Exception ignored) {
            return ResponseResult.error((String)("\u8c03\u7528\u5931\u8d25:" + ignored.getMessage()));
        }
    }

    private RequestCallback requestCallback(HttpHeaders headers) {
        return clientHttpRequest -> headers.forEach((key, value) -> {
            for (String s : value) {
                clientHttpRequest.getHeaders().add(key, s);
            }
        });
    }

    private ResponseExtractor<Void> responseExtractor(HttpServletResponse response) {
        return clientHttpResponse -> {
            response.setStatus(clientHttpResponse.getRawStatusCode());
            clientHttpResponse.getHeaders().forEach((key, value) -> {
                if (!"Transfer-Encoding".equalsIgnoreCase((String)key)) {
                    value.forEach(headerValue -> response.addHeader(key, headerValue));
                }
            });
            StreamUtils.copy((InputStream)clientHttpResponse.getBody(), (OutputStream)response.getOutputStream());
            return null;
        };
    }
}

