/*
 * Decompiled with CFR 0.152.
 */
package com.shengmu.controller;

import com.alibaba.fastjson2.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.shengmu.mapper.CameraMapper;
import com.shengmu.mapper.CarKRoadMapper;
import com.shengmu.mapper.ExpWarningMapper;
import com.shengmu.mapper.ExpWarningTempMapper;
import com.shengmu.mapper.SystemConfigMapper;
import com.shengmu.modal.dto.VideoWarning;
import com.shengmu.modal.entity.Camera;
import com.shengmu.modal.entity.CarKRoad;
import com.shengmu.modal.entity.ExpWarning;
import com.shengmu.modal.entity.ExpWarningTemp;
import com.shengmu.modal.entity.SystemConfig;
import com.shengmu.utils.GeoUtil;
import com.shengmu.utils.ResponseResult;
import com.shengmu.websocket.WarningSocketHandler;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.InputStreamResource;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@CrossOrigin
@RequestMapping(value={"expWarning"})
public class ExpWarningController {
    @Resource
    private ExpWarningMapper expWarningMapper;
    @Resource
    private ExpWarningTempMapper expWarningTempMapper;
    @Resource
    private CameraMapper cameraMapper;
    @Resource
    private CarKRoadMapper carKRoadMapper;
    @Resource
    private WarningSocketHandler warningSocketHandler;
    @Resource
    private SystemConfigMapper systemConfigMapper;
    @Value(value="${custom-config.app-type}")
    private int appType;

    @GetMapping(value={"/updateImage"})
    public ResponseResult updateImage(@RequestParam String imageName, @RequestParam Long id) {
        ExpWarningTemp expWarningTemp;
        ExpWarning expWarning = (ExpWarning)this.expWarningMapper.selectById((Serializable)id);
        if (expWarning != null) {
            expWarning.setImagePath(imageName);
            this.expWarningMapper.updateById((Object)expWarning);
        }
        if ((expWarningTemp = (ExpWarningTemp)this.expWarningTempMapper.selectById((Serializable)id)) != null) {
            expWarningTemp.setImagePath(imageName);
            this.expWarningTempMapper.updateById((Object)expWarningTemp);
        }
        System.out.println(imageName);
        System.out.println(id);
        return ResponseResult.success();
    }

    @GetMapping(value={"/image"})
    public ResponseEntity<InputStreamResource> getImage(@RequestParam Long id) {
        ExpWarningTemp expWarningTemp;
        ArrayList<String> imagePathTemplates = new ArrayList<String>();
        if (this.appType == 1) {
            imagePathTemplates.add("Z:\\year\\month\\day\\combine");
        } else if (this.appType == 2) {
            imagePathTemplates.add("//192.168.1.18/eventImage/left/year/month/day");
            imagePathTemplates.add("//192.168.1.18/eventImage/right/year/month/day");
        } else {
            return ResponseEntity.badRequest().build();
        }
        ExpWarning expWarning = (ExpWarning)this.expWarningMapper.selectById((Serializable)id);
        LocalDateTime time = expWarning != null ? expWarning.getDataTime() : ((expWarningTemp = (ExpWarningTemp)this.expWarningTempMapper.selectById((Serializable)id)) != null ? expWarningTemp.getDataTime() : null);
        if (time == null) {
            System.err.println("time is null");
            return ResponseEntity.notFound().build();
        }
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        String timeStr = time.format(formatter);
        List candidateDirs = imagePathTemplates.stream().map(template -> template.replace("year", timeStr.split("-")[0]).replace("month", timeStr.split("-")[1]).replace("day", timeStr.split("-")[2])).map(x$0 -> Paths.get(x$0, new String[0])).collect(Collectors.toList());
        Path targetFile = null;
        for (Path dir : candidateDirs) {
            if (!Files.exists(dir, new LinkOption[0]) || !Files.isDirectory(dir, new LinkOption[0])) {
                System.err.println("\u76ee\u5f55\u4e0d\u5b58\u5728 = " + dir.toString() + Files.exists(dir, new LinkOption[0]) + Files.isDirectory(dir, new LinkOption[0]));
                continue;
            }
            try {
                Stream<Path> paths = Files.list(dir);
                try {
                    Optional<Path> found = paths.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(p -> p.getFileName().toString().split("_")[0].equals(id.toString())).findFirst();
                    if (!found.isPresent()) continue;
                    targetFile = found.get();
                    break;
                }
                finally {
                    if (paths == null) continue;
                    paths.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (targetFile == null) {
            System.err.println("targetFile == null");
            return ResponseEntity.notFound().build();
        }
        String fileName = targetFile.getFileName().toString().toLowerCase();
        String contentType = "image/jpeg";
        if (fileName.endsWith(".png")) {
            contentType = "image/png";
        } else if (fileName.endsWith(".gif")) {
            contentType = "image/gif";
        } else if (fileName.endsWith(".bmp")) {
            contentType = "image/bmp";
        }
        try {
            InputStream inputStream = Files.newInputStream(targetFile, new OpenOption[0]);
            InputStreamResource resource = new InputStreamResource(inputStream);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().contentType(MediaType.parseMediaType((String)contentType)).contentLength(Files.size(targetFile)).header("Content-Disposition", new String[]{"inline; filename=\"" + targetFile.getFileName().toString() + "\""})).body((Object)resource);
        }
        catch (IOException e) {
            e.printStackTrace();
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).build();
        }
    }

    @GetMapping(value={"/sure"})
    public ResponseResult sureExpWarning(@RequestParam Long id, @RequestParam Integer status) {
        ExpWarning expWarning = (ExpWarning)this.expWarningMapper.selectById((Serializable)id);
        if (status == 1) {
            expWarning.setVideoCheck(Integer.valueOf(3));
        }
        if (status == -1) {
            expWarning.setVideoCheck(Integer.valueOf(2));
        }
        this.expWarningMapper.updateById((Object)expWarning);
        return ResponseResult.success();
    }

    @PostMapping(value={"/video/add"})
    public ResponseResult addVideo(@RequestBody VideoWarning videoWarning) {
        List cameraList = this.cameraMapper.selectList((Wrapper)Wrappers.lambdaQuery());
        Camera found = cameraList.stream().filter(camera -> videoWarning.getCameraName().equals(camera.getName())).findFirst().get();
        List carKRoadList = this.carKRoadMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(CarKRoad::getType, (Object)1)).orderByAsc(CarKRoad::getId));
        CarKRoad carKRoad = GeoUtil.getCarKRoadByDistance((int)found.getDistance(), (List)carKRoadList);
        SystemConfig fileConfig = (SystemConfig)this.systemConfigMapper.selectOne((Wrapper)Wrappers.lambdaQuery().eq(SystemConfig::getConfigType, (Object)"fileLocation"));
        ExpWarning expWarning = new ExpWarning();
        expWarning.setType(Integer.valueOf(1));
        expWarning.setSpeed(Float.valueOf(30.0f));
        expWarning.setLongitude(carKRoad.getLng());
        expWarning.setLatitude(carKRoad.getLat());
        expWarning.setDistance(found.getDistance());
        expWarning.setOrientation(found.getOrientation());
        if (videoWarning.getVideoId() != null) {
            expWarning.setVideoPath(fileConfig.getConfigValue() + "/" + videoWarning.getVideoId());
        }
        if (videoWarning.getImageId() != null) {
            expWarning.setImagePath(fileConfig.getConfigValue() + "/" + videoWarning.getImageId());
        }
        expWarning.setMessage("[\u8def\u8fb9\u505c\u8f66\u9884\u8b66]" + found.getName());
        expWarning.setDataTime(LocalDateTime.now());
        expWarning.setEndTime(LocalDateTime.now());
        expWarning.setState(Integer.valueOf(0));
        expWarning.setVideoCheck(Integer.valueOf(3));
        expWarning.setCreateTime(LocalDateTime.now());
        this.expWarningMapper.insert((Object)expWarning);
        try {
            this.warningSocketHandler.sendExpWarning(JSON.toJSONString((Object)expWarning));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return ResponseResult.success();
    }
}

