/*
 * Decompiled with CFR 0.152.
 */
package com.shengmu.controller;

import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONReader;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.shengmu.config.TrackManager;
import com.shengmu.controller.StatisticsController;
import com.shengmu.mapper.CarKRoadMapper;
import com.shengmu.mapper.DataLogMapper;
import com.shengmu.mapper.ExpWarningMapper;
import com.shengmu.mapper.ExpWarningTempMapper;
import com.shengmu.mapper.RoadInfoMapper;
import com.shengmu.mapper.SystemConfigMapper;
import com.shengmu.modal.dto.CarTrackDTO;
import com.shengmu.modal.dto.CarTrackData;
import com.shengmu.modal.entity.CarKRoad;
import com.shengmu.modal.entity.CarTrack;
import com.shengmu.modal.entity.DataLog;
import com.shengmu.modal.entity.ExpWarning;
import com.shengmu.modal.entity.ExpWarningTemp;
import com.shengmu.modal.entity.RoadInfo;
import com.shengmu.modal.entity.SystemConfig;
import com.shengmu.modal.vo.HomeData;
import com.shengmu.service.CarTrackV2Service;
import com.shengmu.service.CarTrackV3Service;
import com.shengmu.utils.HttpClientProvider;
import com.shengmu.utils.ResponseResult;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import javax.annotation.Resource;
import okhttp3.Callback;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"warning"})
public class ExpWarningTestController {
    @Autowired
    private CarTrackV3Service carTrackV3Service;
    @Autowired
    private CarTrackV2Service carTrackV2Service;
    @Resource
    private DataLogMapper dataLogMapper;
    @Resource
    private SystemConfigMapper systemConfigMapper;
    @Resource
    private CarKRoadMapper carKRoadMapper;
    @Resource
    private TrackManager trackManager;
    @Resource
    private MongoTemplate mongoTemplate;
    @Resource
    private RoadInfoMapper roadInfoMapper;
    @Resource
    private RedisTemplate redisTemplate;
    @Value(value="${custom-config.model-url}")
    private String modelUrl;
    @Resource
    private StatisticsController statisticsController;
    @Autowired
    private ExpWarningMapper expWarningMapper;
    @Resource
    private ExpWarningTempMapper expWarningTempMapper;

    @GetMapping(value={"/test1"})
    public ResponseResult test1(@RequestParam String startDate, @RequestParam String endDate, @RequestParam(required=false) String tempId) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        List dataLogList = this.dataLogMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().ge(DataLog::getLogTime, (Object)LocalDateTime.parse(startDate, formatter))).le(DataLog::getLogTime, (Object)LocalDateTime.parse(endDate, formatter)));
        List orientationConfigList = this.systemConfigMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SystemConfig::getConfigType, (Object)"orientation")).orderByAsc(SystemConfig::getConfigSort));
        List carKRoadList = this.carKRoadMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(CarKRoad::getType, (Object)1)).orderByAsc(CarKRoad::getId));
        this.mongoTemplate.remove(new Query(), CarTrack.class);
        for (DataLog dataLog : dataLogList) {
            CarTrackDTO carTrackDTO = (CarTrackDTO)JSONUtil.toBean((String)dataLog.getValueStr(), CarTrackDTO.class);
            List carTrackDataList = carTrackDTO.getList();
            ArrayList<CarTrack> carTrackList = new ArrayList<CarTrack>();
            for (CarTrackData carTrackData : carTrackDataList) {
                if (!carTrackData.getTime().isAfter(carTrackDTO.getEndTime().minusSeconds(3L))) continue;
                for (int i = 0; i < carTrackData.getCarTempIdList().size(); ++i) {
                    CarTrack carTrack;
                    if (!StrUtil.isEmpty((CharSequence)tempId)) {
                        if (!tempId.equals(carTrackData.getCarTempIdList().get(i))) continue;
                        carTrack = this.carTrackV3Service.getCarTrack(carTrackData, i, orientationConfigList, formatter, carKRoadList);
                        carTrackList.add(carTrack);
                        continue;
                    }
                    carTrack = this.carTrackV3Service.getCarTrack(carTrackData, i, orientationConfigList, formatter, carKRoadList);
                    carTrackList.add(carTrack);
                }
            }
            this.mongoTemplate.insertAll(carTrackList);
            System.out.println(dataLogList.indexOf(dataLog) + 1 + "/" + dataLogList.size());
        }
        return ResponseResult.success();
    }

    @GetMapping(value={"/test2"})
    public ResponseResult test2(@RequestParam String dataStartTime, @RequestParam String dataEndTime, @RequestParam String tempId, @RequestParam int orientation) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        List filterAreaList = this.systemConfigMapper.selectList((Wrapper)Wrappers.lambdaQuery().eq(SystemConfig::getConfigType, (Object)"filterArea"));
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"tempId").is((Object)tempId));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"currentTimeStr").gte((Object)dataStartTime).lte((Object)dataEndTime));
        List carTrackList = this.mongoTemplate.find(query, CarTrack.class);
        this.carTrackV3Service.singleCarStop(LocalDateTime.parse(dataEndTime, formatter), orientation, filterAreaList, carTrackList);
        return ResponseResult.success();
    }

    @GetMapping(value={"/test3"})
    public ResponseResult test3(@RequestParam String startDate, @RequestParam String endDate) throws InterruptedException {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        List dataLogList = this.dataLogMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().ge(DataLog::getLogTime, (Object)LocalDateTime.parse(startDate, formatter))).le(DataLog::getLogTime, (Object)LocalDateTime.parse(endDate, formatter)));
        for (DataLog dataLog : dataLogList) {
            CarTrackDTO carTrackDTO = (CarTrackDTO)JSONUtil.toBean((String)dataLog.getValueStr(), CarTrackDTO.class);
            System.out.println(dataLogList.indexOf(dataLog) + 1 + "/" + dataLogList.size());
            this.carTrackV2Service.processData(carTrackDTO);
            Thread.sleep(500L);
        }
        return ResponseResult.success();
    }

    @GetMapping(value={"/test4"})
    public ResponseResult test4(@RequestParam String startDate, @RequestParam String endDate) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        List dataLogList = this.dataLogMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().ge(DataLog::getLogTime, (Object)LocalDateTime.parse(startDate, formatter))).le(DataLog::getLogTime, (Object)LocalDateTime.parse(endDate, formatter)));
        List carWidthConfigList = this.systemConfigMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SystemConfig::getConfigType, (Object)"carWidth")).orderByAsc(SystemConfig::getConfigSort));
        float carWidth = Float.parseFloat(((SystemConfig)carWidthConfigList.get(0)).getConfigValue());
        ArrayList<CarTrack> carTrackList = new ArrayList<CarTrack>();
        String dayKey = "";
        for (DataLog dataLog : dataLogList) {
            CarTrackData carTrackData;
            CarTrackDTO carTrackDTO = (CarTrackDTO)JSONUtil.toBean((String)dataLog.getValueStr(), CarTrackDTO.class);
            System.out.println(dataLogList.indexOf(dataLog) + 1 + "/" + dataLogList.size());
            DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
            List carTrackDataList = carTrackDTO.getList();
            dayKey = carTrackDTO.getStartTime().format(dateFormatter);
            List carKRoadList = this.carKRoadMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(CarKRoad::getType, (Object)1)).orderByAsc(CarKRoad::getId));
            List positiveCustomRoadInfoList = this.customRoadStatistics(dayKey, 1);
            List negativeCustomRoadInfoList = this.customRoadStatistics(dayKey, -1);
            ArrayList<String> kTagList = new ArrayList<String>();
            for (CarKRoad carKRoad : carKRoadList) {
                if (kTagList.contains(carKRoad.getKTag())) continue;
                kTagList.add(carKRoad.getKTag());
            }
            List customRoadInfoList = new ArrayList();
            Iterator iterator = carTrackDataList.iterator();
            while (iterator.hasNext() && !(carTrackData = (CarTrackData)iterator.next()).getCarTempIdList().isEmpty()) {
                ArrayList<HomeData.DataItem> dataItemList = new ArrayList<HomeData.DataItem>();
                for (String kName : kTagList) {
                    HomeData.DataItem dataItem = new HomeData.DataItem();
                    dataItem.setValueX(kName);
                    dataItemList.add(dataItem);
                }
                int orientation = (Integer)carTrackData.getOrientationList().get(0);
                for (int i = 0; i < carTrackData.getCarTempIdList().size(); ++i) {
                    int distance = (Integer)carTrackData.getDistanceList().get(i);
                    int extendedTag = (Integer)carTrackData.getExtendedTagList().get(i);
                    if (extendedTag == 1) continue;
                    String tempId = (String)carTrackData.getCarTempIdList().get(i);
                    float width = ((Float)carTrackData.getWidthList().get(i)).floatValue();
                    double speed = (int)Math.abs((double)((Float)carTrackData.getSpeedList().get(i)).floatValue() * 3.6);
                    if (orientation == 1) {
                        customRoadInfoList = positiveCustomRoadInfoList;
                    } else if (orientation == -1) {
                        customRoadInfoList = negativeCustomRoadInfoList;
                    }
                    for (RoadInfo roadInfo : customRoadInfoList) {
                        if (distance < roadInfo.getStartDistance() || distance >= roadInfo.getEndDistance()) continue;
                        CarTrack carTrack = new CarTrack();
                        carTrack.setId(tempId);
                        carTrack.setWidth(Float.valueOf(width));
                        carTrack.setOrientation(Integer.valueOf(orientation));
                        carTrackList.add(carTrack);
                        roadInfo.setDaySumSpeed(roadInfo.getDaySumSpeed() + Math.abs(speed));
                        roadInfo.setDaySumCarCount(roadInfo.getDaySumCarCount() + 1);
                        roadInfo.setDayAveSpeed((int)(roadInfo.getDaySumSpeed() / (double)roadInfo.getDaySumCarCount()));
                        roadInfo.getDayCarTempIdSet().add(tempId);
                        roadInfo.setDaySumCarCountUnique(roadInfo.getDayCarTempIdSet().size());
                        LocalDateTime dateTime = carTrackData.getTime();
                        int hour = dateTime.getHour();
                        for (RoadInfo.HourItem hourItem : roadInfo.getHourItemList()) {
                            if (hourItem.getHour() != hour) continue;
                            if (hourItem.getTempIdSet().contains(tempId)) {
                                Optional<RoadInfo.CarItem> optional = hourItem.getCarItemList().stream().filter(tempItem -> tempItem.getTempId().equals(tempId)).findFirst();
                                if (!optional.isPresent()) continue;
                                RoadInfo.CarItem found = optional.get();
                                if (width >= carWidth) {
                                    found.setBigWidthCount(found.getBigWidthCount() + 1);
                                    continue;
                                }
                                if (!(width < carWidth)) continue;
                                found.setSmallWidthCount(found.getSmallWidthCount() + 1);
                                continue;
                            }
                            RoadInfo.CarItem carItem2 = new RoadInfo.CarItem();
                            carItem2.setTempId(tempId);
                            if (width >= carWidth) {
                                carItem2.setBigWidthCount(1);
                            } else if (width < carWidth) {
                                carItem2.setSmallWidthCount(1);
                            }
                            hourItem.getTempIdSet().add(tempId);
                            hourItem.setCarCount(hourItem.getTempIdSet().size());
                            hourItem.getCarItemList().add(carItem2);
                        }
                    }
                }
                for (RoadInfo roadInfo : customRoadInfoList) {
                    LocalDateTime dateTime = carTrackData.getTime();
                    int hour = dateTime.getHour();
                    for (RoadInfo.HourItem hourItem : roadInfo.getHourItemList()) {
                        if (hourItem.getHour() != hour) continue;
                        hourItem.setSmallCarCount(0);
                        hourItem.setBigCarCount(0);
                        hourItem.getCarItemList().forEach(carItem -> {
                            if (carItem.getSmallWidthCount() >= carItem.getBigWidthCount()) {
                                hourItem.setSmallCarCount(hourItem.getSmallCarCount() + 1);
                            } else {
                                hourItem.setBigCarCount(hourItem.getBigCarCount() + 1);
                            }
                        });
                    }
                }
                this.redisTemplate.opsForValue().set((Object)(orientation + "-customRoadInfoList-" + dayKey), JSON.toJSON(customRoadInfoList));
            }
        }
        return ResponseResult.success();
    }

    private List<RoadInfo> customRoadStatistics(String dayKey, int orientation) {
        List customRoadInfoList;
        Object customRoadInfoListObject = this.redisTemplate.opsForValue().get((Object)(orientation + "-customRoadInfoList-" + dayKey));
        if (customRoadInfoListObject == null) {
            customRoadInfoList = this.roadInfoMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(RoadInfo::getType, (Object)3)).orderByAsc(RoadInfo::getRoadSort));
            for (RoadInfo roadInfo : customRoadInfoList) {
                for (int i = 0; i < 24; ++i) {
                    RoadInfo.HourItem hourItem = new RoadInfo.HourItem();
                    hourItem.setHour(i);
                    roadInfo.getHourItemList().add(hourItem);
                }
            }
        } else {
            customRoadInfoList = JSON.parseArray((String)customRoadInfoListObject.toString(), RoadInfo.class, (JSONReader.Feature[])new JSONReader.Feature[0]);
        }
        return customRoadInfoList;
    }

    @GetMapping(value={"/test5"})
    public ResponseResult test5() {
        ArrayList jsonObjectList = new ArrayList();
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("orientation", (Object)1);
        jsonObject.put("startx", (Object)1);
        jsonObject.put("endx", (Object)2);
        jsonObject.put("speed", (Object)45);
        jsonObject.put("tempId", (Object)"1");
        jsonObject.put("time", (Object)"2025-10-10 12:00:00");
        jsonObject.put("distance", (Object)100);
        jsonObject.put("kName", (Object)"K1");
        Request request = new Request.Builder().url(this.modelUrl).post(RequestBody.create((MediaType)MediaType.get((String)"application/json;charset=utf-8"), (String)JSONUtil.toJsonStr(jsonObjectList))).build();
        HttpClientProvider.getHttpClient().newCall(request).enqueue((Callback)new /* Unavailable Anonymous Inner Class!! */);
        return ResponseResult.success();
    }

    @GetMapping(value={"/test6"})
    public ResponseResult test6(@RequestParam String startDate, @RequestParam String endDate) {
        this.redisTemplate.getConnectionFactory().getConnection().flushAll();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        List dataLogList = this.dataLogMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().ge(DataLog::getLogTime, (Object)LocalDateTime.parse(startDate, formatter))).le(DataLog::getLogTime, (Object)LocalDateTime.parse(endDate, formatter)));
        for (DataLog dataLog : dataLogList) {
            System.out.println(dataLogList.indexOf(dataLog) + 1 + "/" + dataLogList.size());
            this.redisTemplate.opsForValue().set((Object)"carTrackDTO", (Object)dataLog.getValueStr());
            this.statisticsController.statisticsData();
        }
        return ResponseResult.success();
    }

    @GetMapping(value={"/test7"})
    public ResponseResult test7() {
        LocalDateTime now = LocalDateTime.now();
        LocalDateTime yesterdayStart = now.minusDays(1L).with(LocalTime.MIN);
        LocalDateTime yesterdayEnd = now.minusDays(1L).with(LocalTime.MAX);
        List expWarningList = this.expWarningMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().ge(ExpWarning::getCreateTime, (Object)yesterdayStart)).le(ExpWarning::getCreateTime, (Object)yesterdayEnd));
        ArrayList<Long> ids = new ArrayList<Long>();
        for (ExpWarning expWarning : expWarningList) {
            ExpWarningTemp expWarningTemp = new ExpWarningTemp();
            BeanUtils.copyProperties((Object)expWarning, (Object)expWarningTemp);
            this.expWarningTempMapper.insert((Object)expWarningTemp);
            ids.add(expWarning.getId());
        }
        this.expWarningMapper.deleteBatchIds(ids);
        return ResponseResult.success();
    }
}

