/*
 * Decompiled with CFR 0.152.
 */
package com.shengmu.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.shengmu.mapper.SystemConfigMapper;
import com.shengmu.modal.entity.SystemConfig;
import com.shengmu.utils.ResponseResult;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.UUID;
import javax.annotation.Resource;
import org.springframework.core.io.InputStreamResource;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@CrossOrigin
@RequestMapping(value={"file"})
public class FileController {
    @Resource
    private SystemConfigMapper systemConfigMapper;

    @PostMapping(value={"/upload"})
    public ResponseResult uploadFile(@RequestParam(value="file") MultipartFile file) {
        SystemConfig fileConfig = (SystemConfig)this.systemConfigMapper.selectOne((Wrapper)Wrappers.lambdaQuery().eq(SystemConfig::getConfigType, (Object)"fileLocation"));
        if (fileConfig == null) {
            return ResponseResult.error((String)"\u672a\u914d\u7f6e\u6587\u4ef6\u5730\u5740");
        }
        try {
            String fileExtension = "";
            String originalFilename = file.getOriginalFilename();
            if (originalFilename != null && originalFilename.contains(".")) {
                fileExtension = originalFilename.substring(originalFilename.lastIndexOf("."));
            }
            String uuid = UUID.randomUUID().toString();
            String newFileName = uuid + fileExtension;
            Path filePath = Paths.get(fileConfig.getConfigValue(), newFileName);
            Files.copy(file.getInputStream(), filePath, new CopyOption[0]);
            return ResponseResult.success((Object)newFileName);
        }
        catch (IOException e) {
            e.printStackTrace();
            return ResponseResult.error((String)("Failed to upload " + file.getOriginalFilename() + ". Error: " + e.getMessage()));
        }
    }

    @GetMapping(value={"/image/{fileName}"})
    public ResponseEntity<InputStreamResource> getImage(@PathVariable(value="fileName") String fileName) {
        FileInputStream inputStream;
        SystemConfig fileConfig = (SystemConfig)this.systemConfigMapper.selectOne((Wrapper)Wrappers.lambdaQuery().eq(SystemConfig::getConfigType, (Object)"fileLocation"));
        fileName = fileName.replace("-", File.separator);
        File file = new File(fileConfig.getConfigValue() + File.separator + fileName);
        try {
            inputStream = new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        MediaType mediaType = fileName.toLowerCase().endsWith(".png") ? MediaType.IMAGE_PNG : (fileName.toLowerCase().endsWith(".jpg") || fileName.toLowerCase().endsWith(".jpeg") ? MediaType.IMAGE_JPEG : (fileName.toLowerCase().endsWith(".gif") ? MediaType.IMAGE_GIF : MediaType.APPLICATION_OCTET_STREAM));
        InputStreamResource resource = new InputStreamResource((InputStream)inputStream);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("Content-Disposition", new String[]{"attachment;filename=" + fileName})).contentType(mediaType).body((Object)resource);
    }
}

