/*
 * Decompiled with CFR 0.152.
 */
package com.shengmu.controller;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONReader;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.shengmu.mapper.CarKRoadMapper;
import com.shengmu.mapper.DataLogTempMapper;
import com.shengmu.mapper.ExpTypeMapper;
import com.shengmu.mapper.ExpWarningMapper;
import com.shengmu.mapper.ExpWarningTempMapper;
import com.shengmu.mapper.RoadInfoMapper;
import com.shengmu.mapper.SystemConfigMapper;
import com.shengmu.modal.dto.CarTrackDTO;
import com.shengmu.modal.dto.CarTrackData;
import com.shengmu.modal.entity.CarKRoad;
import com.shengmu.modal.entity.DataLogTemp;
import com.shengmu.modal.entity.ExpType;
import com.shengmu.modal.entity.ExpWarning;
import com.shengmu.modal.entity.ExpWarningTemp;
import com.shengmu.modal.entity.RoadInfo;
import com.shengmu.modal.entity.SystemConfig;
import com.shengmu.modal.vo.ChartItemVO;
import com.shengmu.modal.vo.ExpTypeVO;
import com.shengmu.modal.vo.ExpWarningVO;
import com.shengmu.modal.vo.HGRoadStatisticsDataVO;
import com.shengmu.modal.vo.MapDataVO;
import com.shengmu.modal.vo.RoadStatisticsDataVO;
import com.shengmu.modal.vo.WarningHotVO;
import com.shengmu.utils.GeoUtil;
import com.shengmu.utils.ResponseResult;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/*
 * Exception performing whole class analysis ignored.
 */
@RestController
@CrossOrigin
@RequestMapping(value={"statistics"})
public class StatisticsController {
    @Resource
    private RedisTemplate redisTemplate;
    @Resource
    private SystemConfigMapper systemConfigMapper;
    @Resource
    private CarKRoadMapper carKRoadMapper;
    @Resource
    private RoadInfoMapper roadInfoMapper;
    @Resource
    private ExpWarningMapper expWarningMapper;
    @Resource
    private ExpWarningTempMapper expWarningTempMapper;
    @Resource
    private ExpTypeMapper expTypeMapper;
    @Resource
    private DataLogTempMapper dataLogTempMapper;
    @Value(value="${custom-config.app-type}")
    private int appType;

    @Scheduled(fixedRate=3000L)
    public void statisticsData() {
        if (this.appType != 2 && this.appType != 3) {
            return;
        }
        Object carTrackDTOObject = this.redisTemplate.opsForValue().get((Object)"carTrackDTO");
        if (carTrackDTOObject != null) {
            CarTrackData carTrackData;
            List roadInfoList;
            int upDownValue;
            List orientationConfigList = this.systemConfigMapper.selectList((Wrapper)Wrappers.lambdaQuery().eq(SystemConfig::getConfigType, (Object)"orientation"));
            int orientationValue = Integer.parseInt(((SystemConfig)orientationConfigList.get(0)).getConfigValue());
            boolean switchValue = orientationValue == (upDownValue = Integer.parseInt(((SystemConfig)orientationConfigList.get(0)).getConfigValueExt()));
            CarTrackDTO carTrackDTO = (CarTrackDTO)JSON.parseObject((String)carTrackDTOObject.toString(), CarTrackDTO.class);
            if (carTrackDTO.getList().isEmpty()) {
                return;
            }
            DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
            String dayKey = carTrackDTO.getStartTime().format(dateFormatter);
            List statisticsList = carTrackDTO.getList().stream().filter(data -> data.getTime().isEqual(carTrackDTO.getEndTime())).collect(Collectors.toList());
            List carWidthConfigList = this.systemConfigMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SystemConfig::getConfigType, (Object)"carWidth")).orderByAsc(SystemConfig::getConfigSort));
            float carWidthParam = Float.parseFloat(((SystemConfig)carWidthConfigList.get(0)).getConfigValue());
            List carKRoadList = this.carKRoadMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(CarKRoad::getType, (Object)1)).orderByAsc(CarKRoad::getId));
            Object roadInfoListObject = this.redisTemplate.opsForValue().get((Object)(dayKey + "-roadInfoList"));
            if (roadInfoListObject == null) {
                roadInfoList = this.roadInfoMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(RoadInfo::getType, (Object)1)).orderByAsc(RoadInfo::getRoadSort));
                for (RoadInfo roadInfo : roadInfoList) {
                    for (int i = 0; i < 24; ++i) {
                        if (roadInfo.getType() != 1) continue;
                        RoadInfo.HourItem hourItem = new RoadInfo.HourItem();
                        hourItem.setHour(i);
                        roadInfo.getHourItemList().add(hourItem);
                    }
                }
            } else {
                roadInfoList = JSONUtil.toList((String)roadInfoListObject.toString(), RoadInfo.class);
            }
            for (RoadInfo roadInfo : roadInfoList) {
                roadInfo.setRealTimeAveSpeed(0);
            }
            Iterator<Object> iterator = statisticsList.iterator();
            while (iterator.hasNext() && !(carTrackData = (CarTrackData)iterator.next()).getCarTempIdList().isEmpty()) {
                int orientation = (Integer)carTrackData.getOrientationList().get(0);
                int realOrientation = switchValue ? orientation : -orientation;
                for (int i = 0; i < carTrackData.getCarTempIdList().size(); ++i) {
                    int extendedTag = (Integer)carTrackData.getExtendedTagList().get(i);
                    if (extendedTag == 1) continue;
                    int distance = (Integer)carTrackData.getDistanceList().get(i);
                    String tempId = (String)carTrackData.getCarTempIdList().get(i);
                    double speed = Math.abs(((Float)carTrackData.getSpeedList().get(i)).floatValue() * 3.6f);
                    float width = ((Float)carTrackData.getAmpList().get(i)).floatValue();
                    for (RoadInfo roadInfo : roadInfoList) {
                        if (distance < roadInfo.getStartDistance() || distance >= roadInfo.getEndDistance() || roadInfo.getOrientation() != realOrientation) continue;
                        roadInfo.getRealTimeTempIdSet().add(tempId);
                        roadInfo.setDaySumSpeed(roadInfo.getDaySumSpeed() + Math.abs(speed));
                        roadInfo.setDaySumCarCount(roadInfo.getDaySumCarCount() + 1);
                        roadInfo.setDayAveSpeed((int)(roadInfo.getDaySumSpeed() / (double)roadInfo.getDaySumCarCount()));
                        roadInfo.setRealTimeSumSpeed(roadInfo.getRealTimeSumSpeed() + Math.abs(speed));
                        roadInfo.setRealTimeSumCarCount(roadInfo.getRealTimeSumCarCount() + 1);
                        roadInfo.setRealTimeAveSpeed((int)(roadInfo.getRealTimeSumSpeed() / (double)roadInfo.getRealTimeSumCarCount()));
                        int hour = carTrackData.getTime().getHour();
                        roadInfo.getDayCarTempIdSet().add((String)carTrackData.getCarTempIdList().get(i));
                        for (RoadInfo.HourItem hourItem : roadInfo.getHourItemList()) {
                            if (hourItem.getHour() != hour) continue;
                            if (hourItem.getTempIdSet().contains(tempId)) {
                                Optional<RoadInfo.CarItem> optional = hourItem.getCarItemList().stream().filter(tempItem -> tempItem.getTempId().equals(tempId)).findFirst();
                                if (!optional.isPresent()) continue;
                                RoadInfo.CarItem found = optional.get();
                                if (width >= carWidthParam) {
                                    found.setBigWidthCount(found.getBigWidthCount() + 1);
                                    continue;
                                }
                                if (!(width < carWidthParam)) continue;
                                found.setSmallWidthCount(found.getSmallWidthCount() + 1);
                                continue;
                            }
                            RoadInfo.CarItem carItem2 = new RoadInfo.CarItem();
                            carItem2.setTempId(tempId);
                            if (width >= carWidthParam) {
                                carItem2.setBigWidthCount(1);
                            } else if (width < carWidthParam) {
                                carItem2.setSmallWidthCount(1);
                            }
                            hourItem.getTempIdSet().add(tempId);
                            hourItem.setCarCount(hourItem.getTempIdSet().size());
                            hourItem.getCarItemList().add(carItem2);
                        }
                        roadInfo.setDaySumCarCountUnique(roadInfo.getDayCarTempIdSet().size());
                    }
                    CarKRoad tempCarKRoad = GeoUtil.getCarKRoadByDistance((int)((Integer)carTrackData.getDistanceList().get(i)), (List)carKRoadList);
                    for (CarKRoad carKRoad : carKRoadList) {
                        if (!carKRoad.getKName().equals(tempCarKRoad.getKName()) || carKRoad.getOrientation() != tempCarKRoad.getOrientation()) continue;
                        carKRoad.setCarCount(carKRoad.getCarCount() + 1);
                        carKRoad.setSumSpeed((int)((double)carKRoad.getSumSpeed() + speed));
                    }
                }
                for (RoadInfo roadInfo : roadInfoList) {
                    if (roadInfo.getOrientation() != realOrientation) continue;
                    roadInfo.setRealTimeSumSpeed(0.0);
                    roadInfo.setRealTimeSumCarCount(0);
                    roadInfo.setRealTimeCarCount(roadInfo.getRealTimeTempIdSet().size());
                    roadInfo.getRealTimeTempIdSet().clear();
                    LocalDateTime dateTime = carTrackData.getTime();
                    int hour = dateTime.getHour();
                    for (RoadInfo.HourItem hourItem : roadInfo.getHourItemList()) {
                        if (hourItem.getHour() != hour) continue;
                        hourItem.setSmallCarCount(0);
                        hourItem.setBigCarCount(0);
                        hourItem.getCarItemList().forEach(carItem -> {
                            if (carItem.getSmallWidthCount() >= carItem.getBigWidthCount()) {
                                hourItem.setSmallCarCount(hourItem.getSmallCarCount() + 1);
                            } else {
                                hourItem.setBigCarCount(hourItem.getBigCarCount() + 1);
                            }
                        });
                    }
                }
                this.redisTemplate.opsForValue().set((Object)(dayKey + "-roadInfoList"), JSON.toJSON((Object)roadInfoList));
                this.redisTemplate.opsForValue().set((Object)(dayKey + "-mapData"), JSON.toJSON((Object)carKRoadList));
            }
        }
    }

    @Scheduled(fixedRate=3000L)
    public void statisticsHGData() {
        if (this.appType != 3) {
            return;
        }
        Object carTrackDTOObject = this.redisTemplate.opsForValue().get((Object)"carTrackDTO");
        if (carTrackDTOObject != null) {
            int upDownValue;
            CarTrackDTO carTrackDTO = (CarTrackDTO)JSON.parseObject((String)carTrackDTOObject.toString(), CarTrackDTO.class);
            if (carTrackDTO.getList().isEmpty()) {
                return;
            }
            List orientationConfigList = this.systemConfigMapper.selectList((Wrapper)Wrappers.lambdaQuery().eq(SystemConfig::getConfigType, (Object)"orientation"));
            int orientationValue = Integer.parseInt(((SystemConfig)orientationConfigList.get(0)).getConfigValue());
            boolean switchValue = orientationValue == (upDownValue = Integer.parseInt(((SystemConfig)orientationConfigList.get(0)).getConfigValueExt()));
            DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
            String dayKey = carTrackDTO.getStartTime().format(dateFormatter);
            List statisticsList = carTrackDTO.getList().stream().filter(data -> data.getTime().isEqual(carTrackDTO.getEndTime())).collect(Collectors.toList());
            List roadInfoList = this.roadInfoMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().in(RoadInfo::getType, Arrays.asList(2, 3))).orderByAsc(RoadInfo::getRoadSort));
            for (RoadInfo roadInfo : roadInfoList) {
                CarTrackData carTrackData;
                Iterator iterator = statisticsList.iterator();
                while (iterator.hasNext() && !(carTrackData = (CarTrackData)iterator.next()).getCarTempIdList().isEmpty()) {
                    int orientation = (Integer)carTrackData.getOrientationList().get(0);
                    int realOrientation = switchValue ? orientation : -orientation;
                    for (int i = 0; i < carTrackData.getCarTempIdList().size(); ++i) {
                        int extendedTag = (Integer)carTrackData.getExtendedTagList().get(i);
                        if (extendedTag == 1) continue;
                        int distance = (Integer)carTrackData.getDistanceList().get(i);
                        double speed = Math.abs(((Float)carTrackData.getSpeedList().get(i)).floatValue() * 3.6f);
                        if (distance < roadInfo.getStartDistance() || distance >= roadInfo.getEndDistance() || roadInfo.getOrientation() != realOrientation) continue;
                        roadInfo.getDayCarTempIdSet().add((String)carTrackData.getCarTempIdList().get(i));
                        this.redisTemplate.opsForSet().add((Object)(roadInfo.getId() + "tempId" + dayKey), new Object[]{carTrackData.getCarTempIdList().get(i)});
                        this.redisTemplate.opsForValue().increment((Object)(roadInfo.getId() + "speed" + dayKey), speed);
                        this.redisTemplate.opsForValue().increment((Object)(roadInfo.getId() + "count" + dayKey), 1L);
                    }
                }
            }
        }
    }

    @RequestMapping(value={"/hgRoadData"})
    public ResponseResult getHGRoadData(@RequestParam String datetimeStr) {
        int upDownValue;
        int[][] ranges = new int[][]{{0, 30}, {30, 50}, {50, 70}, {70, 120}, {120, 150}, {150, 250}};
        List carWidthConfigList = this.systemConfigMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SystemConfig::getConfigType, (Object)"carWidth")).orderByAsc(SystemConfig::getConfigSort));
        float carWidthParam = Float.parseFloat(((SystemConfig)carWidthConfigList.get(0)).getConfigValue());
        ArrayList<HGRoadStatisticsDataVO> hgRoadStatisticsDataVOList = new ArrayList<HGRoadStatisticsDataVO>();
        String dayKey = datetimeStr.split(" ")[0];
        List carKRoadList = this.carKRoadMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(CarKRoad::getType, (Object)1)).orderByAsc(CarKRoad::getId));
        List orientationConfigList = this.systemConfigMapper.selectList((Wrapper)Wrappers.lambdaQuery().eq(SystemConfig::getConfigType, (Object)"orientation"));
        int orientationValue = Integer.parseInt(((SystemConfig)orientationConfigList.get(0)).getConfigValue());
        boolean switchValue = orientationValue == (upDownValue = Integer.parseInt(((SystemConfig)orientationConfigList.get(0)).getConfigValueExt()));
        List roadInfoList = this.roadInfoMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().in(RoadInfo::getType, Arrays.asList(2, 3))).orderByAsc(RoadInfo::getRoadSort));
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        LocalDateTime parseDateTime = LocalDateTime.parse(datetimeStr, formatter);
        LocalDateTime startTime = parseDateTime.withSecond(0).withNano(0);
        LocalDateTime endTime = parseDateTime.withSecond(59).withNano(0);
        List dataLogList = this.dataLogTempMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().ge(DataLogTemp::getLogTime, (Object)startTime)).le(DataLogTemp::getLogTime, (Object)endTime));
        for (DataLogTemp dataLog : dataLogList) {
            CarTrackDTO carTrackDTO = (CarTrackDTO)JSONUtil.toBean((String)dataLog.getValueStr(), CarTrackDTO.class);
            List<CarTrackData> statisticsList = carTrackDTO.getList().stream().filter(data -> data.getTime().isEqual(carTrackDTO.getEndTime())).collect(Collectors.toList());
            int index = dataLogList.indexOf(dataLog);
            for (RoadInfo roadInfo : roadInfoList) {
                if (index == 0) {
                    for (int[] range : ranges) {
                        RoadInfo.SpeedItem speedItem2 = new RoadInfo.SpeedItem();
                        speedItem2.setMin(range[0]);
                        speedItem2.setMax(range[1]);
                        roadInfo.getSpeedItemList().add(speedItem2);
                    }
                }
                statisticsList.forEach(carItem -> {
                    int orientation = (Integer)carItem.getOrientationList().get(0);
                    int realOrientation = switchValue ? orientation : -orientation;
                    for (int i = 0; i < carItem.getCarTempIdList().size(); ++i) {
                        int extendedTag = (Integer)carItem.getExtendedTagList().get(i);
                        if (extendedTag == -1) continue;
                        float width = ((Float)carItem.getWidthList().get(i)).floatValue();
                        int distance = (Integer)carItem.getDistanceList().get(i);
                        double speed = Math.abs(((Float)carItem.getSpeedList().get(i)).floatValue() * 3.6f);
                        String tempId = (String)carItem.getCarTempIdList().get(i);
                        if (distance < roadInfo.getStartDistance() || distance >= roadInfo.getEndDistance() || roadInfo.getOrientation() != realOrientation) continue;
                        if (index == 0) {
                            if (width > carWidthParam) {
                                roadInfo.getRealTimeBigCarTempIdSet().add(tempId);
                            } else {
                                roadInfo.getRealTimeSmallCarTempIdSet().add(tempId);
                            }
                            roadInfo.getSpeedItemList().forEach(speedItem -> {
                                if (speed >= (double)speedItem.getMin() && speed < (double)speedItem.getMax()) {
                                    if (width > carWidthParam) {
                                        speedItem.setBigCarCount(speedItem.getBigCarCount() + 1);
                                    } else {
                                        speedItem.setSmallCarCount(speedItem.getSmallCarCount() + 1);
                                    }
                                }
                            });
                        }
                        roadInfo.setDaySumSpeed(roadInfo.getDaySumSpeed() + Math.abs(speed));
                        roadInfo.setDaySumCarCount(roadInfo.getDaySumCarCount() + 1);
                        roadInfo.setDayAveSpeed((int)(roadInfo.getDaySumSpeed() / (double)roadInfo.getDaySumCarCount()));
                        if (roadInfo.getMinuteTempIdSet().contains(tempId)) {
                            Optional<RoadInfo.CarItem> optional = roadInfo.getCarItemList().stream().filter(tempItem -> tempItem.getTempId().equals(tempId)).findFirst();
                            if (!optional.isPresent()) continue;
                            RoadInfo.CarItem found = optional.get();
                            if (width >= carWidthParam) {
                                found.setBigWidthCount(found.getBigWidthCount() + 1);
                                continue;
                            }
                            if (!(width < carWidthParam)) continue;
                            found.setSmallWidthCount(found.getSmallWidthCount() + 1);
                            continue;
                        }
                        RoadInfo.CarItem roadCarItem = new RoadInfo.CarItem();
                        roadCarItem.setTempId(tempId);
                        if (width >= carWidthParam) {
                            roadCarItem.setBigWidthCount(1);
                        } else if (width < carWidthParam) {
                            roadCarItem.setSmallWidthCount(1);
                        }
                        roadInfo.getMinuteTempIdSet().add(tempId);
                        roadInfo.getCarItemList().add(roadCarItem);
                    }
                });
            }
        }
        for (RoadInfo roadInfo : roadInfoList) {
            HGRoadStatisticsDataVO vo = new HGRoadStatisticsDataVO();
            vo.setId(roadInfo.getId());
            carKRoadList.forEach(carItem -> {
                if (roadInfo.getRoadName().split("\u81f3")[0].equals(carItem.getKName())) {
                    vo.setStartKName(carItem.getKName());
                    vo.setStartLongitude(carItem.getLng());
                    vo.setStartLatitude(carItem.getLat());
                }
                if (roadInfo.getRoadName().split("\u81f3")[1].equals(carItem.getKName())) {
                    vo.setEndKName(carItem.getKName());
                    vo.setEndLongitude(carItem.getLng());
                    vo.setEndLatitude(carItem.getLat());
                }
            });
            vo.setDatetimeStr(datetimeStr);
            vo.setOrientation(roadInfo.getOrientation().intValue());
            vo.setType(roadInfo.getType().intValue());
            vo.setMinuteAveSpeed((float)roadInfo.getDayAveSpeed());
            vo.setRealTimeBigCarCount(roadInfo.getRealTimeBigCarTempIdSet().size());
            vo.setRealTimeSmallCarCount(roadInfo.getRealTimeSmallCarTempIdSet().size());
            roadInfo.getCarItemList().forEach(carItem -> {
                if (carItem.getSmallWidthCount() >= carItem.getBigWidthCount()) {
                    vo.setMinuteSmallCarCount(vo.getMinuteSmallCarCount() + 1);
                } else {
                    vo.setMinuteBigCarCount(vo.getMinuteBigCarCount() + 1);
                }
            });
            roadInfo.getSpeedItemList().forEach(speedItem -> {
                HGRoadStatisticsDataVO.SpeedItem item = new HGRoadStatisticsDataVO.SpeedItem();
                item.setBigCarCount(speedItem.getBigCarCount());
                item.setSmallCarCount(speedItem.getSmallCarCount());
                item.setMin(speedItem.getMin());
                item.setMax(speedItem.getMax());
                vo.getSpeedItemList().add(item);
            });
            long size = this.redisTemplate.opsForSet().size((Object)(roadInfo.getId() + "tempId" + dayKey));
            vo.setSumDayCarCount((int)size);
            Object speedObj = this.redisTemplate.opsForValue().get((Object)(roadInfo.getId() + "speed" + dayKey));
            Object countObj = this.redisTemplate.opsForValue().get((Object)(roadInfo.getId() + "count" + dayKey));
            if (speedObj != null && countObj != null) {
                String speedStr = String.valueOf(speedObj);
                String countStr = String.valueOf(countObj);
                int aveSpeed = (int)(Double.valueOf(speedStr) / Double.valueOf(countStr));
                vo.setSumDayAveSpeed(aveSpeed);
            }
            hgRoadStatisticsDataVOList.add(vo);
        }
        return ResponseResult.success(hgRoadStatisticsDataVOList);
    }

    @RequestMapping(value={"/roadData"})
    public ResponseResult getRoadStatisticsData(@RequestParam(required=false) String date) {
        if (date == null) {
            return ResponseResult.error((String)"\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Object roadInfoListObject = this.redisTemplate.opsForValue().get((Object)(date + "-roadInfoList"));
        if (roadInfoListObject == null) {
            return ResponseResult.success(new ArrayList());
        }
        List orientationConfigList = this.systemConfigMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SystemConfig::getConfigType, (Object)"orientation")).orderByAsc(SystemConfig::getConfigSort));
        ArrayList<RoadStatisticsDataVO> roadStatisticsDataVOList = new ArrayList<RoadStatisticsDataVO>();
        List roadInfoList = JSON.parseArray((String)roadInfoListObject.toString(), RoadInfo.class, (JSONReader.Feature[])new JSONReader.Feature[0]);
        for (RoadInfo roadInfo : roadInfoList) {
            if (roadInfo.getType() != 1) continue;
            RoadStatisticsDataVO roadStatisticsDataVO = new RoadStatisticsDataVO();
            roadStatisticsDataVO.setRoadName(roadInfo.getRoadName());
            roadStatisticsDataVO.setOrientation(roadInfo.getOrientation().intValue());
            roadStatisticsDataVO.setRealTimeCarCount(roadInfo.getRealTimeCarCount());
            roadStatisticsDataVO.setRealTimeAveSpeed((float)roadInfo.getRealTimeAveSpeed());
            roadStatisticsDataVO.setSumCarCount(roadInfo.getDaySumCarCountUnique());
            roadStatisticsDataVO.setSumAveSpeed(roadInfo.getDayAveSpeed());
            roadStatisticsDataVO.setId(roadInfo.getId());
            for (RoadInfo.HourItem hourItem : roadInfo.getHourItemList()) {
                RoadStatisticsDataVO.HourItem item = new RoadStatisticsDataVO.HourItem();
                item.setHour(hourItem.getHour());
                item.setBigCarCount(hourItem.getBigCarCount());
                item.setSmallCarCount(hourItem.getSmallCarCount());
                item.setCarCount(hourItem.getCarCount());
                roadStatisticsDataVO.getHourItemList().add(item);
            }
            roadStatisticsDataVOList.add(roadStatisticsDataVO);
        }
        return ResponseResult.success(roadStatisticsDataVOList);
    }

    @RequestMapping(value={"/mapData"})
    public ResponseResult getMapData() {
        List orientationConfigList = this.systemConfigMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SystemConfig::getConfigType, (Object)"orientation")).orderByAsc(SystemConfig::getConfigSort));
        SystemConfig hotCongestionParam = (SystemConfig)this.systemConfigMapper.selectOne((Wrapper)Wrappers.lambdaQuery().eq(SystemConfig::getConfigType, (Object)"hotCongestionParam"));
        SystemConfig hotSlowParam = (SystemConfig)this.systemConfigMapper.selectOne((Wrapper)Wrappers.lambdaQuery().eq(SystemConfig::getConfigType, (Object)"hotSlowParam"));
        int hotCongestionCarCount = Integer.parseInt(hotCongestionParam.getConfigValue());
        int hotCongestionAveSpeed = Integer.parseInt(hotCongestionParam.getConfigValueExt());
        int hotSlowCarCount = Integer.parseInt(hotSlowParam.getConfigValue());
        int hotSlowSpeed = Integer.parseInt(hotSlowParam.getConfigValueExt());
        String date = LocalDate.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        Object mapDataObject = this.redisTemplate.opsForValue().get((Object)(date + "-mapData"));
        ArrayList<MapDataVO> mapDataVOList = new ArrayList<MapDataVO>();
        List carKRoadList = mapDataObject != null ? JSON.parseArray((String)mapDataObject.toString(), CarKRoad.class, (JSONReader.Feature[])new JSONReader.Feature[0]) : this.carKRoadMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(CarKRoad::getType, (Object)1)).orderByAsc(CarKRoad::getId));
        for (CarKRoad carKRoad : carKRoadList) {
            MapDataVO mapDataVO = new MapDataVO();
            mapDataVO.setId(carKRoad.getId());
            mapDataVO.setName(carKRoad.getKName());
            mapDataVO.setLng(carKRoad.getLng());
            mapDataVO.setLat(carKRoad.getLat());
            mapDataVO.setRealTimeCarCount(carKRoad.getCarCount());
            mapDataVO.setDistance(carKRoad.getDistance());
            mapDataVO.setDistanceEnd(carKRoad.getDistanceEnd());
            if (carKRoad.getCarCount() != 0) {
                carKRoad.setAveSpeed(carKRoad.getSumSpeed() / carKRoad.getCarCount());
                if (carKRoad.getCarCount() > hotSlowCarCount) {
                    if (carKRoad.getAveSpeed() <= hotCongestionAveSpeed) {
                        carKRoad.setCongestionLevel(1);
                    } else if (carKRoad.getAveSpeed() > hotCongestionAveSpeed && carKRoad.getAveSpeed() <= hotSlowSpeed) {
                        carKRoad.setCongestionLevel(2);
                    } else {
                        carKRoad.setCongestionLevel(3);
                    }
                } else {
                    carKRoad.setCongestionLevel(3);
                }
            }
            if (carKRoad.getCarCount() == 0) {
                mapDataVO.setRealTimeAveSpeed(0);
            } else {
                mapDataVO.setRealTimeAveSpeed(carKRoad.getSumSpeed() / carKRoad.getCarCount());
            }
            mapDataVO.setCongestionLevel(carKRoad.getCongestionLevel());
            mapDataVO.setOrientation(this.switchOrientation(orientationConfigList, carKRoad.getOrientation()));
            mapDataVOList.add(mapDataVO);
        }
        return ResponseResult.success(mapDataVOList);
    }

    @RequestMapping(value={"/carCountChart"})
    public ResponseResult getCarCountChart() {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        Object roadInfoListObject = this.redisTemplate.opsForValue().get((Object)(LocalDateTime.now().format(formatter) + "-roadInfoList"));
        List roadInfoList = roadInfoListObject != null ? JSON.parseArray((String)roadInfoListObject.toString(), RoadInfo.class, (JSONReader.Feature[])new JSONReader.Feature[0]) : this.roadInfoMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(RoadInfo::getType, (Object)1)).orderByAsc(RoadInfo::getRoadSort));
        ArrayList<ChartItemVO> chartItemVOList = new ArrayList<ChartItemVO>();
        for (RoadInfo roadInfo : roadInfoList) {
            ChartItemVO chartItemVO = new ChartItemVO();
            chartItemVO.setValueX(roadInfo.getRoadName());
            chartItemVO.setValueY(roadInfo.getRealTimeCarCount());
            chartItemVO.setOrientation(roadInfo.getOrientation().intValue());
            chartItemVOList.add(chartItemVO);
        }
        return ResponseResult.success(chartItemVOList);
    }

    @RequestMapping(value={"/warningHotChart"})
    public ResponseResult getWarningHotChart(String date) {
        if (date == null) {
            return ResponseResult.error((String)"\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List orientationConfigList = this.systemConfigMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SystemConfig::getConfigType, (Object)"orientation")).orderByAsc(SystemConfig::getConfigSort));
        int orientationValue = Integer.parseInt(((SystemConfig)orientationConfigList.get(0)).getConfigValue());
        int upDownValue = Integer.parseInt(((SystemConfig)orientationConfigList.get(0)).getConfigValueExt());
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        LocalDate tempDate = LocalDate.parse(date, formatter);
        List<ExpWarning> expWarningList = new ArrayList();
        if (tempDate.equals(LocalDate.now())) {
            expWarningList = this.expWarningMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(ExpWarning::getFix, (Object)0)).eq(ExpWarning::getUpgrade, (Object)0)).ge(ExpWarning::getDataTime, (Object)tempDate.atStartOfDay())).le(ExpWarning::getDataTime, (Object)tempDate.atTime(LocalTime.MAX))).orderByDesc(ExpWarning::getDataTime));
        } else {
            List expWarningTempList = this.expWarningTempMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(ExpWarningTemp::getFix, (Object)0)).eq(ExpWarningTemp::getUpgrade, (Object)0)).ge(ExpWarningTemp::getDataTime, (Object)tempDate.atStartOfDay())).le(ExpWarningTemp::getDataTime, (Object)tempDate.atTime(LocalTime.MAX))).orderByDesc(ExpWarningTemp::getDataTime));
            for (Object expWarningTemp : expWarningTempList) {
                ExpWarning expWarning = new ExpWarning();
                BeanUtils.copyProperties((Object)expWarningTemp, (Object)expWarning);
                expWarningList.add(expWarning);
            }
        }
        List allCarKRoadList = this.carKRoadMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(CarKRoad::getType, (Object)1)).orderByAsc(CarKRoad::getId));
        ArrayList<String> kTagList = new ArrayList<String>();
        for (CarKRoad carKRoad : allCarKRoadList) {
            if (kTagList.contains(carKRoad.getKTag())) continue;
            kTagList.add(carKRoad.getKTag());
        }
        WarningHotVO warningHotVO = new WarningHotVO();
        warningHotVO.getKNameList().addAll(kTagList);
        for (int i = 0; i < 24; i += 2) {
            warningHotVO.getHourList().add(i);
        }
        for (String kName : warningHotVO.getKNameList()) {
            for (Integer hour : warningHotVO.getHourList()) {
                WarningHotVO.WarningHotItem warningHotItem = new WarningHotVO.WarningHotItem();
                warningHotItem.setXIndex(Integer.valueOf(warningHotVO.getKNameList().indexOf(kName)));
                warningHotItem.setYIndex(Integer.valueOf(warningHotVO.getHourList().indexOf(hour)));
                WarningHotVO.WarningHotItem downWarningHotItem = new WarningHotVO.WarningHotItem();
                downWarningHotItem.setXIndex(Integer.valueOf(warningHotVO.getKNameList().indexOf(kName)));
                downWarningHotItem.setYIndex(Integer.valueOf(warningHotVO.getHourList().indexOf(hour)));
                for (ExpWarning expWarning : expWarningList) {
                    int warningHour = expWarning.getDataTime().getHour();
                    if (!expWarning.getWarningArea().contains(kName) || warningHour != hour && warningHour + 1 != hour) continue;
                    if (orientationValue == upDownValue) {
                        if (expWarning.getOrientation() == 1) {
                            warningHotItem.setWarningCount(Integer.valueOf(warningHotItem.getWarningCount() + 1));
                            continue;
                        }
                        downWarningHotItem.setWarningCount(Integer.valueOf(downWarningHotItem.getWarningCount() + 1));
                        continue;
                    }
                    if (expWarning.getOrientation() == -1) {
                        warningHotItem.setWarningCount(Integer.valueOf(warningHotItem.getWarningCount() + 1));
                        continue;
                    }
                    downWarningHotItem.setWarningCount(Integer.valueOf(downWarningHotItem.getWarningCount() + 1));
                }
                if (warningHotItem.getWarningCount() > 0) {
                    warningHotVO.getUpWarningHotItemList().add(warningHotItem);
                }
                if (downWarningHotItem.getWarningCount() <= 0) continue;
                warningHotVO.getDownWarningHotItemList().add(downWarningHotItem);
            }
        }
        return ResponseResult.success((Object)warningHotVO);
    }

    @RequestMapping(value={"/warningTypeData"})
    public ResponseResult getWarningTypeData(String date) {
        if (date == null) {
            return ResponseResult.error((String)"\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        LocalDate tempDate = LocalDate.parse(date, formatter);
        List expTypeList = this.expTypeMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(ExpType::getEnable, (Object)1)).orderByAsc(ExpType::getTypeSort));
        LocalDate today = LocalDate.now();
        List<ExpWarning> expWarningList = new ArrayList();
        if (tempDate.equals(today)) {
            expWarningList = this.expWarningMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(ExpWarning::getFix, (Object)0)).eq(ExpWarning::getUpgrade, (Object)0)).ge(ExpWarning::getDataTime, (Object)tempDate.atStartOfDay())).le(ExpWarning::getDataTime, (Object)tempDate.atTime(LocalTime.MAX))).orderByDesc(ExpWarning::getDataTime));
        } else {
            List expWarningTempList = this.expWarningTempMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(ExpWarningTemp::getFix, (Object)0)).eq(ExpWarningTemp::getUpgrade, (Object)0)).ge(ExpWarningTemp::getDataTime, (Object)tempDate.atStartOfDay())).le(ExpWarningTemp::getDataTime, (Object)tempDate.atTime(LocalTime.MAX))).orderByDesc(ExpWarningTemp::getDataTime));
            Iterator iterator = expWarningTempList.iterator();
            while (iterator.hasNext()) {
                ExpWarningTemp expWarningTemp = (ExpWarningTemp)iterator.next();
                ExpWarning expWarning = new ExpWarning();
                BeanUtils.copyProperties((Object)expWarningTemp, (Object)expWarning);
                expWarningList.add(expWarning);
            }
        }
        for (ExpType expType : expTypeList) {
            for (ExpWarning expWarning : expWarningList) {
                if (expType.getTypeValue().intValue() != expWarning.getType().intValue()) continue;
                expType.setValue(expType.getValue() + 1);
            }
            double ratio = (double)expType.getValue() * 100.0 / (double)expWarningList.size();
            if (expType.getValue() == 0) {
                expType.setPercent(0);
                continue;
            }
            if (ratio < 1.0) {
                expType.setPercent(1);
                continue;
            }
            expType.setPercent((int)ratio);
        }
        ArrayList<ExpTypeVO> expTypeVOList = new ArrayList<ExpTypeVO>();
        for (ExpType expType : expTypeList) {
            ExpTypeVO expTypeVO = new ExpTypeVO();
            expTypeVO.setName(expType.getName());
            expTypeVO.setColor(expType.getColor());
            expTypeVO.setValue(expType.getValue());
            expTypeVO.setPercent(expTypeVO.getPercent());
            expTypeVOList.add(expTypeVO);
        }
        return ResponseResult.success(expTypeVOList);
    }

    @RequestMapping(value={"/warningList"})
    public ResponseResult getWarningList(@RequestParam(required=false) String date) {
        if (date == null) {
            return ResponseResult.error((String)"\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        LocalDate tempDate = LocalDate.parse(date, formatter);
        List<ExpWarning> expWarningList = new ArrayList();
        if (tempDate.equals(LocalDate.now())) {
            expWarningList = this.expWarningMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(ExpWarning::getFix, (Object)0)).eq(ExpWarning::getUpgrade, (Object)0)).eq(ExpWarning::getState, (Object)0)).ge(ExpWarning::getDataTime, (Object)tempDate.atStartOfDay())).le(ExpWarning::getDataTime, (Object)tempDate.atTime(LocalTime.MAX))).orderByDesc(ExpWarning::getDataTime));
        } else {
            List expWarningTempList = this.expWarningTempMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(ExpWarningTemp::getFix, (Object)0)).eq(ExpWarningTemp::getUpgrade, (Object)0)).eq(ExpWarningTemp::getState, (Object)0)).ge(ExpWarningTemp::getDataTime, (Object)tempDate.atStartOfDay())).le(ExpWarningTemp::getDataTime, (Object)tempDate.atTime(LocalTime.MAX))).orderByDesc(ExpWarningTemp::getDataTime));
            for (ExpWarningTemp expWarningTemp : expWarningTempList) {
                ExpWarning expWarning = new ExpWarning();
                BeanUtils.copyProperties((Object)expWarningTemp, (Object)expWarning);
                expWarningList.add(expWarning);
            }
        }
        ArrayList<ExpWarningVO> expWarningVOList = new ArrayList<ExpWarningVO>();
        for (ExpWarning expWarning : expWarningList) {
            ExpWarningVO expWarningVO = new ExpWarningVO();
            BeanUtil.copyProperties((Object)expWarning, (Object)expWarningVO, (String[])new String[0]);
            expWarningVOList.add(expWarningVO);
        }
        return ResponseResult.success(expWarningVOList);
    }

    @RequestMapping(value={"/allWarningList"})
    public ResponseResult getAllWarningList(@RequestParam String startDateTime, @RequestParam String endDateTime) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        LocalDate start = LocalDateTime.parse(startDateTime, formatter).toLocalDate();
        List<ExpWarning> expWarningList = new ArrayList();
        if (start.equals(LocalDate.now())) {
            expWarningList = this.expWarningMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().ge(ExpWarning::getDataTime, (Object)LocalDateTime.parse(startDateTime, formatter))).le(ExpWarning::getDataTime, (Object)LocalDateTime.parse(endDateTime, formatter))).orderByDesc(ExpWarning::getDataTime));
        } else {
            List expWarningTempList = this.expWarningTempMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().ge(ExpWarningTemp::getDataTime, (Object)LocalDateTime.parse(startDateTime, formatter))).le(ExpWarningTemp::getDataTime, (Object)LocalDateTime.parse(endDateTime, formatter))).orderByDesc(ExpWarningTemp::getDataTime));
            for (ExpWarningTemp expWarningTemp : expWarningTempList) {
                ExpWarning expWarning = new ExpWarning();
                BeanUtils.copyProperties((Object)expWarningTemp, (Object)expWarning);
                expWarningList.add(expWarning);
            }
        }
        ArrayList<ExpWarningVO> expWarningVOList = new ArrayList<ExpWarningVO>();
        for (ExpWarning expWarning : expWarningList) {
            ExpWarningVO expWarningVO = new ExpWarningVO();
            BeanUtil.copyProperties((Object)expWarning, (Object)expWarningVO, (String[])new String[0]);
            expWarningVOList.add(expWarningVO);
        }
        return ResponseResult.success(expWarningVOList);
    }

    @RequestMapping(value={"/filterRoadList"})
    public ResponseResult getFilterRoadList() {
        List carKRoadList = this.carKRoadMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().ne(CarKRoad::getType, (Object)1)).orderByAsc(CarKRoad::getId));
        List orientationConfigList = this.systemConfigMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SystemConfig::getConfigType, (Object)"orientation")).orderByAsc(SystemConfig::getConfigSort));
        carKRoadList.forEach(carKRoad -> carKRoad.setOrientation(this.switchOrientation(orientationConfigList, carKRoad.getOrientation())));
        return ResponseResult.success((Object)carKRoadList);
    }

    public int switchOrientation(List<SystemConfig> orientationConfigList, int orientation) {
        int upDownValue;
        int orientationValue = Integer.parseInt(orientationConfigList.get(0).getConfigValue());
        if (orientationValue == (upDownValue = Integer.parseInt(orientationConfigList.get(0).getConfigValueExt()))) {
            return orientation;
        }
        return -orientation;
    }

    @GetMapping(value={"createHGRoadInfo"})
    public ResponseResult createHGRoadInfo() {
        int START_METER = 342300;
        int END_METER = 419400;
        int TOTAL_MAPPED = 77100;
        int INTERVAL = 500;
        int fullIntervals = 154;
        for (int i = 0; i < fullIntervals; ++i) {
            int startMapped = i * 500;
            int endMapped = (i + 1) * 500;
            int startMeter = 342300 + startMapped;
            int endMeter = 342300 + endMapped;
            String startK = StatisticsController.formatKLabel((int)startMeter);
            String endK = StatisticsController.formatKLabel((int)endMeter);
            RoadInfo roadInfo = new RoadInfo();
            roadInfo.setId(Integer.valueOf(207 + i));
            roadInfo.setRoadName(startK + "\u81f3" + endK);
            roadInfo.setRoadSort(Integer.valueOf(i + 1));
            roadInfo.setStartDistance(Integer.valueOf(startMapped));
            roadInfo.setEndDistance(Integer.valueOf(endMapped));
            roadInfo.setOrientation(Integer.valueOf(-1));
            roadInfo.setType(Integer.valueOf(2));
            this.roadInfoMapper.insert((Object)roadInfo);
        }
        return ResponseResult.success();
    }

    public static void main(String[] args) {
        int START_METER = 342300;
        int END_METER = 419400;
        int TOTAL_MAPPED = 77100;
        int INTERVAL = 500;
        int fullIntervals = 154;
        for (int i = 0; i < fullIntervals; ++i) {
            int startMapped = i * 500;
            int endMapped = (i + 1) * 500;
            int startMeter = 342300 + startMapped;
            int endMeter = 342300 + endMapped;
            String startK = StatisticsController.formatKLabel((int)startMeter);
            String endK = StatisticsController.formatKLabel((int)endMeter);
            System.out.println(startK + "\u81f3" + endK + " " + (i + 1) + " " + startMapped + " " + endMapped);
        }
    }

    private static String formatKLabel(int totalMeters) {
        int km = totalMeters / 1000;
        int m = totalMeters % 1000;
        if (m == 0) {
            return "K" + km;
        }
        return String.format("K%d+%03d", km, m);
    }
}

