/*
 * Decompiled with CFR 0.152.
 */
package com.shengmu.controller;

import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONReader;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.shengmu.camera.Gb28181SipService;
import com.shengmu.controller.UtilController;
import com.shengmu.mapper.CameraMapper;
import com.shengmu.mapper.CarKRoadMapper;
import com.shengmu.mapper.DataLogMapper;
import com.shengmu.mapper.RoadInfoMapper;
import com.shengmu.mapper.SystemConfigMapper;
import com.shengmu.modal.dto.CarTrackDTO;
import com.shengmu.modal.entity.Camera;
import com.shengmu.modal.entity.CarKRoad;
import com.shengmu.modal.entity.DataLog;
import com.shengmu.modal.entity.ExpWarning;
import com.shengmu.modal.entity.RoadInfo;
import com.shengmu.modal.entity.SystemConfig;
import com.shengmu.modal.vo.FakeHomeData;
import com.shengmu.service.CarTrackV2Service;
import com.shengmu.utils.ResponseResult;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import javax.annotation.Resource;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.springframework.core.io.ClassPathResource;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@CrossOrigin
@RequestMapping(value={"util"})
public class UtilController {
    @Resource
    private CarKRoadMapper carKRoadMapper;
    @Resource
    private SystemConfigMapper systemConfigMapper;
    @Resource
    private CameraMapper cameraMapper;
    @Resource
    private RedisTemplate redisTemplate;
    @Resource
    private Gb28181SipService gb28181SipService;
    @Resource
    private DataLogMapper dataLogMapper;
    @Resource
    private CarTrackV2Service carTrackV2Service;
    @Resource
    private RoadInfoMapper roadInfoMapper;

    @GetMapping(value={"healthy"})
    public ResponseResult healthy() {
        return ResponseResult.success();
    }

    @GetMapping(value={"/allTrack"})
    public ResponseResult allTrack() {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        List orientationConfigList = this.systemConfigMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SystemConfig::getConfigType, (Object)"orientation")).orderByAsc(SystemConfig::getConfigSort));
        List carKRoadList = this.carKRoadMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(CarKRoad::getType, (Object)1)).orderByAsc(CarKRoad::getId));
        SystemConfig systemConfig = (SystemConfig)this.systemConfigMapper.selectOne((Wrapper)Wrappers.lambdaQuery().eq(SystemConfig::getConfigType, (Object)"singleStopSpeed"));
        int stopSpeed = Integer.parseInt(systemConfig.getConfigValue());
        Path dir = Paths.get("/Users/yao/Desktop/15", new String[0]);
        ArrayList fileNameList = new ArrayList();
        DateTimeFormatter inputFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH-mm-ss");
        try (Stream<Path> stream = Files.list(dir);){
            stream.forEach(path -> {
                if (path.getFileName().toString().contains("png")) {
                    fileNameList.add(path.getFileName().toString());
                }
            });
        }
        catch (IOException e) {
            System.err.println("\u65e0\u6cd5\u8bbf\u95ee\u76ee\u5f55: " + dir.toString() + "\uff0c\u56e0\u4e3a\uff1a" + e.getMessage());
        }
        return ResponseResult.success();
    }

    @PostMapping(value={"/getFakeHomeData"})
    public ResponseResult getFakeHomeData() throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        ClassPathResource resource = new ClassPathResource("data.json");
        FakeHomeData homeData = (FakeHomeData)mapper.readValue(resource.getInputStream(), FakeHomeData.class);
        return ResponseResult.success((Object)homeData);
    }

    @GetMapping(value={"test1"})
    public ResponseResult test1() {
        String filePath = "/Users/yao/Work/\u58f0\u76ee\u667a\u5bfb/paltform-java/doc/camera.txt";
        Pattern pattern = Pattern.compile("DeviceID:\\s*(\\S+)\\s*\\|\\s*Name:\\s*(.+)$");
        this.cameraMapper.delete((Wrapper)Wrappers.lambdaQuery());
        try {
            List<String> lines = Files.readAllLines(Paths.get(filePath, new String[0]));
            for (String line : lines) {
                Matcher matcher = pattern.matcher(line.trim());
                if (!matcher.matches()) continue;
                String deviceId = matcher.group(1);
                String name = matcher.group(2);
                System.out.println("DeviceID: " + deviceId + " | Name: " + name);
                Camera camera = new Camera();
                camera.setAddress("http://33.65.60.98:99/rtp/" + deviceId + ".live.mp4");
                camera.setId(Integer.valueOf(lines.indexOf(line) + 1));
                camera.setDeviceId(deviceId);
                if (name.contains("\u91d1\u5411")) {
                    camera.setOrientation(Integer.valueOf(-1));
                }
                if (name.contains("\u5b81\u5411")) {
                    camera.setOrientation(Integer.valueOf(1));
                }
                camera.setName(name.replace("G1512", "").replace("\u91d1\u5411", "").replace("\u5b81\u5411", "").split("_")[0].split("-")[0]);
                String kMarker = camera.getName();
                String rest = kMarker.substring(1).trim();
                String[] parts = rest.split("\\+");
                int kilometers = Integer.parseInt(parts[0].trim());
                int meters = Integer.parseInt(parts[1].trim());
                camera.setDistance(Integer.valueOf(kilometers * 1000 + meters));
                camera.setName(name.replace("G1512", "").split("_")[0].split("-")[0]);
                this.cameraMapper.insert((Object)camera);
            }
        }
        catch (IOException e) {
            System.err.println("\u8bfb\u53d6\u6587\u4ef6\u5931\u8d25: " + e.getMessage());
        }
        return ResponseResult.success();
    }

    @GetMapping(value={"test2"})
    public ResponseResult test2() {
        int[] orientationArray = new int[]{-1, 1};
        DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        for (int i = 1; i < 30; ++i) {
            List roadInfoList;
            Object roadInfoListObject;
            LocalDateTime yesterday = LocalDateTime.now().minusDays(i);
            Object newRoadInfoListObject = this.redisTemplate.opsForValue().get((Object)(yesterday.format(dateFormatter) + "-roadInfoList"));
            if (newRoadInfoListObject != null) {
                List roadInfoList2 = JSON.parseArray((String)newRoadInfoListObject.toString(), RoadInfo.class, (JSONReader.Feature[])new JSONReader.Feature[0]);
                roadInfoList2.forEach(roadInfo -> {
                    roadInfo.getDayCarTempIdSet().clear();
                    for (RoadInfo.HourItem hourItem : roadInfo.getHourItemList()) {
                        hourItem.getTempIdSet().clear();
                        hourItem.getCarItemList().clear();
                    }
                });
                this.redisTemplate.opsForValue().set((Object)(yesterday.format(dateFormatter) + "-roadInfoList"), (Object)JSONUtil.toJsonStr((Object)roadInfoList2));
            }
            for (int orientation : orientationArray) {
                roadInfoListObject = this.redisTemplate.opsForValue().get((Object)(orientation + "-roadInfoList-" + yesterday.format(dateFormatter)));
                if (roadInfoListObject == null) continue;
                roadInfoList = JSONUtil.toList((String)roadInfoListObject.toString(), RoadInfo.class);
                for (RoadInfo roadInfo2 : roadInfoList) {
                    for (RoadInfo.HourItem hourItem : roadInfo2.getHourItemList()) {
                        hourItem.getTempIdSet().clear();
                        hourItem.getCarItemList().clear();
                    }
                    roadInfo2.getDayCarTempIdSet().clear();
                }
                this.redisTemplate.opsForValue().set((Object)(orientation + "-roadInfoList-" + yesterday.format(dateFormatter)), (Object)JSONUtil.toJsonStr((Object)roadInfoList));
            }
            for (int orientation : orientationArray) {
                roadInfoListObject = this.redisTemplate.opsForValue().get((Object)(orientation + "-customRoadInfoList-" + yesterday.format(dateFormatter)));
                if (roadInfoListObject == null) continue;
                roadInfoList = JSONUtil.toList((String)roadInfoListObject.toString(), RoadInfo.class);
                for (RoadInfo roadInfo2 : roadInfoList) {
                    for (RoadInfo.HourItem hourItem : roadInfo2.getHourItemList()) {
                        hourItem.getTempIdSet().clear();
                        hourItem.getCarItemList().clear();
                    }
                    roadInfo2.getDayCarTempIdSet().clear();
                }
                this.redisTemplate.opsForValue().set((Object)(orientation + "-customRoadInfoList-" + yesterday.format(dateFormatter)), (Object)JSONUtil.toJsonStr((Object)roadInfoList));
            }
        }
        return ResponseResult.success();
    }

    @GetMapping(value={"test3"})
    public ResponseResult test3(@RequestParam Long id) {
        ExpWarning expWarning = new ExpWarning();
        expWarning.setDistance(Integer.valueOf(5000));
        expWarning.setId(id);
        this.gb28181SipService.recording(expWarning);
        return ResponseResult.success();
    }

    @GetMapping(value={"test4"})
    public ResponseResult test4() {
        LocalDateTime start = LocalDateTime.now().withDayOfMonth(23).withMonth(10).withYear(2025).withHour(13).withMinute(59).withSecond(0).withNano(0);
        LocalDateTime end = LocalDateTime.now().withDayOfMonth(23).withMonth(10).withYear(2025).withHour(17).withMinute(5).withSecond(0).withNano(0);
        List dataLogList = this.dataLogMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().ge(DataLog::getLogTime, (Object)start)).le(DataLog::getLogTime, (Object)end));
        if (dataLogList != null && !dataLogList.isEmpty()) {
            dataLogList.forEach(log -> {
                CarTrackDTO csvBeanNew = (CarTrackDTO)JSONUtil.toBean((String)log.getValueStr(), CarTrackDTO.class);
                this.carTrackV2Service.processData(csvBeanNew);
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            });
        }
        return ResponseResult.success();
    }

    @GetMapping(value={"test5"})
    public ResponseResult test5(@RequestParam Integer start, @RequestParam Integer end) {
        List cameraList = this.cameraMapper.selectList((Wrapper)Wrappers.lambdaQuery().orderByAsc(Camera::getDeviceId));
        for (int i = 0; i < cameraList.size(); ++i) {
            if (i < start || i > end) continue;
            this.gb28181SipService.startStream(((Camera)cameraList.get(i)).getDeviceId(), ((Camera)cameraList.get(i)).getDeviceId(), true);
        }
        return ResponseResult.success();
    }

    @GetMapping(value={"test6"})
    public ResponseResult test6() {
        String filePath = "/Users/yao/Desktop/road.xls";
        this.carKRoadMapper.delete((Wrapper)Wrappers.lambdaQuery());
        ArrayList<CarKRoad> list = new ArrayList<CarKRoad>();
        try (FileInputStream fis = new FileInputStream(filePath);
             HSSFWorkbook workbook = new HSSFWorkbook((InputStream)fis);){
            Sheet sheet = workbook.getSheetAt(0);
            for (Row row : sheet) {
                if (row == null) continue;
                CarKRoad carKRoad = new CarKRoad();
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < 9; ++i) {
                    Cell cell = row.getCell(i, Row.MissingCellPolicy.CREATE_NULL_AS_BLANK);
                    String value = this.getCellValueAsString(cell);
                    if (i == 1 && value.length() != 4) {
                        value = value + "00";
                    }
                    if (i == 6 && value.contains("+")) {
                        value = value.split("\\+")[0];
                    }
                    sb.append(value).append("   ");
                    if (i == 0) {
                        carKRoad.setId(Integer.valueOf(value));
                    }
                    if (i == 1) {
                        carKRoad.setKName(value);
                    }
                    if (i == 2) {
                        carKRoad.setLng(Double.valueOf(value));
                    }
                    if (i == 3) {
                        carKRoad.setLat(Double.valueOf(value));
                    }
                    if (i == 4) {
                        carKRoad.setDistance(Integer.valueOf(value));
                    }
                    if (i == 5) {
                        carKRoad.setDistanceEnd(Integer.valueOf(value));
                    }
                    if (i == 6) {
                        carKRoad.setKTag(value);
                    }
                    if (i == 7) {
                        carKRoad.setOrientation(Integer.valueOf(value).intValue());
                    }
                    if (i != 8) continue;
                    carKRoad.setType(Integer.valueOf(value).intValue());
                }
                list.add(carKRoad);
                this.carKRoadMapper.insert((Object)carKRoad);
                System.out.println(sb.toString().trim());
            }
        }
        catch (IOException e) {
            System.err.println("\u8bfb\u53d6 Excel \u6587\u4ef6\u5931\u8d25: " + e.getMessage());
            e.printStackTrace();
        }
        for (int i = 0; i < list.size(); ++i) {
            CarKRoad carKRoad = (CarKRoad)list.get(i);
            carKRoad.setOrientation(-1);
            carKRoad.setId(Integer.valueOf(((CarKRoad)list.get(i)).getId() + list.size()));
            this.carKRoadMapper.insert((Object)carKRoad);
        }
        return ResponseResult.success();
    }

    private String getCellValueAsString(Cell cell) {
        if (cell == null) {
            return "";
        }
        switch (1.$SwitchMap$org$apache$poi$ss$usermodel$CellType[cell.getCellType().ordinal()]) {
            case 1: {
                return cell.getStringCellValue();
            }
            case 2: {
                if (DateUtil.isCellDateFormatted((Cell)cell)) {
                    return cell.getDateCellValue().toString();
                }
                double num = cell.getNumericCellValue();
                if (num == (double)((long)num)) {
                    return String.valueOf((long)num);
                }
                return String.valueOf(num);
            }
            case 3: {
                return String.valueOf(cell.getBooleanCellValue());
            }
            case 4: {
                return cell.getCellFormula();
            }
        }
        return "";
    }

    @GetMapping(value={"/car"})
    public ResponseResult serveSimpleVideo() {
        long maxMemoryMB = Runtime.getRuntime().maxMemory() / 0x100000L;
        System.out.println(">>> JVM Max Heap: " + maxMemoryMB + " MB");
        return ResponseResult.success((Object)(">>> JVM Max Heap: " + maxMemoryMB + " MB"));
    }

    @GetMapping(value={"/test7"})
    public ResponseResult test7() {
        List roadInfoList = this.roadInfoMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(RoadInfo::getOrientation, (Object)-1)).orderByAsc(RoadInfo::getId));
        roadInfoList.forEach(roadInfo -> {
            System.out.println(roadInfo.getRoadName());
            roadInfo.setRoadName(roadInfo.getRoadName().split("\u81f3")[1] + "\u81f3" + roadInfo.getRoadName().split("\u81f3")[0]);
            this.roadInfoMapper.updateById(roadInfo);
        });
        return ResponseResult.success();
    }
}

