/*
 * Decompiled with CFR 0.152.
 */
package com.shengmu.controller;

import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.shengmu.mapper.DotDataMapper;
import com.shengmu.mapper.ExpWarningMapper;
import com.shengmu.modal.dto.WarningImageDTO;
import com.shengmu.modal.entity.DotData;
import com.shengmu.modal.entity.ExpWarning;
import com.shengmu.modal.vo.WRJWarningData;
import com.shengmu.utils.ResponseResult;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"wrj"})
public class WRJController {
    @Autowired
    private RedisTemplate redisTemplate;
    @Resource
    private ExpWarningMapper expWarningMapper;
    private final OkHttpClient client = new OkHttpClient();
    @Resource
    private DotDataMapper dotDataMapper;
    private static final String IMAGE_URL = "http://192.168.31.125:5000/stream_test";

    @PostMapping(value={"/sendWRJWarning"})
    public ResponseResult sendWRJWarning(@org.springframework.web.bind.annotation.RequestBody WRJWarningData wrjWarningData) {
        ExpWarning expWarning = new ExpWarning();
        expWarning.setType(wrjWarningData.getType());
        expWarning.setMessage(wrjWarningData.getMessage());
        expWarning.setTempId(wrjWarningData.getImgName());
        expWarning.setDataTime(LocalDateTime.now());
        expWarning.setCreateTime(LocalDateTime.now());
        expWarning.setEndTime(LocalDateTime.now());
        this.expWarningMapper.insert((Object)expWarning);
        return ResponseResult.success();
    }

    @PostMapping(value={"/sendTemperatureWarning"})
    public ResponseResult sendTemperatureWarning(@org.springframework.web.bind.annotation.RequestBody WRJWarningData wrjWarningData) {
        List expWarningList = this.expWarningMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(ExpWarning::getType, (Object)2)).ge(ExpWarning::getCreateTime, (Object)LocalDateTime.now().minusSeconds(15L)));
        if (expWarningList.isEmpty()) {
            ExpWarning expWarning = new ExpWarning();
            expWarning.setType(Integer.valueOf(2));
            expWarning.setMessage("\u9ad8\u6e29\u9884\u8b66" + wrjWarningData.getTemperature() + "\u5ea6");
            expWarning.setTempId("");
            expWarning.setDataTime(LocalDateTime.now());
            expWarning.setCreateTime(LocalDateTime.now());
            expWarning.setEndTime(LocalDateTime.now());
            this.expWarningMapper.insert((Object)expWarning);
        }
        return ResponseResult.success();
    }

    @GetMapping(value={"/getWRJWarning"})
    public ResponseResult getWRJWarning() {
        List expWarningList = this.expWarningMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().ge(ExpWarning::getCreateTime, (Object)LocalDateTime.now().minusMinutes(15L))).orderByDesc(ExpWarning::getCreateTime));
        return ResponseResult.success((Object)expWarningList);
    }

    @GetMapping(value={"/sureWRJWarning"})
    public ResponseResult sureWRJWarning(@RequestParam Long warningId) {
        ExpWarning expWarning = (ExpWarning)this.expWarningMapper.selectById((Serializable)warningId);
        expWarning.setState(Integer.valueOf(1));
        this.expWarningMapper.updateById((Object)expWarning);
        return ResponseResult.success();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @GetMapping(value={"/getWRJToken"})
    public ResponseResult getWRJToken() {
        Object tokenObject;
        boolean refreshToken;
        HashMap<String, Object> map;
        block25: {
            map = new HashMap<String, Object>();
            refreshToken = false;
            tokenObject = this.redisTemplate.opsForValue().get((Object)"wrjToken");
            if (tokenObject == null) {
                refreshToken = true;
            } else {
                String token = (String)tokenObject;
                JSONObject jsonObject = new JSONObject();
                RequestBody body = RequestBody.create((String)jsonObject.toString(), (MediaType)MediaType.get((String)"application/json; charset=utf-8"));
                Request request = new Request.Builder().url("http://60.8.12.6:20080/api/admin/device/onlineall").post(body).header("Authorization", "Bearer " + token).build();
                try (Response response = this.client.newCall(request).execute();){
                    if (!response.isSuccessful()) {
                        ResponseResult responseData = ResponseResult.error((String)"\u7f51\u7edc\u8bf7\u6c42\u5931\u8d25");
                        return responseData;
                    }
                    JSONObject responseData = JSONUtil.parseObj((String)response.body().string());
                    if (responseData.getInt((Object)"code") == 200) {
                        refreshToken = false;
                        break block25;
                    }
                    if (responseData.getInt((Object)"code") == 401) {
                        refreshToken = true;
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        if (!refreshToken) {
            map.put("token", tokenObject);
            return ResponseResult.success(map);
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.set("password", (Object)"flf@123456");
        jsonObject.set("username", (Object)"13989624541");
        RequestBody body = RequestBody.create((String)jsonObject.toString(), (MediaType)MediaType.get((String)"application/json; charset=utf-8"));
        Request request = new Request.Builder().url("http://60.8.12.6:20080/api/admin/login").post(body).build();
        try (Response response = this.client.newCall(request).execute();){
            if (response.isSuccessful()) {
                JSONObject responseData = JSONUtil.parseObj((String)response.body().string());
                if (responseData.getInt((Object)"code") == 200) {
                    JSONObject jsonData = responseData.getJSONObject((Object)"data");
                    map.put("token", jsonData.getStr((Object)"token"));
                    this.redisTemplate.opsForValue().set((Object)"wrjToken", (Object)jsonData.getStr((Object)"token"));
                    return ResponseResult.success(map);
                }
                ResponseResult responseResult = ResponseResult.error((String)("\u63a5\u53e3\u8bf7\u6c42\u5931\u8d25" + responseData.getStr((Object)"msg")));
                return responseResult;
            }
            ResponseResult responseResult = ResponseResult.error((String)"\u7f51\u7edc\u8bf7\u6c42\u5931\u8d25");
            return responseResult;
        }
        catch (IOException e) {
            e.printStackTrace();
            return ResponseResult.error((String)"\u7f51\u7edc\u8bf7\u6c42\u5931\u8d25");
        }
    }

    @GetMapping(value={"/dotTest"})
    public ResponseResult dotTest() {
        String excelFilePath = "/Users/yao/Desktop/\u505c\u8f66\u6570\u636e/0711.xlsx";
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        try (FileInputStream fis = new FileInputStream(excelFilePath);
             XSSFWorkbook workbook = new XSSFWorkbook((InputStream)fis);){
            Sheet sheet = workbook.getSheetAt(0);
            int totalRows = sheet.getLastRowNum();
            int rowIndex = 0;
            for (Row row : sheet) {
                ++rowIndex;
                String dateStr = row.getCell(7).getStringCellValue();
                String message = row.getCell(8).getStringCellValue();
                message = message.replace("\uff3d", "]").replace("\uff3b", "[");
                LocalDate date = LocalDate.parse(dateStr, formatter);
                LocalDateTime startOfDay = date.atStartOfDay();
                LocalDateTime endOfDay = date.atTime(23, 59, 59, 999999999);
                List expWarningList = this.expWarningMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(ExpWarning::getMessage, (Object)message)).ge(ExpWarning::getDataTime, (Object)startOfDay)).le(ExpWarning::getDataTime, (Object)endOfDay));
                ExpWarning expWarning = (ExpWarning)expWarningList.get(0);
                List dotDataList = this.dotDataMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().like(DotData::getValueStr, (Object)("%" + expWarning.getTempId() + "%"))).eq(DotData::getResult, (Object)1)).ge(DotData::getCreateTime, (Object)expWarning.getDataTime().minusSeconds(30L))).le(DotData::getCreateTime, (Object)expWarning.getDataTime().plusSeconds(30L)));
                if (dotDataList.size() == 1) {
                    DotData dotData = (DotData)dotDataList.get(0);
                    dotData.setCreateTime(LocalDateTime.now());
                    dotData.setId(null);
                    this.dotDataMapper.insert((Object)dotData);
                }
                System.out.println(rowIndex + "/" + (totalRows + 1) + " \u65e5\u671f " + dateStr + " \u9884\u8b66\u6570\u91cf " + expWarningList.size() + " \u6a21\u578b\u6570\u636e\u91cf " + dotDataList.size() + " " + message);
            }
        }
        catch (IOException e) {
            System.err.println("\u8bfb\u53d6\u6587\u4ef6\u65f6\u51fa\u9519: " + e.getMessage());
        }
        return ResponseResult.success();
    }

    @GetMapping(value={"/dotTest2"})
    public ResponseResult dotTest2() {
        String excelFilePath = "/Users/yao/Desktop/\u505c\u8f66\u6570\u636e/0704.xlsx";
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        try (FileInputStream fis = new FileInputStream(excelFilePath);
             XSSFWorkbook workbook = new XSSFWorkbook((InputStream)fis);){
            Sheet sheet = workbook.getSheetAt(0);
            int totalRows = sheet.getLastRowNum();
            int rowIndex = 0;
            for (Row row : sheet) {
                String message = row.getCell(12).getStringCellValue();
                System.out.println(++rowIndex + "/" + (totalRows + 1) + " " + message);
            }
        }
        catch (IOException e) {
            System.err.println("\u8bfb\u53d6\u6587\u4ef6\u65f6\u51fa\u9519: " + e.getMessage());
        }
        return ResponseResult.success();
    }

    @PostMapping(value={"/checkImage"})
    public ResponseResult checkNeedImage(@org.springframework.web.bind.annotation.RequestBody WarningImageDTO warningImageDTO) {
        HashMap<String, Number> map = new HashMap<String, Number>();
        if (StrUtil.isEmpty((CharSequence)warningImageDTO.getImgName())) {
            List expWarningList = this.expWarningMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(ExpWarning::getType, (Object)2)).eq(ExpWarning::getTempId, (Object)"")).ge(ExpWarning::getCreateTime, (Object)LocalDateTime.now().minusSeconds(15L)));
            if (!expWarningList.isEmpty()) {
                map.put("upload", 1);
                map.put("id", ((ExpWarning)expWarningList.get(0)).getId());
            } else {
                map.put("upload", 0);
            }
        } else {
            ExpWarning expWarning = (ExpWarning)this.expWarningMapper.selectById((Serializable)warningImageDTO.getId());
            expWarning.setTempId(warningImageDTO.getImgName());
            this.expWarningMapper.updateById((Object)expWarning);
            map.put("upload", 0);
        }
        return ResponseResult.success(map);
    }
}

