/*
 * Decompiled with CFR 0.152.
 */
package com.shengmu.service;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson2.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.shengmu.camera.Gb28181SipService;
import com.shengmu.config.ScheduleTask;
import com.shengmu.config.TrackManager;
import com.shengmu.mapper.CarKRoadMapper;
import com.shengmu.mapper.CarTrackMapper;
import com.shengmu.mapper.DotDataMapper;
import com.shengmu.mapper.ExpWarningMapper;
import com.shengmu.mapper.RoadInfoMapper;
import com.shengmu.mapper.SystemConfigMapper;
import com.shengmu.modal.dto.CarTrackDTO;
import com.shengmu.modal.dto.CarTrackData;
import com.shengmu.modal.entity.CarKRoad;
import com.shengmu.modal.entity.CarTrack;
import com.shengmu.modal.entity.ExpWarning;
import com.shengmu.modal.entity.RoadInfo;
import com.shengmu.modal.entity.SystemConfig;
import com.shengmu.service.CarTrackV2Service;
import com.shengmu.utils.GeoUtil;
import com.shengmu.utils.HttpClientProvider;
import com.shengmu.utils.ResponseResult;
import com.shengmu.utils.UUIDUtil;
import com.shengmu.websocket.WarningSocketHandler;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import okhttp3.Callback;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class CarTrackV2ServiceImpl
implements CarTrackV2Service {
    private static final Logger log = LoggerFactory.getLogger(CarTrackV2ServiceImpl.class);
    @Autowired
    private RedisTemplate redisTemplate;
    @Resource
    private CarKRoadMapper carKRoadMapper;
    @Resource
    private RoadInfoMapper roadInfoMapper;
    @Resource
    private SystemConfigMapper systemConfigMapper;
    @Resource
    private ExpWarningMapper expWarningMapper;
    @Resource
    private WarningSocketHandler warningSocketHandler;
    @Resource
    private CarTrackMapper carTrackMapper;
    @Resource
    private TrackManager trackManager;
    @Resource
    private DotDataMapper dotDataMapper;
    @Value(value="${custom-config.model-url}")
    private String modelUrl;
    @Resource
    private Gb28181SipService gb28181SipService;

    public ResponseResult processData(CarTrackDTO carTrackDTO) {
        int upDownValue;
        this.redisTemplate.opsForValue().set((Object)"carTrackDTO", JSON.toJSON((Object)carTrackDTO));
        long start = System.currentTimeMillis();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        List orientationConfigList = this.systemConfigMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SystemConfig::getConfigType, (Object)"orientation")).orderByAsc(SystemConfig::getConfigSort));
        List carTrackDataList = carTrackDTO.getList();
        List carKRoadList = this.carKRoadMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(CarKRoad::getType, (Object)1)).orderByAsc(CarKRoad::getId));
        ArrayList<String> kTagList = new ArrayList<String>();
        for (CarKRoad carKRoad : carKRoadList) {
            if (kTagList.contains(carKRoad.getKTag())) continue;
            kTagList.add(carKRoad.getKTag());
        }
        int orientationValue = Integer.parseInt(((SystemConfig)orientationConfigList.get(0)).getConfigValue());
        boolean switchValue = orientationValue == (upDownValue = Integer.parseInt(((SystemConfig)orientationConfigList.get(0)).getConfigValueExt()));
        List carWidthConfigList = this.systemConfigMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SystemConfig::getConfigType, (Object)"carWidth")).orderByAsc(SystemConfig::getConfigSort));
        float carWidth = Float.parseFloat(((SystemConfig)carWidthConfigList.get(0)).getConfigValue());
        List statisticsList = carTrackDataList.stream().filter(data -> data.getTime().isEqual(carTrackDTO.getEndTime())).collect(Collectors.toList());
        ArrayList<CarTrack> currentCarTrackList = new ArrayList<CarTrack>();
        for (CarTrackData carTrackData : carTrackDataList) {
            if (!carTrackData.getTime().isAfter(carTrackDTO.getEndTime().minusSeconds(3L))) continue;
            ArrayList sendUpCarTrackList = new ArrayList();
            ArrayList<JSONObject> sendDownCarTrackList = new ArrayList<JSONObject>();
            for (int i = 0; i < carTrackData.getCarTempIdList().size(); ++i) {
                CarTrack carTrack = this.getCarTrack(carTrackData, i, orientationConfigList, formatter, carKRoadList);
                currentCarTrackList.add(carTrack);
                JSONObject jsonObject = new JSONObject();
                int realOrientation = switchValue ? carTrack.getOrientation() : -carTrack.getOrientation().intValue();
                jsonObject.set("orientation", (Object)realOrientation);
                jsonObject.set("latitude", (Object)carTrack.getLatitude());
                jsonObject.set("longitude", (Object)carTrack.getLongitude());
                jsonObject.set("distance", (Object)carTrack.getDistance());
                jsonObject.set("tempId", (Object)carTrack.getTempId());
                jsonObject.set("realKName", (Object)carTrack.getRealKName());
                jsonObject.set("dateTime", (Object)carTrack.getCurrentTimeStr());
                if (carTrack.getAmp().floatValue() >= carWidth) {
                    jsonObject.set("vehicleType", (Object)2);
                } else {
                    jsonObject.set("vehicleType", (Object)1);
                }
                if (realOrientation == 1) {
                    sendUpCarTrackList.add(jsonObject);
                    continue;
                }
                sendDownCarTrackList.add(jsonObject);
            }
            if (!sendUpCarTrackList.isEmpty()) {
                ScheduleTask.upCarTackQueue.add(JSON.toJSONString((Object)sendUpCarTrackList));
            }
            if (sendDownCarTrackList.isEmpty()) continue;
            ScheduleTask.downCarTackQueue.add(JSON.toJSONString(sendDownCarTrackList));
        }
        this.trackManager.addTrack(currentCarTrackList, carTrackDTO.getEndTime());
        List filterAreaList = this.systemConfigMapper.selectList((Wrapper)Wrappers.lambdaQuery().eq(SystemConfig::getConfigType, (Object)"filterArea"));
        ArrayList<CarTrack> allCarTrackList = new ArrayList<CarTrack>();
        for (CarTrack recentTrack : this.trackManager.getRecentTracks()) {
            if (!recentTrack.getCurrentTime().isAfter(carTrackDTO.getEndTime().minusSeconds(35L))) continue;
            allCarTrackList.add(recentTrack);
        }
        long time2 = System.currentTimeMillis();
        for (CarTrackData carTrackData : statisticsList) {
            int orientation = (Integer)carTrackData.getOrientationList().get(0);
            this.singleCarStop(carTrackDTO.getEndTime(), orientation, filterAreaList, allCarTrackList, currentCarTrackList);
            this.singleCarSlow(carTrackDTO.getEndTime(), orientation, filterAreaList, allCarTrackList, currentCarTrackList);
            this.multipleCarSlowCongestion(carTrackDTO.getEndTime(), orientation, filterAreaList, currentCarTrackList);
        }
        long end = System.currentTimeMillis();
        String nowStr = LocalDateTime.now().format(formatter);
        System.out.println("\u5904\u7406\u6570\u636e " + currentCarTrackList.size() + " \u603b\u8017\u65f6 = " + (end - start) + " \u9884\u8b66\u8017\u65f6 = " + (end - time2) + " \u6570\u636e\u7ed3\u675f\u65f6\u95f4 = " + carTrackDTO.getEndTime().format(formatter) + " \u5f53\u524d\u65f6\u95f4 = " + nowStr);
        return ResponseResult.success();
    }

    public CarTrack getCarTrack(CarTrackData carTrackData, int i, List<SystemConfig> orientationConfigList, DateTimeFormatter formatter, List<CarKRoad> carKRoadList) {
        CarTrack carTrack = new CarTrack();
        carTrack.setId(UUIDUtil.uuid());
        float speed = (float)Math.abs((double)((Float)carTrackData.getSpeedList().get(i)).floatValue() * 3.6);
        BigDecimal bd = new BigDecimal(Float.toString(speed));
        carTrack.setSpeed(Float.valueOf(bd.setScale(2, RoundingMode.HALF_UP).floatValue()));
        carTrack.setDistance(Integer.valueOf(Math.abs((Integer)carTrackData.getDistanceList().get(i))));
        carTrack.setOrientation((Integer)carTrackData.getOrientationList().get(i));
        for (SystemConfig systemConfig : orientationConfigList) {
            if (Integer.parseInt(systemConfig.getConfigValue()) != (Integer)carTrackData.getOrientationList().get(i)) continue;
            carTrack.setOrientationName(systemConfig.getConfigName());
        }
        carTrack.setCurrentTime(carTrackData.getTime());
        carTrack.setCurrentTimeStr(carTrackData.getTime().format(formatter));
        carTrack.setCreateTime(LocalDateTime.now());
        CarKRoad carKRoad = GeoUtil.getCarKRoadByDistance((int)carTrack.getDistance(), carKRoadList);
        carTrack.setKName(carKRoad.getKName());
        carTrack.setRealKName(carKRoad.getRealKName());
        carTrack.setLatitude(carKRoad.getLat());
        carTrack.setLongitude(carKRoad.getLng());
        carTrack.setTempId((String)carTrackData.getCarTempIdList().get(i));
        carTrack.setWidth((Float)carTrackData.getWidthList().get(i));
        carTrack.setAmp((Float)carTrackData.getAmpList().get(i));
        carTrack.setExtendedTag((Integer)carTrackData.getExtendedTagList().get(i));
        carTrack.setStartx((Integer)carTrackData.getStartx().get(i));
        carTrack.setStarty((Integer)carTrackData.getStarty().get(i));
        carTrack.setEndx((Integer)carTrackData.getEndx().get(i));
        carTrack.setEndy((Integer)carTrackData.getEndy().get(i));
        carTrack.setConf((Double)carTrackData.getConf().get(i));
        carTrack.setExtendx((Double)carTrackData.getExtendx().get(i));
        carTrack.setDiffDistance((Integer)carTrackData.getDiffDistance().get(i));
        return carTrack;
    }

    public void singleCarStop(LocalDateTime endTime, int orientation, List<SystemConfig> filterAreaList, List<CarTrack> allCarTrackList, List<CarTrack> currentCarTrackList) {
        SystemConfig systemConfig = (SystemConfig)this.systemConfigMapper.selectOne((Wrapper)Wrappers.lambdaQuery().eq(SystemConfig::getConfigType, (Object)"singleStopSpeed"));
        int stopSpeed = Integer.parseInt(systemConfig.getConfigValue());
        Set tempIdSet = allCarTrackList.stream().filter(carTrack -> carTrack.getOrientation() == orientation).filter(carTrack -> {
            LocalDateTime currentTime = carTrack.getCurrentTime();
            return currentTime.equals(endTime.minusSeconds(15L)) || currentTime.equals(endTime.minusSeconds(16L)) || currentTime.equals(endTime.minusSeconds(17L));
        }).map(CarTrack::getTempId).collect(Collectors.toSet());
        for (String tempId : tempIdSet) {
            long stopExpWarningCount;
            long fourthCount;
            long thirdCount;
            long secondCount;
            long firstCount;
            List clonedList = (List)ObjectUtil.cloneByStream(allCarTrackList.stream().filter(carTrack -> carTrack.getTempId().equals(tempId)).filter(carTrack -> carTrack.getOrientation() == orientation).sorted(Comparator.comparing(CarTrack::getCurrentTime)).collect(Collectors.toList()));
            LocalDateTime dataEndTime = ((CarTrack)clonedList.get(clonedList.size() - 1)).getCurrentTime();
            for (int i = 0; i < clonedList.size(); ++i) {
                ((CarTrack)clonedList.get(clonedList.size() - 1 - i)).setCurrentTime(dataEndTime.minusSeconds(i));
            }
            ArrayList<CarTrack> firstThreeSecondsCarTrackList = new ArrayList<CarTrack>();
            ArrayList<CarTrack> secondThreeSecondsCarTrackList = new ArrayList<CarTrack>();
            ArrayList<CarTrack> thirdThreeSecondsCarTrackList = new ArrayList<CarTrack>();
            ArrayList<CarTrack> fourthThreeSecondsCarTrackList = new ArrayList<CarTrack>();
            ArrayList<CarTrack> lastSixSecondsCarTrackList = new ArrayList<CarTrack>();
            ArrayList<CarTrack> twentyFourCarTrackList = new ArrayList<CarTrack>();
            for (int i = 0; i < clonedList.size(); ++i) {
                CarTrack tempCarTrack = (CarTrack)clonedList.get(i);
                if (tempCarTrack.getOrientation() != orientation || !tempId.equals(tempCarTrack.getTempId())) continue;
                if (tempCarTrack.getCurrentTime().equals(endTime.minusSeconds(23L)) || tempCarTrack.getCurrentTime().equals(endTime.minusSeconds(22L)) || tempCarTrack.getCurrentTime().equals(endTime.minusSeconds(21L)) || tempCarTrack.getCurrentTime().equals(endTime.minusSeconds(20L)) || tempCarTrack.getCurrentTime().equals(endTime.minusSeconds(19L)) || tempCarTrack.getCurrentTime().equals(endTime.minusSeconds(18L))) {
                    twentyFourCarTrackList.add(tempCarTrack);
                }
                if (tempCarTrack.getCurrentTime().equals(endTime.minusSeconds(15L)) || tempCarTrack.getCurrentTime().equals(endTime.minusSeconds(16L)) || tempCarTrack.getCurrentTime().equals(endTime.minusSeconds(17L))) {
                    firstThreeSecondsCarTrackList.add(tempCarTrack);
                    twentyFourCarTrackList.add(tempCarTrack);
                }
                if (tempCarTrack.getCurrentTime().equals(endTime.minusSeconds(14L)) || tempCarTrack.getCurrentTime().equals(endTime.minusSeconds(13L)) || tempCarTrack.getCurrentTime().equals(endTime.minusSeconds(12L))) {
                    secondThreeSecondsCarTrackList.add(tempCarTrack);
                    twentyFourCarTrackList.add(tempCarTrack);
                }
                if (tempCarTrack.getCurrentTime().equals(endTime.minusSeconds(11L)) || tempCarTrack.getCurrentTime().equals(endTime.minusSeconds(10L)) || tempCarTrack.getCurrentTime().equals(endTime.minusSeconds(9L))) {
                    thirdThreeSecondsCarTrackList.add(tempCarTrack);
                    twentyFourCarTrackList.add(tempCarTrack);
                }
                if (tempCarTrack.getCurrentTime().equals(endTime.minusSeconds(8L)) || tempCarTrack.getCurrentTime().equals(endTime.minusSeconds(7L)) || tempCarTrack.getCurrentTime().equals(endTime.minusSeconds(6L))) {
                    fourthThreeSecondsCarTrackList.add(tempCarTrack);
                    twentyFourCarTrackList.add(tempCarTrack);
                }
                if (!tempCarTrack.getCurrentTime().equals(endTime.minusSeconds(5L)) && !tempCarTrack.getCurrentTime().equals(endTime.minusSeconds(4L)) && !tempCarTrack.getCurrentTime().equals(endTime.minusSeconds(3L)) && !tempCarTrack.getCurrentTime().equals(endTime.minusSeconds(2L)) && !tempCarTrack.getCurrentTime().equals(endTime.minusSeconds(1L)) && !tempCarTrack.getCurrentTime().equals(endTime)) continue;
                lastSixSecondsCarTrackList.add(tempCarTrack);
                twentyFourCarTrackList.add(tempCarTrack);
            }
            twentyFourCarTrackList.sort(Comparator.comparing(CarTrack::getCurrentTime));
            int trackCount = 0;
            for (int i = 0; i < lastSixSecondsCarTrackList.size(); ++i) {
                CarTrack tempCarTrack = (CarTrack)lastSixSecondsCarTrackList.get(i);
                if (tempCarTrack.getExtendedTag() != 0) continue;
                ++trackCount;
            }
            if (trackCount > 0 || firstThreeSecondsCarTrackList.isEmpty() || secondThreeSecondsCarTrackList.isEmpty() || thirdThreeSecondsCarTrackList.isEmpty() || fourthThreeSecondsCarTrackList.isEmpty()) continue;
            CarTrack happenedCarTrack = (CarTrack)fourthThreeSecondsCarTrackList.get(fourthThreeSecondsCarTrackList.size() - 1);
            double avgSpeedFirst = firstThreeSecondsCarTrackList.stream().mapToDouble(CarTrack::getSpeed).average().orElse(0.0);
            float endSpeed = happenedCarTrack.getSpeed().floatValue();
            if (endSpeed >= (float)stopSpeed || (avgSpeedFirst - (double)endSpeed) / avgSpeedFirst < 0.2 || (firstCount = firstThreeSecondsCarTrackList.stream().filter(track -> track.getExtendedTag() == 1).count()) + (secondCount = secondThreeSecondsCarTrackList.stream().filter(track -> track.getExtendedTag() == 1).count()) + (thirdCount = thirdThreeSecondsCarTrackList.stream().filter(track -> track.getExtendedTag() == 1).count()) + (fourthCount = fourthThreeSecondsCarTrackList.stream().filter(track -> track.getExtendedTag() == 1).count()) > 6L || (stopExpWarningCount = this.expWarningMapper.selectCount((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().ge(ExpWarning::getDataTime, (Object)endTime.minusMinutes(1L))).eq(ExpWarning::getOrientation, (Object)happenedCarTrack.getOrientation())).eq(ExpWarning::getFix, (Object)0)).eq(ExpWarning::getType, (Object)1)).eq(ExpWarning::getTempId, (Object)tempId)).longValue()) > 0L) continue;
            ArrayList<CarTrack> tempAllCarTrackList = new ArrayList<CarTrack>();
            tempAllCarTrackList.addAll(firstThreeSecondsCarTrackList);
            tempAllCarTrackList.addAll(secondThreeSecondsCarTrackList);
            tempAllCarTrackList.addAll(thirdThreeSecondsCarTrackList);
            tempAllCarTrackList.addAll(fourthThreeSecondsCarTrackList);
            boolean offset = false;
            LocalDateTime offsetTime = null;
            for (int i = 0; i < tempAllCarTrackList.size() - 1; ++i) {
                CarTrack current = (CarTrack)tempAllCarTrackList.get(i);
                CarTrack next = (CarTrack)tempAllCarTrackList.get(i + 1);
                int absDifference = Math.abs(next.getStartx() - current.getEndx());
                if (absDifference <= 30) continue;
                offset = true;
                offsetTime = current.getCurrentTime();
                break;
            }
            if (offset) {
                ArrayList<CarTrack> sendCarTrackList = new ArrayList<CarTrack>();
                for (CarTrack carTrack2 : tempAllCarTrackList) {
                    if (!carTrack2.getCurrentTime().isAfter(offsetTime)) continue;
                    sendCarTrackList.add(carTrack2);
                }
                if (sendCarTrackList.size() <= 4) continue;
                this.requestModel(sendCarTrackList, happenedCarTrack, endTime, filterAreaList);
                continue;
            }
            this.requestModel(twentyFourCarTrackList, happenedCarTrack, endTime, filterAreaList);
        }
    }

    public void requestModel(List<CarTrack> allCarTrackList, CarTrack happenedCarTrack, LocalDateTime endTime, List<SystemConfig> filterAreaList) {
        ArrayList<JSONObject> jsonObjectList = new ArrayList<JSONObject>();
        for (CarTrack sendCarTrack : allCarTrackList) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("orientation", (Object)sendCarTrack.getOrientation());
            jsonObject.put("startx", (Object)sendCarTrack.getStartx());
            jsonObject.put("endx", (Object)sendCarTrack.getEndx());
            jsonObject.put("speed", (Object)sendCarTrack.getSpeed());
            jsonObject.put("tempId", (Object)sendCarTrack.getTempId());
            jsonObject.put("time", (Object)sendCarTrack.getCurrentTimeStr());
            jsonObject.put("distance", (Object)sendCarTrack.getDistance());
            jsonObject.put("kName", (Object)sendCarTrack.getRealKName());
            jsonObjectList.add(jsonObject);
        }
        if (jsonObjectList.size() == 23) {
            CarTrack tempCarTrack = allCarTrackList.get(allCarTrackList.size() - 1);
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("orientation", (Object)tempCarTrack.getOrientation());
            jsonObject.put("startx", (Object)tempCarTrack.getEndx());
            jsonObject.put("endx", (Object)(tempCarTrack.getEndx() + (tempCarTrack.getEndx() - tempCarTrack.getStartx())));
            jsonObject.put("speed", (Object)tempCarTrack.getSpeed());
            jsonObject.put("tempId", (Object)tempCarTrack.getTempId());
            jsonObject.put("time", (Object)tempCarTrack.getCurrentTimeStr());
            jsonObject.put("distance", (Object)tempCarTrack.getDistance());
            jsonObject.put("kName", (Object)tempCarTrack.getRealKName());
            jsonObjectList.add(jsonObject);
        }
        Request request = new Request.Builder().url(this.modelUrl).post(RequestBody.create((MediaType)MediaType.get((String)"application/json;charset=utf-8"), (String)JSONUtil.toJsonStr(jsonObjectList))).build();
        HttpClientProvider.getHttpClient().newCall(request).enqueue((Callback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void singleCarSlow(LocalDateTime endTime, int orientation, List<SystemConfig> filterAreaList, List<CarTrack> allCarTrackList, List<CarTrack> currentCarTrackList) {
        SystemConfig systemConfig = (SystemConfig)this.systemConfigMapper.selectOne((Wrapper)Wrappers.lambdaQuery().eq(SystemConfig::getConfigType, (Object)"singleSlowSpeed"));
        int slowSpeed = Integer.parseInt(systemConfig.getConfigValue());
        List roadInfoList = this.roadInfoMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(RoadInfo::getType, (Object)2)).orderByAsc(RoadInfo::getRoadSort));
        Set tempIdSet = currentCarTrackList.stream().filter(carTrack -> carTrack.getOrientation() == orientation).map(CarTrack::getTempId).collect(Collectors.toSet());
        for (String tempId : tempIdSet) {
            long expWarningCount;
            List clonedList = (List)ObjectUtil.cloneByStream(allCarTrackList.stream().filter(carTrack -> carTrack.getTempId().equals(tempId)).filter(carTrack -> carTrack.getOrientation() == orientation).filter(carTrack -> carTrack.getExtendedTag() == 0).filter(carTrack -> carTrack.getCurrentTime().isAfter(endTime.minusSeconds(40L))).sorted(Comparator.comparing(CarTrack::getCurrentTime)).collect(Collectors.toList()));
            if (clonedList.size() < 35) continue;
            CarTrack happenedCarTrack = (CarTrack)clonedList.get(clonedList.size() - 1);
            float averageSpeed = (float)clonedList.stream().mapToDouble(CarTrack::getSpeed).average().orElse(0.0);
            if (averageSpeed >= (float)slowSpeed) continue;
            List expWarningList = this.expWarningMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().ge(ExpWarning::getDataTime, (Object)endTime.minusSeconds(900L))).le(ExpWarning::getDataTime, (Object)endTime.plusSeconds(900L))).ge(ExpWarning::getDistance, (Object)(happenedCarTrack.getDistance() - 400))).le(ExpWarning::getDistance, (Object)(happenedCarTrack.getDistance() + 400))).eq(ExpWarning::getOrientation, (Object)happenedCarTrack.getOrientation()));
            long multiCarStopCount = expWarningList.stream().filter(warning -> warning.getType() == 2).count();
            long congestionCount = expWarningList.stream().filter(warning -> warning.getType() == 4).count();
            if (multiCarStopCount > 0L || congestionCount > 0L || (expWarningCount = this.expWarningMapper.selectCount((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().ge(ExpWarning::getDataTime, (Object)endTime.minusMinutes(1L))).eq(ExpWarning::getOrientation, (Object)happenedCarTrack.getOrientation())).eq(ExpWarning::getTempId, (Object)happenedCarTrack.getTempId())).eq(ExpWarning::getType, (Object)5)).longValue()) > 0L || this.inFilterArea(happenedCarTrack, filterAreaList)) continue;
            ExpWarning expWarning = new ExpWarning();
            expWarning.setType(Integer.valueOf(5));
            expWarning.setTempId(happenedCarTrack.getTempId());
            expWarning.setMessage("[\u5355\u8f66\u6162\u901f\u9884\u8b66]" + happenedCarTrack.getOrientationName() + happenedCarTrack.getRealKName() + "\u5e73\u5747\u901f\u5ea6" + (int)averageSpeed + "km/h");
            expWarning.setWarningArea(happenedCarTrack.getRealKName());
            expWarning.setOrientation(happenedCarTrack.getOrientation());
            expWarning.setDistance(happenedCarTrack.getDistance());
            expWarning.setSpeed(Float.valueOf(averageSpeed));
            expWarning.setLongitude(happenedCarTrack.getLongitude());
            expWarning.setLatitude(happenedCarTrack.getLatitude());
            expWarning.setDataTime(happenedCarTrack.getCurrentTime());
            expWarning.setEndTime(endTime);
            expWarning.setCreateTime(LocalDateTime.now());
            expWarning.setState(Integer.valueOf(0));
            this.expWarningMapper.insert((Object)expWarning);
            this.gb28181SipService.recording(expWarning);
            for (CarTrack track : clonedList) {
                track.setExpWarningId(expWarning.getId());
                track.setTrackId(null);
                this.carTrackMapper.insert((Object)track);
            }
            try {
                this.warningSocketHandler.sendExpWarning(JSONUtil.toJsonStr((Object)expWarning));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void multipleCarSlowCongestion(LocalDateTime endTime, int orientation, List<SystemConfig> filterAreaList, List<CarTrack> carTrackList) {
        int slowSpeed = 45;
        int slowCarCount = 10;
        List systemConfigList = this.systemConfigMapper.selectList((Wrapper)Wrappers.lambdaQuery());
        for (SystemConfig systemConfig : systemConfigList) {
            if (systemConfig.getConfigType().equals("multipleSlowSpeed")) {
                slowSpeed = Integer.parseInt(systemConfig.getConfigValue());
            }
            if (!systemConfig.getConfigType().equals("multipleSlowCount")) continue;
            slowCarCount = Integer.parseInt(systemConfig.getConfigValue());
        }
        Object slowRoadListObject = this.redisTemplate.opsForValue().get((Object)(orientation + "-slowRoad"));
        List roadInfoList = slowRoadListObject == null ? this.roadInfoMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(RoadInfo::getType, (Object)2)).orderByAsc(RoadInfo::getRoadSort)) : JSONUtil.toList((String)slowRoadListObject.toString(), RoadInfo.class);
        ArrayList<CarTrack> tempTrackList = new ArrayList<CarTrack>();
        for (CarTrack recentTrack : carTrackList) {
            if (!recentTrack.getCurrentTime().isAfter(endTime.minusSeconds(1L)) || recentTrack.getOrientation() != orientation) continue;
            tempTrackList.add(recentTrack);
        }
        for (RoadInfo roadInfo : roadInfoList) {
            ArrayList<CarTrack> slowCarTrackList = new ArrayList<CarTrack>();
            for (CarTrack carTrack : tempTrackList) {
                if (carTrack.getExtendedTag() == 1 || carTrack.getDistance() < roadInfo.getStartDistance() || carTrack.getDistance() > roadInfo.getEndDistance() || this.inFilterArea(carTrack, filterAreaList)) continue;
                slowCarTrackList.add(carTrack);
            }
            float averageSpeed = (float)slowCarTrackList.stream().mapToDouble(CarTrack::getSpeed).average().orElse(0.0);
            if (roadInfo.getRoadStatus() == 3) {
                if (slowCarTrackList.size() < slowCarCount || !(averageSpeed < (float)slowSpeed)) continue;
                if (roadInfo.getCongestionTime() == null) {
                    roadInfo.setCongestionCount(1);
                } else if (LocalDateTime.now().minusSeconds(30L).isBefore(roadInfo.getCongestionTime())) {
                    roadInfo.setCongestionCount(roadInfo.getCongestionCount() + 1);
                } else {
                    roadInfo.setCongestionCount(1);
                }
                roadInfo.setCongestionTime(LocalDateTime.now());
                log.error(roadInfo.getRoadName() + "\u7b2c" + roadInfo.getCongestionCount() + "\u7f13\u884c,\u8f66\u8f86\u6570 = " + slowCarTrackList.size() + " \u5e73\u5747\u901f\u5ea6 = " + averageSpeed);
                System.out.println();
                if (roadInfo.getCongestionCount() != 4) continue;
                log.error(roadInfo.getRoadName() + "\u4ea7\u751f\u7f13\u884c");
                System.out.println();
                ExpWarning expWarning = new ExpWarning();
                String warningText = "[\u591a\u8f66\u7f13\u884c\u9884\u8b66]";
                roadInfo.setPassableCount(0);
                roadInfo.setPassableTime(null);
                roadInfo.setRoadStatus(2);
                expWarning.setType(Integer.valueOf(3));
                expWarning.setCreateTime(LocalDateTime.now());
                expWarning.setState(Integer.valueOf(0));
                expWarning.setRoadId(roadInfo.getId());
                expWarning.setOrientation(Integer.valueOf(orientation));
                expWarning.setDataTime(endTime.minusSeconds(2L));
                expWarning.setEndTime(endTime);
                String warningArea = slowCarTrackList.stream().map(CarTrack::getKName).distinct().collect(Collectors.joining(","));
                String tempIds = slowCarTrackList.stream().map(CarTrack::getTempId).distinct().collect(Collectors.joining(","));
                expWarning.setWarningArea(warningArea);
                expWarning.setTempId(tempIds);
                expWarning.setDistance(((CarTrack)slowCarTrackList.get(0)).getDistance());
                expWarning.setLongitude(((CarTrack)slowCarTrackList.get(0)).getLongitude());
                expWarning.setLatitude(((CarTrack)slowCarTrackList.get(0)).getLatitude());
                expWarning.setSpeed(Float.valueOf((float)Math.floor(averageSpeed)));
                expWarning.setMessage(warningText + ((CarTrack)slowCarTrackList.get(0)).getOrientationName() + warningArea + "\u901f\u5ea6" + expWarning.getSpeed().intValue() + "km/h");
                this.expWarningMapper.insert((Object)expWarning);
                this.gb28181SipService.recording(expWarning);
                try {
                    this.warningSocketHandler.sendExpWarning(JSONUtil.toJsonStr((Object)expWarning));
                    continue;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            if (roadInfo.getRoadStatus() != 1 && roadInfo.getRoadStatus() != 2 || !(averageSpeed >= (float)slowSpeed)) continue;
            if (roadInfo.getPassableTime() == null) {
                roadInfo.setPassableCount(1);
            } else if (LocalDateTime.now().minusSeconds(30L).isBefore(roadInfo.getPassableTime())) {
                roadInfo.setPassableCount(roadInfo.getPassableCount() + 1);
            } else {
                roadInfo.setPassableCount(1);
            }
            roadInfo.setPassableTime(LocalDateTime.now());
            log.error("\u7b2c" + roadInfo.getPassableCount() + "\u901a\u7545,\u8f66\u8f86\u6570 = " + slowCarTrackList.size() + " \u5e73\u5747\u901f\u5ea6 = " + averageSpeed);
            System.out.println();
            if (roadInfo.getPassableCount() != 8) continue;
            log.error("\u89e3\u9664\u7f13\u884c");
            roadInfo.setRoadStatus(3);
            roadInfo.setCongestionCount(0);
            roadInfo.setCongestionTime(null);
        }
        this.redisTemplate.opsForValue().set((Object)(orientation + "-slowRoad"), (Object)JSONUtil.toJsonStr((Object)roadInfoList));
    }

    public boolean inFilterArea(CarTrack carTrack, List<SystemConfig> filterAreaList) {
        boolean isWithinRange = false;
        for (SystemConfig filterArea : filterAreaList) {
            int startDistance = Integer.parseInt(filterArea.getConfigValue());
            int endDistance = Integer.parseInt(filterArea.getConfigValueExt());
            int orientation = Integer.parseInt(filterArea.getConfigValueExt2());
            if (orientation == 0) {
                if (carTrack.getDistance() < startDistance || carTrack.getDistance() > endDistance) continue;
                isWithinRange = true;
                continue;
            }
            if (carTrack.getDistance() < startDistance || carTrack.getDistance() > endDistance || carTrack.getOrientation() != orientation) continue;
            isWithinRange = true;
        }
        return isWithinRange;
    }

    public ExpWarning createWarning(CarTrack happenedCarTrack, LocalDateTime endTime, Integer type, List<SystemConfig> filterAreaList) {
        ExpWarning expWarning = new ExpWarning();
        expWarning.setType(type);
        if (type == 1) {
            expWarning.setMessage("[\u5355\u8f66\u505c\u8f66\u9884\u8b66]" + happenedCarTrack.getOrientationName() + happenedCarTrack.getRealKName() + "\u5e73\u5747\u901f\u5ea6" + happenedCarTrack.getSpeed().intValue() + "km/h");
        } else if (type == 2) {
            expWarning.setMessage("[\u591a\u8f66\u505c\u8f66\u9884\u8b66]" + happenedCarTrack.getOrientationName() + happenedCarTrack.getRealKName() + "\u5e73\u5747\u901f\u5ea6" + happenedCarTrack.getSpeed().intValue() + "km/h");
        } else if (type == 4) {
            expWarning.setMessage("[\u591a\u8f66\u62e5\u5835\u9884\u8b66]" + happenedCarTrack.getOrientationName() + happenedCarTrack.getRealKName() + "\u5e73\u5747\u901f\u5ea6" + happenedCarTrack.getSpeed().intValue() + "km/h");
        }
        expWarning.setWarningArea(happenedCarTrack.getRealKName());
        expWarning.setTempId(happenedCarTrack.getTempId());
        expWarning.setOrientation(happenedCarTrack.getOrientation());
        expWarning.setSpeed(happenedCarTrack.getSpeed());
        expWarning.setLongitude(happenedCarTrack.getLongitude());
        expWarning.setLatitude(happenedCarTrack.getLatitude());
        expWarning.setDataTime(happenedCarTrack.getCurrentTime());
        expWarning.setEndTime(endTime);
        expWarning.setState(Integer.valueOf(0));
        expWarning.setDistance(happenedCarTrack.getDistance());
        expWarning.setCreateTime(LocalDateTime.now());
        expWarning.setUpgrade(Integer.valueOf(0));
        this.inFilterArea(happenedCarTrack, filterAreaList);
        if (this.inFilterArea(happenedCarTrack, filterAreaList)) {
            expWarning.setUpgrade(Integer.valueOf(1));
        } else {
            expWarning.setUpgrade(Integer.valueOf(0));
        }
        return expWarning;
    }

    static /* synthetic */ DotDataMapper access$000(CarTrackV2ServiceImpl x0) {
        return x0.dotDataMapper;
    }

    static /* synthetic */ ExpWarningMapper access$100(CarTrackV2ServiceImpl x0) {
        return x0.expWarningMapper;
    }

    static /* synthetic */ Gb28181SipService access$200(CarTrackV2ServiceImpl x0) {
        return x0.gb28181SipService;
    }

    static /* synthetic */ WarningSocketHandler access$300(CarTrackV2ServiceImpl x0) {
        return x0.warningSocketHandler;
    }

    static /* synthetic */ CarTrackMapper access$400(CarTrackV2ServiceImpl x0) {
        return x0.carTrackMapper;
    }
}

