/*
 * Decompiled with CFR 0.152.
 */
package com.shengmu.utils;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Cipher;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class RSAUtils {
    public static final String CHARSET = "UTF-8";
    public static final String RSA_ALGORITHM = "RSA";

    public static Map<String, String> createKeys(int keySize) {
        KeyPairGenerator kpg;
        try {
            kpg = KeyPairGenerator.getInstance("RSA");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException("No such algorithm-->[RSA]");
        }
        kpg.initialize(keySize);
        KeyPair keyPair = kpg.generateKeyPair();
        PublicKey publicKey = keyPair.getPublic();
        String publicKeyStr = Base64.encodeBase64URLSafeString((byte[])publicKey.getEncoded());
        PrivateKey privateKey = keyPair.getPrivate();
        String privateKeyStr = Base64.encodeBase64URLSafeString((byte[])privateKey.getEncoded());
        HashMap<String, String> keyPairMap = new HashMap<String, String>();
        keyPairMap.put("publicKey", publicKeyStr);
        keyPairMap.put("privateKey", privateKeyStr);
        return keyPairMap;
    }

    public static RSAPublicKey getPublicKey(String publicKey) throws NoSuchAlgorithmException, InvalidKeySpecException {
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        X509EncodedKeySpec x509KeySpec = new X509EncodedKeySpec(Base64.decodeBase64((String)publicKey));
        RSAPublicKey key = (RSAPublicKey)keyFactory.generatePublic(x509KeySpec);
        return key;
    }

    public static RSAPrivateKey getPrivateKey(String privateKey) throws NoSuchAlgorithmException, InvalidKeySpecException {
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        PKCS8EncodedKeySpec pkcs8KeySpec = new PKCS8EncodedKeySpec(Base64.decodeBase64((String)privateKey));
        RSAPrivateKey key = (RSAPrivateKey)keyFactory.generatePrivate(pkcs8KeySpec);
        return key;
    }

    public static String publicEncrypt(String data, RSAPublicKey publicKey) {
        try {
            Cipher cipher = Cipher.getInstance("RSA");
            cipher.init(1, publicKey);
            return Base64.encodeBase64URLSafeString((byte[])RSAUtils.rsaSplitCodec((Cipher)cipher, (int)1, (byte[])data.getBytes("UTF-8"), (int)publicKey.getModulus().bitLength()));
        }
        catch (Exception e) {
            throw new RuntimeException("\u52a0\u5bc6\u5b57\u7b26\u4e32[" + data + "]\u65f6\u9047\u5230\u5f02\u5e38", e);
        }
    }

    public static String privateDecrypt(String data, RSAPrivateKey privateKey) {
        try {
            Cipher cipher = Cipher.getInstance("RSA");
            cipher.init(2, privateKey);
            return new String(RSAUtils.rsaSplitCodec((Cipher)cipher, (int)2, (byte[])Base64.decodeBase64((String)data), (int)privateKey.getModulus().bitLength()), "UTF-8");
        }
        catch (Exception e) {
            throw new RuntimeException("\u89e3\u5bc6\u5b57\u7b26\u4e32[" + data + "]\u65f6\u9047\u5230\u5f02\u5e38", e);
        }
    }

    public static String privateEncrypt(String data, RSAPrivateKey privateKey) {
        try {
            Cipher cipher = Cipher.getInstance("RSA");
            cipher.init(1, privateKey);
            return Base64.encodeBase64URLSafeString((byte[])RSAUtils.rsaSplitCodec((Cipher)cipher, (int)1, (byte[])data.getBytes("UTF-8"), (int)privateKey.getModulus().bitLength()));
        }
        catch (Exception e) {
            throw new RuntimeException("\u52a0\u5bc6\u5b57\u7b26\u4e32[" + data + "]\u65f6\u9047\u5230\u5f02\u5e38", e);
        }
    }

    public static String publicDecrypt(String data, RSAPublicKey publicKey) {
        try {
            Cipher cipher = Cipher.getInstance("RSA");
            cipher.init(2, publicKey);
            return new String(RSAUtils.rsaSplitCodec((Cipher)cipher, (int)2, (byte[])Base64.decodeBase64((String)data), (int)publicKey.getModulus().bitLength()), "UTF-8");
        }
        catch (Exception e) {
            throw new RuntimeException("\u89e3\u5bc6\u5b57\u7b26\u4e32[" + data + "]\u65f6\u9047\u5230\u5f02\u5e38", e);
        }
    }

    private static byte[] rsaSplitCodec(Cipher cipher, int opmode, byte[] datas, int keySize) {
        int maxBlock = 0;
        maxBlock = opmode == 2 ? keySize / 8 : keySize / 8 - 11;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int offSet = 0;
        int i = 0;
        try {
            while (datas.length > offSet) {
                byte[] buff = datas.length - offSet > maxBlock ? cipher.doFinal(datas, offSet, maxBlock) : cipher.doFinal(datas, offSet, datas.length - offSet);
                out.write(buff, 0, buff.length);
                offSet = ++i * maxBlock;
            }
        }
        catch (Exception e) {
            throw new RuntimeException("\u52a0\u89e3\u5bc6\u9600\u503c\u4e3a[" + maxBlock + "]\u7684\u6570\u636e\u65f6\u53d1\u751f\u5f02\u5e38", e);
        }
        byte[] resultDatas = out.toByteArray();
        IOUtils.closeQuietly((OutputStream)out);
        return resultDatas;
    }

    public static void main(String[] args) throws Exception {
        Map keyMap = RSAUtils.createKeys((int)1024);
        String publicKey = (String)keyMap.get("publicKey");
        String privateKey = (String)keyMap.get("privateKey");
        System.out.println("\u516c\u94a5: \n\r" + publicKey);
        System.out.println("\u79c1\u94a5\uff1a \n\r" + privateKey);
        System.out.println("\u516c\u94a5\u52a0\u5bc6\u2014\u2014\u79c1\u94a5\u89e3\u5bc6");
        String str = "\u7ad9\u5728\u5927\u660e\u95e8\u524d\u5b88\u536b\u7684\u7981\u536b\u519b\uff0c\u4e8b\u5148\u6ca1\u6709\u63a5\u5230\n\u6709\u5173\u7684\u547d\u4ee4\uff0c\u4f46\u770b\u5230\u5927\u6279\u76db\u88c5\u7684\u5b98\u5458\u6765\u4e34\uff0c\u4e5f\u5c31\n\u4ee5\u4e3a\u786e\u7cfb\u4e3e\u884c\u5927\u5178\uff0c\u56e0\u800c\u672a\u52a0\u8be2\u95ee\u3002\u8fdb\u5927\u660e\u95e8\u5373\n\u4e3a\u7687\u57ce\u3002\u6587\u6b66\u767e\u5b98\u770b\u5230\u7aef\u95e8\u5348\u95e8\u4e4b\u524d\u6c14\u6c1b\u5e73\u9759\uff0c\n\u57ce\u697c\u4e0a\u4e0b\u4e5f\u65e0\u671d\u4f1a\u7684\u8ff9\u8c61\uff0c\u65e2\u65e0\u51e0\u6848\uff0c\u7ad9\u961f\u70b9\u540d\n\u7684\u5fa1\u53f2\u548c\u5fa1\u524d\u4f8d\u536b\u201c\u5927\u6c49\u5c06\u519b\u201d\u4e5f\u4e0d\u89c1\u8e2a\u5f71\uff0c\u4e0d\u514d\n\u5fc3\u4e2d\u63e3\u6d4b\uff0c\u4e92\u76f8\u8be2\u95ee\uff1a\u6240\u8c13\u5348\u671d\u662f\u5426\u8bb9\u4f20\uff1f";
        System.out.println("\r\u660e\u6587\uff1a\r\n" + str);
        System.out.println("\r\u660e\u6587\u5927\u5c0f\uff1a\r\n" + str.getBytes().length);
        String encodedData = RSAUtils.publicEncrypt((String)str, (RSAPublicKey)RSAUtils.getPublicKey((String)publicKey));
        System.out.println("\u5bc6\u6587\uff1a\r\n" + encodedData);
        String decodedData = RSAUtils.privateDecrypt((String)encodedData, (RSAPrivateKey)RSAUtils.getPrivateKey((String)privateKey));
        System.out.println("\u89e3\u5bc6\u540e\u6587\u5b57: \r\n" + decodedData);
    }
}

