/*
 * Decompiled with CFR 0.152.
 */
package com.shengmu.websocket;

import java.util.concurrent.ConcurrentHashMap;
import org.springframework.web.socket.CloseStatus;
import org.springframework.web.socket.TextMessage;
import org.springframework.web.socket.WebSocketMessage;
import org.springframework.web.socket.WebSocketSession;
import org.springframework.web.socket.handler.TextWebSocketHandler;

public class WarningSocketHandler
extends TextWebSocketHandler {
    public static int expWarningType = 1;
    public static int upCarTrackType = 2;
    public static int downCarTrackType = 3;
    public static int upCarCountChartType = 4;
    public static int downCarCountChartType = 5;
    private ConcurrentHashMap<String, WebSocketSession> sessions = new ConcurrentHashMap();

    public void sendExpWarning(String message) throws Exception {
        for (WebSocketSession session : this.sessions.values()) {
            if (!session.isOpen()) continue;
            session.sendMessage((WebSocketMessage)new TextMessage((CharSequence)(expWarningType + message)));
        }
    }

    public void sendUpCarTrack(String message) throws Exception {
        for (WebSocketSession session : this.sessions.values()) {
            if (!session.isOpen()) continue;
            session.sendMessage((WebSocketMessage)new TextMessage((CharSequence)(upCarTrackType + message)));
        }
    }

    public void sendDownCarTrack(String message) throws Exception {
        for (WebSocketSession session : this.sessions.values()) {
            if (!session.isOpen()) continue;
            session.sendMessage((WebSocketMessage)new TextMessage((CharSequence)(downCarTrackType + message)));
        }
    }

    public void sendUpCarCountChart(String message) throws Exception {
        for (WebSocketSession session : this.sessions.values()) {
            if (!session.isOpen()) continue;
            session.sendMessage((WebSocketMessage)new TextMessage((CharSequence)(upCarCountChartType + message)));
        }
    }

    public void sendDownCarCountChart(String message) throws Exception {
        for (WebSocketSession session : this.sessions.values()) {
            if (!session.isOpen()) continue;
            session.sendMessage((WebSocketMessage)new TextMessage((CharSequence)(downCarCountChartType + message)));
        }
    }

    public void afterConnectionEstablished(WebSocketSession session) throws Exception {
        this.sessions.put(session.getId(), session);
        super.afterConnectionEstablished(session);
    }

    public void afterConnectionClosed(WebSocketSession session, CloseStatus status) {
        this.sessions.remove(session.getId());
    }

    protected void handleTextMessage(WebSocketSession session, TextMessage message) {
    }
}

